/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.tokens;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.staticanalyses.tokens.IDynamicTokenTypeRelationDetector;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import edu.ksu.cis.indus.staticanalyses.tokens.ITypeManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTokenManager<T extends ITokens<T, V>, V, R>
implements ITokenManager<T, V, R>,
Observer {
    protected final IDynamicTokenTypeRelationDetector<V> onlineTokenTypeRelationEvalutator;
    protected final ITypeManager<R, V> typeMgr;
    private final Map<IType, ITokenFilter<T, V>> type2filter = new HashMap<IType, ITokenFilter<T, V>>();

    public AbstractTokenManager(ITypeManager<R, V> typeManager) {
        this.typeMgr = typeManager;
        this.onlineTokenTypeRelationEvalutator = typeManager.getDynamicTokenTypeRelationEvaluator();
    }

    @Override
    public final ITokenFilter<T, V> getTypeBasedFilter(IType type) {
        ITokenFilter<T, V> _result = this.type2filter.get(type);
        if (_result == null) {
            _result = this.getNewFilterForType(type);
            this.type2filter.put(type, _result);
        }
        return _result;
    }

    @Override
    public ITypeManager<R, V> getTypeManager() {
        return this.typeMgr;
    }

    @Override
    public void reset() {
        this.typeMgr.reset();
        this.type2filter.clear();
    }

    @Override
    public final void update(Observable observer, Object arg) {
        if (arg instanceof ITypeManager.NewTypeCreated && this.onlineTokenTypeRelationEvalutator != null) {
            IType _type = ((ITypeManager.NewTypeCreated)arg).getCreatedType();
            Collection<V> _values = this.onlineTokenTypeRelationEvalutator.getValuesConformingTo(this.getValues(), _type);
            if (!_values.isEmpty()) {
                this.recordNewTokenTypeRelations(_values, _type);
            }
        }
    }

    protected abstract ITokenFilter<T, V> getNewFilterForType(IType var1);

    protected Collection<V> getValues() {
        return Collections.emptySet();
    }

    @Empty
    protected void recordNewTokenTypeRelations(Collection<V> values, IType type) {
    }
}

