/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.processing;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnalysesController.class);
    protected final Map<Comparable, Collection<? extends IAnalysis>> participatingAnalyses;
    protected final ProcessingController preprocessController;
    private final IActivePart.ActivePart activePart = new IActivePart.ActivePart();
    private BasicBlockGraphMgr basicBlockGraphMgr;
    private Map<Comparable<?>, Object> info;

    public AnalysesController(Map<Comparable<?>, Object> infoPrm, ProcessingController pc, BasicBlockGraphMgr bbgMgr) {
        this.participatingAnalyses = new HashMap<Comparable, Collection<? extends IAnalysis>>();
        this.info = infoPrm;
        this.preprocessController = pc;
        this.basicBlockGraphMgr = bbgMgr;
    }

    public final void addAnalyses(Comparable<?> id, Collection<? extends IAnalysis> analyses) {
        MapUtils.putAllIntoCollectionInMap(this.participatingAnalyses, id, analyses);
    }

    public void execute() {
        boolean _analyzing;
        ArrayList<IAnalysis> _done = new ArrayList<IAnalysis>();
        do {
            _analyzing = false;
            Iterator<Comparable> _i = this.participatingAnalyses.keySet().iterator();
            while (_i.hasNext() && this.activePart.canProceed()) {
                Comparable _daName = _i.next();
                Collection<? extends IAnalysis> _c = this.participatingAnalyses.get(_daName);
                for (IAnalysis iAnalysis : _c) {
                    if (iAnalysis == null || _done.contains(iAnalysis)) continue;
                    iAnalysis.analyze();
                    boolean _t = iAnalysis.isStable();
                    if (_t) {
                        _done.add(iAnalysis);
                    }
                    _analyzing |= _t;
                }
            }
        } while (_analyzing);
    }

    public IActivePart getActivePart() {
        return this.activePart;
    }

    public final Collection<? extends IAnalysis> getAnalyses(Comparable<?> id) {
        Collection<? extends IAnalysis> _result = this.participatingAnalyses != null ? this.participatingAnalyses.get(id) : null;
        return _result;
    }

    public void initialize() {
        ArrayList<Comparable> _failed = new ArrayList<Comparable>();
        HashSet<IProcessor> _preprocessors = new HashSet<IProcessor>();
        Iterator<Comparable> _k = this.participatingAnalyses.keySet().iterator();
        while (_k.hasNext() && this.activePart.canProceed()) {
            Comparable _key = _k.next();
            Collection<? extends IAnalysis> _c = this.participatingAnalyses.get(_key);
            Iterator<? extends IAnalysis> _j = _c.iterator();
            while (_j.hasNext() && this.activePart.canProceed()) {
                IAnalysis _analysis = _j.next();
                try {
                    _analysis.initialize(this.info);
                    if (_analysis.doesPreProcessing()) {
                        IProcessor _p = _analysis.getPreProcessor();
                        _p.hookup(this.preprocessController);
                        _preprocessors.add(_p);
                    }
                    if (this.basicBlockGraphMgr == null) continue;
                    _analysis.setBasicBlockGraphManager(this.basicBlockGraphMgr);
                }
                catch (InitializationException _e) {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn(_analysis.getClass() + " failed to initialize, hence, it will not executed.", (Throwable)_e);
                    }
                    _failed.add(_key);
                    if (!_analysis.doesPreProcessing()) continue;
                    _preprocessors.remove(_analysis.getPreProcessor());
                }
            }
            Iterator _i = _failed.iterator();
            while (_i.hasNext()) {
                _c.remove(_i.next());
            }
        }
        if (this.activePart.canProceed()) {
            this.preprocessController.process();
        }
        Iterator _i = _preprocessors.iterator();
        while (_i.hasNext()) {
            ((IProcessor)_i.next()).unhook(this.preprocessController);
        }
    }

    public void reset() {
        for (Collection<? extends IAnalysis> _c : this.participatingAnalyses.values()) {
            for (IAnalysis iAnalysis : _c) {
                iAnalysis.reset();
            }
        }
        this.participatingAnalyses.clear();
        this.activePart.activate();
    }
}

