/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.interfaces;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.AbstractStatus;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalysis
extends AbstractStatus
implements IAnalysis {
    protected final Map<Comparable<?>, Object> info = new HashMap();
    protected IProcessor preprocessor;
    private BasicBlockGraphMgr graphManager;

    @Override
    public abstract void analyze();

    @Override
    public boolean doesPreProcessing() {
        return this.preprocessor != null;
    }

    @Override
    public IProcessor getPreProcessor() {
        return this.preprocessor;
    }

    public String getStatistics() {
        return this.getClass() + " does not implement this method.";
    }

    @Override
    public final void initialize(Map<Comparable<?>, Object> infoParam) throws InitializationException {
        this.info.putAll(infoParam);
        this.setup();
    }

    @Override
    public void reset() {
        this.unstable();
        this.info.clear();
    }

    @Override
    public void setBasicBlockGraphManager(BasicBlockGraphMgr bbm) {
        this.graphManager = bbm;
    }

    protected BasicBlockGraph getBasicBlockGraph(SootMethod method) {
        return this.graphManager.getBasicBlockGraph(method);
    }

    protected List<Stmt> getStmtList(SootMethod method) {
        UnitGraph _stmtGraph;
        List<Object> _result = this.graphManager != null ? this.graphManager.getStmtList(method) : ((_stmtGraph = this.graphManager.getStmtGraph(method)) != null ? Collections.unmodifiableList(new ArrayList(_stmtGraph.getBody().getUnits())) : Collections.emptyList());
        return _result;
    }

    protected UnitGraph getUnitGraph(SootMethod method) {
        return this.graphManager.getStmtGraph(method);
    }

    @Empty
    protected void setup() throws InitializationException {
    }
}

