/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.impl;

import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.AbstractCallingContextRetriever;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.ICallingContextRetriever;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataAliasBasedCallingContextRetriever
extends AbstractCallingContextRetriever {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataAliasBasedCallingContextRetriever.class);
    private CFGAnalysis analysis;
    private final Collection<ICallGraphInfo.CallTriple> previous = new HashSet<ICallGraphInfo.CallTriple>();
    private IThreadGraphInfo tgi;

    public DataAliasBasedCallingContextRetriever(int callingContextLengthLimit) {
        super(callingContextLengthLimit);
    }

    public final void setCfgAnalysis(CFGAnalysis cfgAnalysis) {
        this.analysis = cfgAnalysis;
    }

    public final void setThreadGraph(IThreadGraphInfo threadgraph) {
        this.tgi = threadgraph;
    }

    protected boolean considerProgramPoint(Context programPointContext) {
        boolean _result;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("considerProgramPoint(Context programPointContext = " + programPointContext + ") - BEGIN");
        }
        Stmt _srcStmt = (Stmt)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_ENTITY);
        Stmt _curStmt = programPointContext.getStmt();
        SootMethod _curMethod = programPointContext.getCurrentMethod();
        if (_curMethod.isStatic() && _curMethod.getName().equals("<clinit>")) {
            return true;
        }
        boolean _sameMethod = _curMethod.equals(this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_METHOD));
        ArrayRef _curRef = null;
        ArrayRef _srcRef = null;
        if (_curStmt.containsArrayRef() && _srcStmt.containsArrayRef()) {
            _curRef = _curStmt.getArrayRef();
            _srcRef = _srcStmt.getArrayRef();
        } else if (_curStmt.containsFieldRef() && _srcStmt.containsFieldRef()) {
            _curRef = _curStmt.getFieldRef();
            _srcRef = _srcStmt.getFieldRef();
            if (((FieldRef)_curRef).getField().isFinal()) {
                return true;
            }
        }
        boolean bl = _result = _curRef != null && _curStmt instanceof DefinitionStmt && _srcStmt instanceof DefinitionStmt;
        if (_result) {
            DefinitionStmt _curDefStmt = (DefinitionStmt)_curStmt;
            DefinitionStmt _srcDefStmt = (DefinitionStmt)_srcStmt;
            _result = _curRef == _curDefStmt.getRightOp() && _srcRef == _srcDefStmt.getLeftOp() ? (_sameMethod ? this.analysis.doesControlFlowPathExistBetween((Stmt)_srcDefStmt, (Stmt)_curDefStmt, _curMethod) : this.analysis.isReachableViaInterProceduralControlFlow((SootMethod)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_METHOD), (Stmt)_srcDefStmt, _curMethod, (Stmt)_curDefStmt, this.tgi, false)) : (_sameMethod ? this.analysis.doesControlFlowPathExistBetween((Stmt)_curDefStmt, (Stmt)_srcDefStmt, _curMethod) : this.analysis.isReachableViaInterProceduralControlFlow(_curMethod, (Stmt)_curDefStmt, (SootMethod)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_METHOD), (Stmt)_srcDefStmt, this.tgi, false));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("considerProgramPoint() - END - return value = " + _result);
        }
        return _result;
    }

    protected Object getCallerSideToken(Object token, SootMethod callee, ICallGraphInfo.CallTriple callsite, Stack<ICallGraphInfo.CallTriple> calleeCallStack) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getCallerSideToken(Object token = " + token + ", SootMethod callee = " + callee + ", CallTriple callsite = " + callsite + ") - BEGIN");
        }
        Object _result = AbstractCallingContextRetriever.Tokens.DISCARD_CONTEXT_TOKEN;
        Collection _ancestors = (Collection)token;
        if (!Util.isStartMethod((SootMethod)callee) && _ancestors.contains(callsite)) {
            HashSet<ICallGraphInfo.CallTriple> _col = new HashSet<ICallGraphInfo.CallTriple>();
            this.previous.add(callsite);
            for (ICallGraphInfo.CallTriple _ctrp : this.getCallGraph().getCallers(callsite.getMethod())) {
                if (!this.getCallSitesThatCanReachSource(_ctrp, false)) continue;
                _col.add(_ctrp);
            }
            _col.removeAll(this.previous);
            _result = !_col.isEmpty() ? _col : AbstractCallingContextRetriever.Tokens.ACCEPT_TERMINAL_CONTEXT_TOKEN;
        } else if (_ancestors.contains(null)) {
            _result = AbstractCallingContextRetriever.Tokens.ACCEPT_TERMINAL_CONTEXT_TOKEN;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getCallerSideToken() - END - return value = " + _result);
        }
        return _result;
    }

    protected final boolean getCallSitesThatCanReachSource(ICallGraphInfo.CallTriple callsite, boolean exclusive) {
        Stmt _stmt1;
        SootMethod _method1;
        Stack _srcCallingContext = (Stack)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_CALLING_CONTEXT);
        if (_srcCallingContext != null && !_srcCallingContext.isEmpty() && _srcCallingContext.peek() != null) {
            ICallGraphInfo.CallTriple _topCallSiteOnSrcEnd = (ICallGraphInfo.CallTriple)_srcCallingContext.peek();
            _method1 = _topCallSiteOnSrcEnd.getMethod();
            _stmt1 = _topCallSiteOnSrcEnd.getStmt();
        } else {
            _method1 = (SootMethod)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_METHOD);
            _stmt1 = (Stmt)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_ENTITY);
        }
        boolean _flag = this.isSourceADefSite();
        SootMethod _method2 = callsite.getMethod();
        Stmt _stmt2 = callsite.getStmt();
        boolean _result = false;
        if (_method1 == _method2) {
            _result = _flag ? this.analysis.doesControlFlowPathExistBetween(_stmt1, _stmt2, _method1) : this.analysis.doesControlFlowPathExistBetween(_stmt2, _stmt1, _method1);
        }
        if (!_result) {
            _result = _flag ? this.analysis.isReachableViaInterProceduralControlFlow(_method1, _stmt1, _method2, _stmt2, this.tgi, exclusive) : this.analysis.isReachableViaInterProceduralControlFlow(_method2, _stmt2, _method1, _stmt1, this.tgi, exclusive);
        }
        return _result;
    }

    protected Object getTokenForProgramPoint(Context programPointContext) {
        Object _result;
        SootMethod _curMethod;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTokenForProgramPoint(Context programPointContext = " + programPointContext + ") - BEGIN");
        }
        if ((_curMethod = programPointContext.getCurrentMethod()).isStatic() && _curMethod.getName().equals("<clinit>")) {
            return AbstractCallingContextRetriever.Tokens.CONSIDER_ALL_CONTEXTS_TOKEN;
        }
        DefinitionStmt _curDefStmt = (DefinitionStmt)programPointContext.getStmt();
        DefinitionStmt _srcDefStmt = (DefinitionStmt)((Stmt)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_ENTITY));
        ArrayRef _curRef = null;
        ArrayRef _srcRef = null;
        if (_curDefStmt.containsArrayRef() && _srcDefStmt.containsArrayRef()) {
            _curRef = _curDefStmt.getArrayRef();
            _srcRef = _srcDefStmt.getArrayRef();
        } else if (_curDefStmt.containsFieldRef() && _srcDefStmt.containsFieldRef()) {
            _curRef = _curDefStmt.getFieldRef();
            _srcRef = _srcDefStmt.getFieldRef();
            if (((FieldRef)_curRef).getField().isFinal()) {
                return AbstractCallingContextRetriever.Tokens.CONSIDER_ALL_CONTEXTS_TOKEN;
            }
        }
        if (_curRef == null) {
            _result = Collections.emptySet();
        } else {
            SootMethod _useMethod;
            DefinitionStmt _useStmt;
            SootMethod _defMethod;
            DefinitionStmt _defStmt;
            SootMethod _srcMethod = (SootMethod)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_METHOD);
            if (_curRef == _curDefStmt.getRightOp() && _srcRef == _srcDefStmt.getLeftOp()) {
                _defStmt = _srcDefStmt;
                _defMethod = _srcMethod;
                _useStmt = _curDefStmt;
                _useMethod = _curMethod;
            } else {
                _defStmt = _curDefStmt;
                _defMethod = _curMethod;
                _useStmt = _srcDefStmt;
                _useMethod = _srcMethod;
            }
            _result = this.retrieveToken(_defMethod, _defStmt, _useMethod, _useStmt, _curMethod);
        }
        this.previous.clear();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getTokenForProgramPoint() - END - return value = " + _result);
        }
        return _result;
    }

    private void checkReachabilityFromCallersAndUpdateAncestors(Stmt stmt, SootMethod method, Collection<ICallGraphInfo.CallTriple> ancestors, Collection<ICallGraphInfo.CallTriple> callers, boolean isSource) {
        Iterator<ICallGraphInfo.CallTriple> _i = callers.iterator();
        while (_i.hasNext()) {
            ICallGraphInfo.CallTriple _destCallTriple = _i.next();
            SootMethod _destMethod = _destCallTriple.getMethod();
            Stmt _destStmt = _destCallTriple.getStmt();
            boolean _flag = false;
            if (_destMethod == method) {
                _flag = isSource ? this.analysis.doesControlFlowPathExistBetween(stmt, _destStmt, _destMethod) : this.analysis.doesControlFlowPathExistBetween(_destStmt, stmt, _destMethod);
            }
            if (!_flag) {
                _flag = isSource ? this.analysis.isReachableViaInterProceduralControlFlow(method, stmt, _destMethod, _destStmt, this.tgi, true) : this.analysis.isReachableViaInterProceduralControlFlow(_destMethod, _destStmt, method, stmt, this.tgi, true);
            }
            if (!_flag) continue;
            ancestors.add(_destCallTriple);
            _i.remove();
        }
    }

    protected final boolean isSourceADefSite() {
        DefinitionStmt _stmt = (DefinitionStmt)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_ENTITY);
        Value _leftOp = _stmt.getLeftOp();
        boolean _result = _leftOp instanceof ArrayRef || _leftOp instanceof FieldRef;
        return _result;
    }

    private Collection<ICallGraphInfo.CallTriple> retrieveAncestors(SootMethod defMethod, SootMethod useMethod, DefinitionStmt defStmt, DefinitionStmt useStmt, SootMethod curMethod) {
        HashSet<ICallGraphInfo.CallTriple> _ancestors = new HashSet<ICallGraphInfo.CallTriple>();
        ICallGraphInfo _callGraph = this.getCallGraph();
        Stack _stack = (Stack)this.getInfoFor((Comparable)ICallingContextRetriever.Identifiers.SRC_CALLING_CONTEXT);
        HashSet<ICallGraphInfo.CallTriple> _callers = new HashSet<ICallGraphInfo.CallTriple>(_callGraph.getCallers(curMethod));
        boolean _curMethodIsUseMethod = useMethod == curMethod;
        if (_stack != null && !_stack.isEmpty()) {
            for (ICallGraphInfo.CallTriple _srcCallTriple : _stack) {
                if (_srcCallTriple != null) {
                    Stmt _srcStmt = _srcCallTriple.getStmt();
                    SootMethod _srcMethod = _srcCallTriple.getMethod();
                    this.checkReachabilityFromCallersAndUpdateAncestors(_srcStmt, _srcMethod, _ancestors, _callers, _curMethodIsUseMethod);
                }
                if (!defMethod.equals(useMethod) || !this.analysis.doesControlFlowPathExistBetween((Stmt)defStmt, (Stmt)useStmt, defMethod)) continue;
                _ancestors.add(_srcCallTriple);
            }
        } else if (defMethod.equals(useMethod) && this.analysis.doesControlFlowPathExistBetween((Stmt)defStmt, (Stmt)useStmt, defMethod)) {
            _ancestors.addAll(_callers);
        } else {
            SootMethod _method;
            DefinitionStmt _stmt;
            if (_curMethodIsUseMethod) {
                _stmt = defStmt;
                _method = defMethod;
            } else {
                _stmt = useStmt;
                _method = useMethod;
            }
            this.checkReachabilityFromCallersAndUpdateAncestors((Stmt)_stmt, _method, _ancestors, _callers, _curMethodIsUseMethod);
        }
        return _ancestors;
    }

    private Object retrieveToken(SootMethod defMethod, DefinitionStmt defStmt, SootMethod useMethod, DefinitionStmt useStmt, SootMethod curMethod) {
        Collection<ICallGraphInfo.CallTriple> _t = this.retrieveAncestors(defMethod, useMethod, defStmt, useStmt, curMethod);
        Object _result = _t.isEmpty() ? AbstractCallingContextRetriever.Tokens.DISCARD_CONTEXT_TOKEN : _t;
        return _result;
    }
}

