/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.impl;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.graph.IMutableNode;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.graph.SimpleNode;
import edu.ksu.cis.indus.common.graph.SimpleNodeGraph;
import edu.ksu.cis.indus.interfaces.IClassHierarchy;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.StaticEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassHierarchy
extends AbstractProcessor
implements IClassHierarchy {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassHierarchy.class);
    private final Map<SootClass, Collection<SootClass>> class2properAncestorClasses = new HashMap<SootClass, Collection<SootClass>>();
    private final Map<SootClass, Collection<SootClass>> class2properAncestorInterfaces = new HashMap<SootClass, Collection<SootClass>>();
    private final Map<SootClass, Collection<SootClass>> class2properChildren = new HashMap<SootClass, Collection<SootClass>>();
    private final Map<SootClass, Collection<SootClass>> class2properDescendants = new HashMap<SootClass, Collection<SootClass>>();
    private final Map<SootClass, SootClass> class2properParentClass = new HashMap<SootClass, SootClass>();
    private final Map<SootClass, Collection<SootClass>> class2properParentInterfaces = new HashMap<SootClass, Collection<SootClass>>();
    private final Collection<SootClass> classes = new HashSet<SootClass>();
    private SimpleNodeGraph<SootClass> classHierarchy;
    private final Collection<SootClass> interfaces = new HashSet<SootClass>();

    public static ClassHierarchy createClassHierarchyFrom(Collection<SootClass> classes) {
        ClassHierarchy _result = new ClassHierarchy();
        ProcessingController _pc = new ProcessingController();
        HashSet _temp = new HashSet();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_temp);
        _wb.addAllWork(classes);
        while (_wb.hasWork()) {
            SootClass _sc = (SootClass)_wb.getWork();
            _wb.addAllWorkNoDuplicates((Collection)_sc.getInterfaces());
            if (!_sc.hasSuperclass()) continue;
            _wb.addWorkNoDuplicates((Object)_sc.getSuperclass());
        }
        _pc.setEnvironment((IEnvironment)new StaticEnvironment(_temp));
        _result.hookup(_pc);
        _pc.process();
        _result.unhook(_pc);
        return _result;
    }

    public void callback(SootClass clazz) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("callback(SootClass clazz = " + clazz + ") - BEGIN");
        }
        SimpleNode _classNode = this.classHierarchy.getNode((Object)clazz);
        if (clazz.hasSuperclass()) {
            SimpleNode _superClassNode = this.classHierarchy.getNode((Object)clazz.getSuperclass());
            this.classHierarchy.addEdgeFromTo((IMutableNode)_superClassNode, (IMutableNode)_classNode);
        }
        Chain _interfaces = clazz.getInterfaces();
        Iterator _i = _interfaces.iterator();
        int _iEnd = _interfaces.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _interfaceClass = (SootClass)_i.next();
            SimpleNode _superinterfaceNode = this.classHierarchy.getNode((Object)_interfaceClass);
            this.classHierarchy.addEdgeFromTo((IMutableNode)_superinterfaceNode, (IMutableNode)_classNode);
            ++_iIndex;
        }
        if (clazz.isInterface()) {
            this.interfaces.add(clazz);
        } else {
            this.classes.add(clazz);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("callback() - END");
        }
    }

    public void confine(Collection confineToClasses, boolean retainTransitiveInheritanceRelation) {
        HashSet<SootClass> _classesToRemove = new HashSet<SootClass>();
        _classesToRemove.addAll(this.classes);
        _classesToRemove.addAll(this.interfaces);
        _classesToRemove.removeAll(confineToClasses);
        if (retainTransitiveInheritanceRelation) {
            this.removeClassesAndRetainInheritanceRelation(_classesToRemove);
        } else {
            Iterator _i = _classesToRemove.iterator();
            int _iEnd = _classesToRemove.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                SootClass _sc = (SootClass)_i.next();
                SimpleNode _node = this.classHierarchy.queryNode((Object)_sc);
                this.classHierarchy.removeNode((IMutableNode)_node);
                ++_iIndex;
            }
        }
        this.classes.retainAll(confineToClasses);
        this.interfaces.retainAll(confineToClasses);
    }

    public Collection<SootClass> getClasses() {
        return Collections.unmodifiableCollection(this.classes);
    }

    public List<SootClass> getClassesInTopologicalOrder(boolean topDown) {
        ArrayList<SootClass> _result = new ArrayList<SootClass>();
        CollectionUtils.transform((Collection)this.classHierarchy.performTopologicalSort(topDown), (ITransformer)this.classHierarchy.getObjectExtractor(), _result);
        return _result;
    }

    public Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(ID);
    }

    public Collection<SootClass> getInterfaces() {
        return Collections.unmodifiableCollection(this.interfaces);
    }

    public Collection<SootClass> getProperAncestorClassesOf(SootClass clazz) {
        Collection _result = this.class2properAncestorClasses.get(clazz);
        if (_result == null) {
            _result = SetUtils.intersection(this.classes, (Collection)CollectionUtils.collect((Collection)this.classHierarchy.getReachablesFrom((INode)this.classHierarchy.queryNode((Object)clazz), false), (ITransformer)this.classHierarchy.getObjectExtractor()));
            if (_result.isEmpty()) {
                _result = Collections.emptySet();
            }
            this.class2properAncestorClasses.put(clazz, _result);
        }
        return _result;
    }

    public Collection<SootClass> getProperAncestorInterfacesOf(SootClass clazz) {
        Collection _result = this.class2properAncestorInterfaces.get(clazz);
        if (_result == null) {
            _result = SetUtils.intersection(this.interfaces, (Collection)CollectionUtils.collect((Collection)this.classHierarchy.getReachablesFrom((INode)this.classHierarchy.queryNode((Object)clazz), false), (ITransformer)this.classHierarchy.getObjectExtractor()));
            if (_result.isEmpty()) {
                _result = Collections.emptySet();
            }
            this.class2properAncestorInterfaces.put(clazz, _result);
        }
        return _result;
    }

    public Collection<SootClass> getProperImmediateSubClassesOf(SootClass clazz) {
        Collection _result = this.class2properChildren.get(clazz);
        if (_result == null) {
            _result = CollectionUtils.collect((Collection)this.classHierarchy.queryNode((Object)clazz).getSuccsOf(), (ITransformer)this.classHierarchy.getObjectExtractor());
            if (_result.isEmpty()) {
                _result = Collections.emptySet();
            }
            this.class2properChildren.put(clazz, _result);
        }
        return _result;
    }

    public SootClass getProperParentClassOf(SootClass clazz) {
        SootClass _result = this.class2properParentClass.get(clazz);
        if (_result == null) {
            _result = (SootClass)SetUtils.intersection(this.classes, (Collection)CollectionUtils.collect((Collection)this.classHierarchy.queryNode((Object)clazz).getPredsOf(), (ITransformer)this.classHierarchy.getObjectExtractor())).iterator().next();
            this.class2properParentClass.put(clazz, _result);
        }
        return _result;
    }

    public Collection<SootClass> getProperParentInterfacesOf(SootClass clazz) {
        Collection _result = this.class2properParentInterfaces.get(clazz);
        if (_result == null) {
            _result = SetUtils.intersection(this.interfaces, (Collection)CollectionUtils.collect((Collection)this.classHierarchy.queryNode((Object)clazz).getPredsOf(), (ITransformer)this.classHierarchy.getObjectExtractor()));
            if (_result.isEmpty()) {
                _result = Collections.emptySet();
            }
            this.class2properParentInterfaces.put(clazz, _result);
        }
        return _result;
    }

    public Collection<SootClass> getProperSubclassesOf(SootClass clazz) {
        Collection _result = this.class2properDescendants.get(clazz);
        if (_result == null) {
            _result = CollectionUtils.collect((Collection)this.classHierarchy.getReachablesFrom((INode)this.classHierarchy.queryNode((Object)clazz), true), (ITransformer)this.classHierarchy.getObjectExtractor());
            if (_result.isEmpty()) {
                _result = Collections.emptySet();
            }
            this.class2properDescendants.put(clazz, _result);
        }
        return _result;
    }

    public void hookup(ProcessingController ppc) {
        ppc.register((IProcessor)this);
    }

    public void processingBegins() {
        this.unstable();
        this.classHierarchy = new SimpleNodeGraph();
    }

    public void reset() {
        this.classes.clear();
        this.interfaces.clear();
        this.class2properChildren.clear();
        this.class2properDescendants.clear();
        this.class2properAncestorClasses.clear();
        this.class2properAncestorInterfaces.clear();
        this.class2properParentClass.clear();
        this.class2properParentInterfaces.clear();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("classHierarchy", this.classHierarchy).toString();
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister((IProcessor)this);
    }

    public void updateEnvironment() {
        List _nodes = this.classHierarchy.getNodes();
        Iterator _i = _nodes.iterator();
        int _iEnd = _nodes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SimpleNode _node = (SimpleNode)_i.next();
            SootClass _sc = (SootClass)_node.getObject();
            Collection _parents = CollectionUtils.collect((Collection)_node.getPredsOf(), (ITransformer)this.classHierarchy.getObjectExtractor());
            Collection _superClasses = SetUtils.intersection(this.classes, (Collection)_parents);
            if (!_superClasses.isEmpty()) {
                assert (_superClasses.size() == 1) : "More than one super class on " + _sc;
                SootClass _superClass = (SootClass)_superClasses.iterator().next();
                _sc.setSuperclass(_superClass);
            }
            _sc.getInterfaces().retainAll((Collection)SetUtils.intersection(this.interfaces, (Collection)_parents));
            ++_iIndex;
        }
    }

    private void removeClassesAndRetainInheritanceRelation(Collection<SootClass> classesToRemove) {
        Iterator<SootClass> _i = classesToRemove.iterator();
        int _iEnd = classesToRemove.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootClass _sc = _i.next();
            SimpleNode _node = this.classHierarchy.queryNode((Object)_sc);
            Collection _succsOf = _node.getSuccsOf();
            Iterator _j = _succsOf.iterator();
            int _jEnd = _succsOf.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                SimpleNode _succ = (SimpleNode)_j.next();
                Collection _predsOf = _node.getPredsOf();
                Iterator _k = _predsOf.iterator();
                int _kEnd = _predsOf.size();
                int _kIndex = 0;
                while (_kIndex < _kEnd) {
                    SimpleNode _pred = (SimpleNode)_k.next();
                    this.classHierarchy.addEdgeFromTo((IMutableNode)_pred, (IMutableNode)_succ);
                    ++_kIndex;
                }
                ++_jIndex;
            }
            this.classHierarchy.removeNode((IMutableNode)_node);
            ++_iIndex;
        }
        Iterator _j = this.classHierarchy.getNodes().iterator();
        int _jEnd = this.classHierarchy.getNodes().size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            SimpleNode _node = (SimpleNode)_j.next();
            Collection _parents = CollectionUtils.collect((Collection)_node.getPredsOf(), (ITransformer)this.classHierarchy.getObjectExtractor());
            Collection _superClasses = SetUtils.intersection(this.classes, (Collection)_parents);
            if (_superClasses.size() > 1) {
                Iterator _k = _superClasses.iterator();
                int _kEnd = _superClasses.size();
                int _kIndex = 0;
                while (_kIndex < _kEnd) {
                    SootClass _superClass = (SootClass)_k.next();
                    if (_superClass.getName().equals("java.lang.Object")) {
                        this.classHierarchy.removeEdgeFromTo((IMutableNode)this.classHierarchy.queryNode((Object)_superClass), (IMutableNode)_node);
                        break;
                    }
                    ++_kIndex;
                }
            }
            ++_jIndex;
        }
    }
}

