/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.processors;

import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.annotations.NonNullContainer;
import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.IteratorUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.ApplicationInitInfoFactory;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.common.soot.SootPredicatesAndTransformers;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadGraph
extends AbstractValueAnalyzerBasedProcessor<Value>
implements IThreadGraphInfo {
    private static final String JAVA_LANG_RUNNABLE = "java.lang.Runnable";
    private static final String JAVA_LANG_THREAD = "java.lang.Thread";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadGraph.class);
    private static final String RUN_METHOD_NAME = "run";
    private static final String START_METHOD_NAME = "start";
    final CFGAnalysis cfgAnalysis;
    private IValueAnalyzer<Value> analyzer;
    private final ICallGraphInfo cgi;
    private final Map<SootMethod, Collection<Triple<InvokeStmt, SootMethod, SootClass>>> method2threadCreationSite = new HashMap<SootMethod, Collection<Triple<InvokeStmt, SootMethod, SootClass>>>(Constants.getNumOfMethodsInApplication());
    private final Collection<Pair<AssignStmt, SootMethod>> newThreadExprs = new HashSet<Pair<AssignStmt, SootMethod>>();
    private Pair.PairManager pairMgr;
    private final Collection<Pair<InvokeStmt, SootMethod>> startSites = new HashSet<Pair<InvokeStmt, SootMethod>>();
    private final Map<Triple<InvokeStmt, SootMethod, SootClass>, Collection<SootMethod>> thread2methods = new HashMap<Triple<InvokeStmt, SootMethod, SootClass>, Collection<SootMethod>>();
    private final Collection<Pair<? extends Object, ? extends Object>> threadCreationSitesMulti;
    private final Collection<Pair<? extends Object, ? extends Object>> threadCreationSitesSingle;
    private final Collection<SootMethod> threadEntryPoints = new HashSet<SootMethod>();

    public ThreadGraph(ICallGraphInfo callGraph, CFGAnalysis cfa, Pair.PairManager pairManager) {
        this.cgi = callGraph;
        this.pairMgr = pairManager;
        this.threadCreationSitesSingle = new HashSet<Pair<? extends Object, ? extends Object>>();
        this.threadCreationSitesMulti = new HashSet<Pair<? extends Object, ? extends Object>>();
        this.cfgAnalysis = cfa;
    }

    public void callback(ValueBox vBox, Context context) {
        IEnvironment _env = this.analyzer.getEnvironment();
        Value _value = vBox.getValue();
        if (_value instanceof NewExpr) {
            NewExpr _ne = (NewExpr)_value;
            this.processNewExpr(context, _env, _ne);
        } else if (_value instanceof VirtualInvokeExpr) {
            VirtualInvokeExpr _ve = (VirtualInvokeExpr)_value;
            this.processVirtualInvokeExpr(context, _ve);
        }
    }

    public void consolidate() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: thread graph consolidation");
        }
        this.calculateThreadCallGraph();
        this.injectMainThread();
        this.pruneUnreachableStartSites();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("consolidate thread allocation site execution frequency information.");
        }
        this.considerMultipleExecutions();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Thread graph info - " + this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: thread graph consolidation");
        }
    }

    public boolean containsClassInitThread(Collection<Triple<InvokeStmt, SootMethod, SootClass>> executionThreads) {
        return executionThreads.contains(ApplicationInitInfoFactory.getClassInitExecutingThread());
    }

    public Collection<Pair<AssignStmt, SootMethod>> getAllocationSites() {
        return Collections.unmodifiableCollection(this.newThreadExprs);
    }

    public Collection<Pair<InvokeStmt, SootMethod>> getCreationSites() {
        return Collections.unmodifiableCollection(this.startSites);
    }

    public Collection<SootMethod> getExecutedMethods(InvokeStmt startStmt, SootMethod method) {
        Context _ctxt = new Context();
        VirtualInvokeExpr _virtualInvokeExpr = (VirtualInvokeExpr)startStmt.getInvokeExpr();
        _ctxt.setProgramPoint(_virtualInvokeExpr.getBaseBox());
        _ctxt.setStmt((Stmt)startStmt);
        _ctxt.setRootMethod(method);
        IEnvironment _env = this.analyzer.getEnvironment();
        Collection<Value> _baseValues = this.analyzer.getValues(_virtualInvokeExpr.getBase(), _ctxt);
        HashSet _result = new HashSet();
        Iterator _j = IteratorUtils.filteredIterator(_baseValues.iterator(), (IPredicate)SootPredicatesAndTransformers.NEW_EXPR_PREDICATE);
        while (_j.hasNext()) {
            NewExpr _value = (NewExpr)_j.next();
            SootClass _sc = _env.getClass(_value.getBaseType().getClassName());
            Triple _thread = new Triple((Object)startStmt, (Object)method, (Object)_sc);
            _result.addAll(MapUtils.queryCollection(this.thread2methods, (Object)_thread));
        }
        return Collections.unmodifiableCollection(_result);
    }

    public Collection<Triple<InvokeStmt, SootMethod, SootClass>> getExecutionThreads(SootMethod sm) {
        Collection _result = MapUtils.queryCollection(this.method2threadCreationSite, (Object)sm);
        return Collections.unmodifiableCollection(_result);
    }

    public Collection<? extends Comparable<?>> getIds() {
        return Collections.singleton(IThreadGraphInfo.ID);
    }

    public Collection<SootMethod> getThreadEntryPoints() {
        return Collections.unmodifiableCollection(this.threadEntryPoints);
    }

    public void hookup(ProcessingController ppc) {
        this.unstable();
        ppc.register(NewExpr.class, (IProcessor)this);
        ppc.register(VirtualInvokeExpr.class, (IProcessor)this);
    }

    public boolean mustOccurInDifferentThread(SootMethod methodOne, SootMethod methodTwo) {
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _t1 = this.getExecutionThreads(methodOne);
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _t2 = this.getExecutionThreads(methodTwo);
        return _t1.isEmpty() || _t2.isEmpty() || !CollectionUtils.containsAny(_t1, _t2);
    }

    public boolean mustOccurInSameThread(SootMethod methodOne, SootMethod methodTwo) {
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _t1 = this.getExecutionThreads(methodOne);
        Collection<Triple<InvokeStmt, SootMethod, SootClass>> _t2 = this.getExecutionThreads(methodTwo);
        return _t1.size() == 1 && _t1.size() == _t2.size() && _t1.containsAll(_t2) && this.threadCreationSitesSingle.containsAll(_t1);
    }

    public void reset() {
        this.thread2methods.clear();
        this.method2threadCreationSite.clear();
        this.threadEntryPoints.clear();
        this.analyzer = null;
        this.startSites.clear();
        this.newThreadExprs.clear();
        this.threadCreationSitesMulti.clear();
        this.threadCreationSitesSingle.clear();
        this.unstable();
    }

    @Override
    public void setAnalyzer(IValueAnalyzer<Value> objFlowAnalyzer) {
        this.analyzer = objFlowAnalyzer;
    }

    public String toString() {
        StringBuffer _result = new StringBuffer();
        ArrayList<String> _l = new ArrayList<String>();
        _result.append("Total number of threads: " + this.thread2methods.size() + "\n");
        ArrayList _temp1 = new ArrayList();
        _temp1.addAll(this.thread2methods.keySet());
        Collections.sort(_temp1, ToStringBasedComparator.getComparator());
        for (Triple _triple : _temp1) {
            _result.append("\n" + _triple.getFirst() + "@" + _triple.getSecond() + "#" + _triple.getThird() + " [" + this.thread2methods.get(_triple).size() + "]\n");
            _l.clear();
            for (SootMethod _sm : this.thread2methods.get(_triple)) {
                _l.add(_sm.getSignature());
            }
            Collections.sort(_l);
            Iterator<Object> _j = _l.iterator();
            while (_j.hasNext()) {
                _result.append("\t" + (String)_j.next() + "\n");
            }
        }
        _result.append("Method to thread mapping: \n");
        ArrayList _t = new ArrayList(this.method2threadCreationSite.keySet());
        Collections.sort(_t, ToStringBasedComparator.getComparator());
        for (SootMethod _sm : _t) {
            _result.append("\n" + _sm.toString() + " [" + this.method2threadCreationSite.get(_sm).size() + "]\n");
            _l.clear();
            for (Triple<InvokeStmt, SootMethod, SootClass> _s : this.method2threadCreationSite.get(_sm)) {
                _l.add(_s.toString());
            }
            Collections.sort(_l);
            Iterator<Object> _j = _l.iterator();
            while (_j.hasNext()) {
                _result.append("\t" + (String)_j.next() + "\n");
            }
        }
        int _count = 1;
        _result.append("\nThread mapping: [" + this.getAllocationSites().size() + "]\n");
        for (Pair<AssignStmt, SootMethod> _element : this.getAllocationSites()) {
            String _tid = "T" + _count++;
            _result.append(String.valueOf(_tid) + " -> " + _element.getFirst() + "@" + _element.getSecond() + "\n");
        }
        _result.append("\nThread entry points: [" + this.threadEntryPoints.size() + "]\n");
        _result.append(CollectionUtils.prettyPrint(this.threadEntryPoints));
        return _result.toString();
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister(NewExpr.class, (IProcessor)this);
        ppc.unregister(VirtualInvokeExpr.class, (IProcessor)this);
        this.stable();
    }

    @NonNull
    @NonNullContainer
    Collection<SootMethod> getRunnableMethods(@NonNull SootClass clazz) {
        Collection<Value> _runnables = this.getRunnables(clazz);
        IEnvironment _env = this.analyzer.getEnvironment();
        HashSet<SootMethod> _result = new HashSet<SootMethod>(_runnables.size());
        Iterator _j = IteratorUtils.filteredIterator(_runnables.iterator(), (IPredicate)SootPredicatesAndTransformers.NEW_EXPR_PREDICATE);
        while (_j.hasNext()) {
            NewExpr _temp = (NewExpr)_j.next();
            SootClass _runnable = _env.getClass(_temp.getBaseType().getClassName());
            SootMethod _entryPoint = this.getRunMethod(_runnable);
            _result.add(_entryPoint);
        }
        return _result;
    }

    private void calculateThreadCallGraph() throws RuntimeException {
        IEnvironment _env = this.analyzer.getEnvironment();
        SootClass _threadClass = _env.getClass(JAVA_LANG_THREAD);
        SootMethod _startMethod = _threadClass.getMethodByName(START_METHOD_NAME);
        Context _ctxt = new Context();
        _ctxt.setRootMethod(_startMethod);
        Collection<Value> _values = this.analyzer.getValuesForThis(_ctxt);
        HashMap<SootClass, Collection<Object>> _class2runCallees = new HashMap<SootClass, Collection<Object>>();
        Collection<SootMethod> _runnables = this.getRunnableMethods(_threadClass);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Thread expressions are: " + _values);
            LOGGER.debug("Runnables are: " + _runnables);
        }
        Iterator _i = IteratorUtils.filteredIterator(_values.iterator(), (IPredicate)SootPredicatesAndTransformers.NEW_EXPR_PREDICATE);
        while (_i.hasNext()) {
            Collection<Object> _methods;
            NewExpr _value = (NewExpr)_i.next();
            SootClass _sc = _env.getClass(_value.getBaseType().getClassName());
            if (_class2runCallees.containsKey(_sc)) continue;
            boolean _flag = false;
            SootClass _scTemp = Util.getDeclaringClass((SootClass)_sc, (String)RUN_METHOD_NAME, Collections.emptyList(), (Type)VoidType.v());
            if (_scTemp == null) {
                LOGGER.error("How can there be a descendent of java.lang.Thread without access to run() method.");
                throw new RuntimeException("run() method is unavailable via " + _sc + " even though it is a descendent of java.lang.Thread.");
            }
            _flag = _scTemp.getName().equals(JAVA_LANG_THREAD);
            if (_flag) {
                _methods = new HashSet();
                for (SootMethod _entryPoint : _runnables) {
                    this.threadEntryPoints.add(_entryPoint);
                    _methods.addAll(this.transitiveThreadCallClosure(_entryPoint));
                }
            } else {
                SootMethod _entryPoint = this.getRunMethod(_sc);
                this.threadEntryPoints.add(_entryPoint);
                _methods = this.transitiveThreadCallClosure(_entryPoint);
            }
            _class2runCallees.put(_sc, _methods);
        }
        Collection _callTriples = this.cgi.getCallers(_startMethod);
        Iterator _i2 = _callTriples.iterator();
        int _iEnd = _callTriples.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            ICallGraphInfo.CallTriple _ctrp = (ICallGraphInfo.CallTriple)_i2.next();
            SootMethod _caller = _ctrp.getMethod();
            _ctxt.setRootMethod(_caller);
            InvokeStmt _callStmt = (InvokeStmt)_ctrp.getStmt();
            _ctxt.setStmt((Stmt)_callStmt);
            VirtualInvokeExpr _virtualInvokeExpr = (VirtualInvokeExpr)_callStmt.getInvokeExpr();
            _ctxt.setProgramPoint(_virtualInvokeExpr.getBaseBox());
            Collection<Value> _baseValues = this.analyzer.getValues(_virtualInvokeExpr.getBase(), _ctxt);
            Iterator _j = IteratorUtils.filteredIterator(_baseValues.iterator(), (IPredicate)SootPredicatesAndTransformers.NEW_EXPR_PREDICATE);
            while (_j.hasNext()) {
                NewExpr _value = (NewExpr)_j.next();
                SootClass _sc = _env.getClass(_value.getBaseType().getClassName());
                if (!_class2runCallees.containsKey(_sc)) continue;
                Collection _methods = (Collection)_class2runCallees.get(_sc);
                Triple _thread = new Triple((Object)_callStmt, (Object)_caller, (Object)_sc);
                MapUtils.putAllIntoCollectionInMap(this.thread2methods, (Object)_thread, (Collection)_methods);
                for (SootMethod _sm : _methods) {
                    MapUtils.putIntoCollectionInMap(this.method2threadCreationSite, (Object)_sm, (Object)_thread);
                }
            }
            ++_iIndex;
        }
    }

    private void considerMultipleExecutions() {
        Object _encloser;
        HashSet<Pair<? extends Object, ? extends Object>> _tassBak = new HashSet<Pair<? extends Object, ? extends Object>>(this.threadCreationSitesSingle);
        for (Pair pair : _tassBak) {
            Object object = pair.getSecond();
            if (!(object instanceof SootMethod) || !this.cfgAnalysis.executedMultipleTimes((SootMethod)(_encloser = (SootMethod)object))) continue;
            this.threadCreationSitesSingle.remove(pair);
            this.threadCreationSitesMulti.add((Pair<? extends Object, ? extends Object>)pair);
        }
        HashSet<SootMethod> _multiExecMethods = new HashSet<SootMethod>();
        for (Pair<? extends Object, ? extends Object> pair : this.threadCreationSitesMulti) {
            Object _o = pair.getSecond();
            if (!(_o instanceof SootMethod)) continue;
            _multiExecMethods.addAll(this.getExecutedMethods((InvokeStmt)pair.getFirst(), (SootMethod)_o));
        }
        _tassBak.clear();
        _tassBak.addAll(this.threadCreationSitesSingle);
        for (Pair pair : _tassBak) {
            _encloser = pair.getSecond();
            if (!_multiExecMethods.contains(_encloser)) continue;
            this.threadCreationSitesSingle.remove(pair);
            this.threadCreationSitesMulti.add((Pair<? extends Object, ? extends Object>)pair);
        }
    }

    private SootMethod getRunMethod(SootClass threadClass) {
        return threadClass.getMethod(RUN_METHOD_NAME, Collections.EMPTY_LIST, (Type)VoidType.v());
    }

    private Collection<Value> getRunnables(SootClass threadClass) {
        Collection<Value> _result = Collections.emptySet();
        SootMethod _threadRunMethod = this.getRunMethod(threadClass);
        Iterator _units = _threadRunMethod.retrieveActiveBody().getUnits().iterator();
        Iterator _iter = IteratorUtils.filteredIterator((Iterator)_units, (IPredicate)SootPredicatesAndTransformers.INVOKING_STMT_PREDICATE);
        while (_iter.hasNext()) {
            Stmt _stmt = (Stmt)_iter.next();
            InvokeExpr _expr = _stmt.getInvokeExpr();
            SootMethod _invokedMethod = _expr.getMethod();
            if (!(_expr instanceof InterfaceInvokeExpr) || !_invokedMethod.getName().equals(RUN_METHOD_NAME) || !_invokedMethod.getDeclaringClass().getName().equals(JAVA_LANG_RUNNABLE)) continue;
            InterfaceInvokeExpr _iExpr = (InterfaceInvokeExpr)_expr;
            Context _context = new Context();
            _context.setRootMethod(_threadRunMethod);
            _context.setStmt(_stmt);
            _context.setProgramPoint(_iExpr.getBaseBox());
            _result = this.analyzer.getValues(_iExpr.getBase(), _context);
            break;
        }
        return _result;
    }

    private void injectMainThread() {
        for (SootMethod _head : this.cgi.getEntryMethods()) {
            Triple _thread;
            Pair _threadAllocationSite;
            Pair _threadCreationSite;
            if (_head.getName().equals("<clinit>")) {
                _threadCreationSite = ApplicationInitInfoFactory.getClassInitExecutingThreadCreationSite();
                _threadAllocationSite = ApplicationInitInfoFactory.getClassInitExecutingThreadAllocationSite();
                _thread = ApplicationInitInfoFactory.getClassInitExecutingThread();
            } else {
                _threadCreationSite = ApplicationInitInfoFactory.getApplicationStartingThreadCreationSite();
                _threadAllocationSite = ApplicationInitInfoFactory.getApplicationStartingThreadAllocationSite();
                _thread = ApplicationInitInfoFactory.getApplicationStartingThread();
            }
            this.newThreadExprs.add((Pair<AssignStmt, SootMethod>)_threadAllocationSite);
            this.threadCreationSitesSingle.add((Pair<? extends Object, ? extends Object>)_threadCreationSite);
            Collection<SootMethod> _methods = this.transitiveThreadCallClosure(_head);
            MapUtils.putAllIntoCollectionInMap(this.thread2methods, (Object)_thread, _methods);
            this.threadEntryPoints.add(_head);
            for (SootMethod _sm : _methods) {
                MapUtils.putIntoCollectionInMap(this.method2threadCreationSite, (Object)_sm, (Object)_thread);
            }
        }
    }

    private void processNewExpr(Context context, IEnvironment env, NewExpr newExpr) throws RuntimeException {
        SootClass _clazz = env.getClass(newExpr.getBaseType().getClassName());
        if (Util.isDescendentOf((SootClass)_clazz, (String)JAVA_LANG_THREAD)) {
            SootClass _temp = Util.getDeclaringClass((SootClass)_clazz, (String)START_METHOD_NAME, Collections.emptyList(), (Type)VoidType.v());
            if (_temp != null && _temp.getName().equals(JAVA_LANG_THREAD)) {
                AssignStmt _stmt = (AssignStmt)context.getStmt();
                SootMethod _sm = context.getCurrentMethod();
                this.newThreadExprs.add((Pair<AssignStmt, SootMethod>)this.pairMgr.getPair((Object)_stmt, (Object)_sm));
            } else {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("How can there be a descendent of java.lang.Thread without access to start() method.");
                }
                throw new RuntimeException("start() method is unavailable via " + _clazz + " even though it is a descendent of java.lang.Thread.");
            }
        }
    }

    private void processVirtualInvokeExpr(Context context, VirtualInvokeExpr invokeExpr) {
        SootMethod _method;
        RefLikeType _rlt = (RefLikeType)invokeExpr.getBase().getType();
        if (_rlt instanceof RefType && Util.isStartMethod((SootMethod)(_method = invokeExpr.getMethod()))) {
            SootMethod _caller = context.getCurrentMethod();
            InvokeStmt _callStmt = (InvokeStmt)context.getStmt();
            Collection _callees = this.cgi.getCallees((InvokeExpr)invokeExpr, context);
            Iterator _i = _callees.iterator();
            int _iEnd = _callees.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                SootMethod _callee = (SootMethod)_i.next();
                if (Util.isStartMethod((SootMethod)_callee)) {
                    Pair _callPair = this.pairMgr.getPair((Object)_callStmt, (Object)_caller);
                    this.startSites.add((Pair<InvokeStmt, SootMethod>)_callPair);
                    if (this.cfgAnalysis.checkForLoopEnclosedNewExpr((Stmt)_callStmt, _caller)) {
                        this.threadCreationSitesMulti.add((Pair<? extends Object, ? extends Object>)_callPair);
                        break;
                    }
                    this.threadCreationSitesSingle.add((Pair<? extends Object, ? extends Object>)_callPair);
                    break;
                }
                ++_iIndex;
            }
        }
    }

    private void pruneUnreachableStartSites() {
        HashSet<Pair<InvokeStmt, SootMethod>> _temp = new HashSet<Pair<InvokeStmt, SootMethod>>();
        Collection _reachables = this.cgi.getReachableMethods();
        for (Pair<InvokeStmt, SootMethod> _callPair : this.startSites) {
            if (_reachables.contains(_callPair.getSecond())) continue;
            _temp.add(_callPair);
        }
        this.startSites.removeAll(_temp);
    }

    private Collection<SootMethod> transitiveThreadCallClosure(SootMethod starterMethod) {
        HashSet<SootMethod> _result = new HashSet<SootMethod>();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_result);
        _wb.addWork((Object)starterMethod);
        _result.add(starterMethod);
        while (_wb.hasWork()) {
            SootMethod _sm = (SootMethod)_wb.getWork();
            if (Util.isStartMethod((SootMethod)_sm)) continue;
            Collection _callees = this.cgi.getCallees(_sm);
            for (ICallGraphInfo.CallTriple _ctrp : _callees) {
                SootMethod _temp = _ctrp.getMethod();
                _wb.addWorkNoDuplicates((Object)_temp);
            }
        }
        return _result;
    }
}

