/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.processors;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.interfaces.INewExpr2InitMapper;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InvokeStmt;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewExpr2InitMapper
extends AbstractValueAnalyzerBasedProcessor<Value>
implements INewExpr2InitMapper {
    private Context contextCache = new Context();
    private final Map<SootMethod, Map<Stmt, InvokeStmt>> method2initStmt = new HashMap<SootMethod, Map<Stmt, InvokeStmt>>(Constants.getNumOfMethodsInApplication());
    private final Map<SootMethod, Map<Value, Stmt>> method2newExprStmt = new HashMap<SootMethod, Map<Value, Stmt>>(Constants.getNumOfMethodsInApplication());
    private IValueAnalyzer<Value> ofa;

    public void callback(ValueBox vBox, Context context) {
        Value _value = vBox.getValue();
        if (_value instanceof NewExpr) {
            Stmt _stmt = context.getStmt();
            SootMethod _method = context.getCurrentMethod();
            Map _ne2init = MapUtils.getMapFromMap(this.method2newExprStmt, (Object)_method);
            _ne2init.put(_value, _stmt);
        } else if (_value instanceof SpecialInvokeExpr && context.getStmt() instanceof InvokeStmt) {
            InvokeStmt _stmt = (InvokeStmt)context.getStmt();
            SootMethod _method = context.getCurrentMethod();
            SpecialInvokeExpr _expr = (SpecialInvokeExpr)_value;
            SootMethod _sm = _expr.getMethod();
            if (_sm.getName().equals("<init>")) {
                Map _ne2initStmt = MapUtils.getMapFromMap(this.method2initStmt, (Object)_method);
                Map _ne2newStmt = MapUtils.getMapFromMap(this.method2newExprStmt, (Object)_method);
                this.contextCache.setRootMethod(_method);
                this.contextCache.setStmt((Stmt)_stmt);
                this.contextCache.setProgramPoint(_expr.getBaseBox());
                Collection<Value> _values = this.ofa.getValues(_expr.getBase(), this.contextCache);
                for (Value _o : _values) {
                    Stmt _newStmt = (Stmt)_ne2newStmt.remove(_o);
                    _ne2initStmt.put(_newStmt, _stmt);
                }
            }
        }
    }

    public void consolidate() {
        super.consolidate();
        this.contextCache.setStmt(null);
        this.contextCache.setProgramPoint(null);
        this.contextCache.setRootMethod(null);
    }

    public InvokeStmt getInitCallStmtForNewExprStmt(Stmt newExprStmt, SootMethod method) {
        Map<Stmt, InvokeStmt> _ne2init = this.method2initStmt.get(method);
        InvokeStmt _result = null;
        if (_ne2init != null) {
            _result = _ne2init.get(newExprStmt);
        }
        return _result;
    }

    public void hookup(ProcessingController ppc) {
        ppc.register(NewExpr.class, (IProcessor)this);
        ppc.register(NewArrayExpr.class, (IProcessor)this);
        ppc.register(NewMultiArrayExpr.class, (IProcessor)this);
        ppc.register(SpecialInvokeExpr.class, (IProcessor)this);
        ppc.register(StringConstant.class, (IProcessor)this);
    }

    public void processingBegins() {
        this.method2initStmt.clear();
    }

    public final void reset() {
        this.method2initStmt.clear();
    }

    @Override
    public void setAnalyzer(IValueAnalyzer<Value> analyzer) {
        this.ofa = analyzer;
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister(NewExpr.class, (IProcessor)this);
        ppc.unregister(NewArrayExpr.class, (IProcessor)this);
        ppc.unregister(NewMultiArrayExpr.class, (IProcessor)this);
        ppc.unregister(SpecialInvokeExpr.class, (IProcessor)this);
        ppc.unregister(StringConstant.class, (IProcessor)this);
    }
}

