/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.processors;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.interfaces.IIdentification;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AbstractValueAnalyzerBasedProcessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliasedUseDefInfo
extends AbstractValueAnalyzerBasedProcessor<Value>
implements IUseDefInfo<Pair<DefinitionStmt, SootMethod>, Pair<DefinitionStmt, SootMethod>>,
IIdentification {
    private static final Logger LOGGER = LoggerFactory.getLogger(AliasedUseDefInfo.class);
    protected final BasicBlockGraphMgr bbgMgr;
    protected final CFGAnalysis cfgAnalysis;
    private final IValueAnalyzer<Value> analyzer;
    private final Map<Object, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>> def2usesMap;
    private final Pair.PairManager pairMgr;
    private final Map<Object, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>> use2defsMap;

    public AliasedUseDefInfo(IValueAnalyzer<Value> iva, BasicBlockGraphMgr bbgManager, Pair.PairManager pairManager, CFGAnalysis analysis) {
        this.cfgAnalysis = analysis;
        this.analyzer = iva;
        this.bbgMgr = bbgManager;
        this.pairMgr = pairManager;
        this.def2usesMap = new HashMap<Object, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>>(Constants.getNumOfFieldsInApplication());
        this.use2defsMap = new HashMap<Object, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>>(Constants.getNumOfFieldsInApplication());
    }

    public void callback(Stmt stmt, Context context) {
        DefinitionStmt _as = (DefinitionStmt)stmt;
        if (_as.containsArrayRef() || _as.containsFieldRef()) {
            Object _key = _as.containsArrayRef() ? _as.getArrayRef().getBase().getType() : _as.getFieldRef().getField();
            Value _ref = _as.getRightOp();
            Map<Object, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>> _map = _ref instanceof ArrayRef || _ref instanceof FieldRef ? this.use2defsMap : this.def2usesMap;
            Map _key2info = MapUtils.getMapFromMap(_map, (Object)_key);
            _key2info.put(this.pairMgr.getPair((Object)_as, (Object)context.getCurrentMethod()), null);
        }
    }

    public void consolidate() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: consolidating");
        }
        HashSet<Pair<DefinitionStmt, SootMethod>> _uses = new HashSet<Pair<DefinitionStmt, SootMethod>>();
        for (Map.Entry<Object, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>> _entry : this.def2usesMap.entrySet()) {
            Object _key = _entry.getKey();
            Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>> _defsite2usesites = _entry.getValue();
            Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>> _usesite2defsites = this.use2defsMap.get(_key);
            if (_usesite2defsites == null) continue;
            Iterator<Pair<DefinitionStmt, SootMethod>> _k = _defsite2usesites.keySet().iterator();
            int _kEnd = _defsite2usesites.keySet().size();
            int _kIndex = 0;
            while (_kIndex < _kEnd) {
                Pair<DefinitionStmt, SootMethod> _defSite = _k.next();
                Iterator<Pair<DefinitionStmt, SootMethod>> _l = _usesite2defsites.keySet().iterator();
                int _lEnd = _usesite2defsites.keySet().size();
                int _lIndex = 0;
                while (_lIndex < _lEnd) {
                    Pair<DefinitionStmt, SootMethod> _useSite = _l.next();
                    if (this.areDefUseRelated(_defSite, _useSite) && this.doesDefReachUse(_defSite, _useSite)) {
                        MapUtils.putIntoCollectionInMap(_usesite2defsites, _useSite, _defSite);
                        _uses.add(_useSite);
                    }
                    ++_lIndex;
                }
                if (!_uses.isEmpty()) {
                    MapUtils.putAllIntoCollectionInMap(_defsite2usesites, _defSite, _uses);
                    _uses.clear();
                }
                ++_kIndex;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: consolidating - " + this.toString());
        }
    }

    public Collection<Pair<DefinitionStmt, SootMethod>> getDefs(Local local, Stmt useStmt, SootMethod method) {
        throw new UnsupportedOperationException("This opertation is not supported.");
    }

    public Collection<Pair<DefinitionStmt, SootMethod>> getDefs(Stmt useStmt, SootMethod method) {
        Collection _result = Collections.emptyList();
        if (useStmt.containsArrayRef() || useStmt.containsFieldRef()) {
            Object _key = useStmt.containsArrayRef() ? useStmt.getArrayRef().getBase().getType() : useStmt.getFieldRef().getField();
            Map _map = MapUtils.queryMap(this.use2defsMap, (Object)_key);
            _result = MapUtils.queryCollection((Map)_map, (Object)this.pairMgr.getPair((Object)((DefinitionStmt)useStmt), (Object)method));
        }
        return _result;
    }

    public Collection<? extends Comparable<? extends Object>> getIds() {
        return Collections.singleton(IUseDefInfo.ALIASED_USE_DEF_ID);
    }

    public Collection<Pair<DefinitionStmt, SootMethod>> getUses(DefinitionStmt defStmt, SootMethod method) {
        Collection _result = Collections.emptyList();
        if (defStmt.containsArrayRef() || defStmt.containsFieldRef()) {
            Object _key = defStmt.containsArrayRef() ? defStmt.getArrayRef().getBase().getType() : defStmt.getFieldRef().getField();
            Map _map = MapUtils.queryMap(this.def2usesMap, (Object)_key);
            _result = MapUtils.queryCollection((Map)_map, (Object)this.pairMgr.getPair((Object)defStmt, (Object)method));
        }
        return _result;
    }

    public void hookup(ProcessingController ppc) {
        this.unstable();
        ppc.register(AssignStmt.class, (IProcessor)this);
    }

    public void reset() {
        this.unstable();
        this.def2usesMap.clear();
        this.use2defsMap.clear();
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("Statistics for Aliased Use Def analysis as calculated by " + this.getClass().getName() + "\n");
        int _edgeCount = 0;
        StringBuilder _temp = new StringBuilder();
        for (Map.Entry<Object, Map<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>>> _entry : this.use2defsMap.entrySet()) {
            Object _entity = _entry.getKey();
            _result.append("For " + _entity + "\n ");
            for (Map.Entry<Pair<DefinitionStmt, SootMethod>, Collection<Pair<DefinitionStmt, SootMethod>>> _entry1 : _entry.getValue().entrySet()) {
                Pair<DefinitionStmt, SootMethod> _use = _entry1.getKey();
                Collection<Pair<DefinitionStmt, SootMethod>> _defs = _entry1.getValue();
                int _localEdgeCount = 0;
                if (_defs != null) {
                    for (Pair<DefinitionStmt, SootMethod> _def : _defs) {
                        _temp.append("\t\t" + _use + " <== " + _def + "\n");
                    }
                    _localEdgeCount += _defs.size();
                }
                Pair<DefinitionStmt, SootMethod> _key = _entry1.getKey();
                _result.append("\tFor " + _key + "[");
                if (_key != null) {
                    _result.append(_key.hashCode());
                } else {
                    _result.append(0);
                }
                _result.append("] there are " + _localEdgeCount + " use-defs.\n");
                _result.append((CharSequence)_temp);
                _temp.delete(0, _temp.length());
                _edgeCount += _localEdgeCount;
            }
        }
        _result.append("A total of " + _edgeCount + " use-defs.");
        return _result.toString();
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister(AssignStmt.class, (IProcessor)this);
        this.stable();
    }

    protected boolean isReachableViaInterProceduralControlFlow(SootMethod defMethod, Stmt defStmt, SootMethod useMethod, Stmt useStmt) {
        return true;
    }

    private boolean areDefUseRelated(Pair<DefinitionStmt, SootMethod> defSite, Pair<DefinitionStmt, SootMethod> useSite) {
        boolean _result = false;
        Context _context = new Context();
        DefinitionStmt _defStmt = (DefinitionStmt)defSite.getFirst();
        DefinitionStmt _useStmt = (DefinitionStmt)useSite.getFirst();
        SootMethod _defMethod = (SootMethod)defSite.getSecond();
        SootMethod _useMethod = (SootMethod)useSite.getSecond();
        if (_defStmt.containsArrayRef()) {
            ValueBox _vBox1 = _useStmt.getArrayRef().getBaseBox();
            _context.setRootMethod(_useMethod);
            _context.setStmt((Stmt)_useStmt);
            _context.setProgramPoint(_vBox1);
            Collection<Value> _c1 = this.analyzer.getValues(_vBox1.getValue(), _context);
            ValueBox _vBox2 = _defStmt.getArrayRef().getBaseBox();
            _context.setRootMethod(_defMethod);
            _context.setStmt((Stmt)_defStmt);
            _context.setProgramPoint(_vBox2);
            Collection<Value> _c2 = this.analyzer.getValues(_vBox2.getValue(), _context);
            _result = CollectionUtils.containsAny(_c1, _c2) || _c1.isEmpty() && _c2.isEmpty();
        } else if (_defStmt.containsFieldRef()) {
            FieldRef _fr = _useStmt.getFieldRef();
            _result = true;
            if (_fr instanceof InstanceFieldRef) {
                ValueBox _vBox1 = ((InstanceFieldRef)_useStmt.getFieldRef()).getBaseBox();
                _context.setRootMethod(_useMethod);
                _context.setStmt((Stmt)_useStmt);
                _context.setProgramPoint(_vBox1);
                Collection<Value> _c1 = this.analyzer.getValues(_vBox1.getValue(), _context);
                ValueBox _vBox2 = ((InstanceFieldRef)_defStmt.getFieldRef()).getBaseBox();
                _context.setRootMethod(_defMethod);
                _context.setStmt((Stmt)_defStmt);
                _context.setProgramPoint(_vBox2);
                Collection<Value> _c2 = this.analyzer.getValues(_vBox2.getValue(), _context);
                boolean bl = _result = CollectionUtils.containsAny(_c1, _c2) || _c1.isEmpty() && _c2.isEmpty();
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Def: " + defSite + " / Use: " + useSite + " --> related:" + _result);
        }
        return _result;
    }

    private boolean doesDefReachUse(Pair<DefinitionStmt, SootMethod> defSite, Pair<DefinitionStmt, SootMethod> useSite) {
        DefinitionStmt _defStmt = (DefinitionStmt)defSite.getFirst();
        DefinitionStmt _useStmt = (DefinitionStmt)useSite.getFirst();
        SootMethod _defMethod = (SootMethod)defSite.getSecond();
        SootMethod _useMethod = (SootMethod)useSite.getSecond();
        boolean _result = _useMethod.equals(_defMethod) ? this.cfgAnalysis.doesControlFlowPathExistBetween((Stmt)_defStmt, (Stmt)_useStmt, _useMethod) : (_defStmt.containsFieldRef() && (_defMethod.getName().equals("<clinit>") && _defStmt.getFieldRef().getField().isStatic() || _defMethod.getName().equals("<init>") && !_defStmt.getFieldRef().getField().isStatic()) && _defStmt.getFieldRef().getField().getDeclaringClass().equals(_defMethod.getDeclaringClass()) ? true : this.isReachableViaInterProceduralControlFlow(_defMethod, (Stmt)_defStmt, _useMethod, (Stmt)_useStmt));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Def: " + defSite + " / Use: " + useSite + " --> related:" + _result);
        }
        return _result;
    }
}

