/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.optimizations;

import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.collections.Stack;
import edu.ksu.cis.indus.common.graph.SCCRelatedData;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.SendTokensWork;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCCBasedOptimizer<SYM, T extends ITokens<T, SYM>, N extends IFGNode<SYM, T, N>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SCCBasedOptimizer.class);
    private static final int NEGATIVE_DOMAIN = 0;
    private static final int POSITIVE_DOMAIN = 1;
    int componentNumber;
    int noOfNodes;
    private int numberingDomain = 0;

    public void optimize(Collection<N> rootNodes, ITokenManager<T, SYM, ?> tokenMgr) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Collapsing SCCs...");
        }
        Collection<Collection<N>> _sccs = this.getSCCs(rootNodes);
        Iterator<Collection<N>> _i = _sccs.iterator();
        int _iEnd = _sccs.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Collection<N> _scc = _i.next();
            if (_scc.size() > 1) {
                this.optimizeSCC(_scc, tokenMgr);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Collapsed an SCC of size " + _scc.size());
                }
            }
            ++_iIndex;
        }
    }

    public void reset() {
        this.numberingDomain = 0;
    }

    private void calculateSCC(N root, Collection<Collection<N>> sccs, Stack<N> stack) {
        SCCRelatedData _srd = root.getSCCRelatedData();
        _srd.setComponentNum(0);
        _srd.setDfsNum(this.noOfNodes);
        _srd.setHigh(this.noOfNodes);
        stack.push(root);
        --this.noOfNodes;
        Collection _succs = root.getSuccs();
        Iterator _i = _succs.iterator();
        int _iEnd = _succs.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            IFGNode _succ = (IFGNode)_i.next();
            SCCRelatedData _succSRD = _succ.getSCCRelatedData();
            if (this.unexplored(_succSRD)) {
                this.calculateSCC(_succ, sccs, stack);
                _srd.setHigh(Math.max(_srd.getHigh(), _succSRD.getHigh()));
            } else if (_succSRD.getDfsNum() > _srd.getDfsNum() && _succSRD.getComponentNum() == 0) {
                _srd.setHigh(Math.max(_srd.getHigh(), _succSRD.getDfsNum()));
            }
            ++_iIndex;
        }
        if (_srd.getHigh() == _srd.getDfsNum()) {
            IFGNode _o;
            ++this.componentNumber;
            HashSet<IFGNode> _set = new HashSet<IFGNode>();
            SCCRelatedData _commonSRD = root.getSCCRelatedData();
            _commonSRD.setComponentNum(this.componentNumber);
            do {
                _o = (IFGNode)stack.pop();
                _o.setSCCRelatedData(_commonSRD);
                _set.add(_o);
            } while (_o != root);
            sccs.add(_set);
        }
    }

    private Collection<Collection<N>> getSCCs(Collection<N> rootNodes) {
        Stack _stack = new Stack();
        this.setMaxNumberForSelectedNumberDomain();
        this.componentNumber = 0;
        ArrayList<Collection<N>> _sccs = new ArrayList<Collection<N>>();
        for (IFGNode _node : rootNodes) {
            if (!this.unexplored(_node.getSCCRelatedData())) continue;
            this.calculateSCC(_node, _sccs, _stack);
        }
        this.toggleNumberDomain();
        return _sccs;
    }

    private void optimizeSCC(Collection<N> scc, ITokenManager<T, SYM, ?> tokenManager) {
        SendTokensWork _work = new SendTokensWork((IFGNode)scc.iterator().next(), tokenManager.getNewTokenSet());
        Object _unifiedTokens = tokenManager.getNewTokenSet();
        T _newTokenSet = tokenManager.getNewTokenSet();
        HashSet _succs = new HashSet();
        HashSet _newSuccs = new HashSet();
        Iterator<N> _i = scc.iterator();
        int _iEnd = scc.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            IFGNode _node = (IFGNode)_i.next();
            _unifiedTokens.addTokens(_node.getTokens());
            _succs.addAll(_node.getSuccs());
            _node.setTokenSet(_newTokenSet);
            _node.setSuccessorSet(_newSuccs);
            _node.setInSCCWithMultipleNodes();
            if (_node instanceof AbstractFGNode) {
                AbstractFGNode _abstractFGNode = (AbstractFGNode)_node;
                _abstractFGNode.setTokenSendingWork(_work);
            }
            ++_iIndex;
        }
        _newSuccs.addAll(SetUtils.difference(_succs, scc));
        ((IFGNode)scc.iterator().next()).injectTokens(_unifiedTokens);
    }

    private void setMaxNumberForSelectedNumberDomain() {
        this.noOfNodes = this.numberingDomain == 0 ? -1 : Integer.MAX_VALUE;
    }

    private void toggleNumberDomain() {
        this.numberingDomain = this.numberingDomain == 0 ? 1 : 0;
    }

    private boolean unexplored(SCCRelatedData data) {
        boolean _result = this.numberingDomain == 0 ? data.getDfsNum() >= 0 : data.getDfsNum() <= 0;
        return _result;
    }
}

