/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.modes.sensitive.allocation;

import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.Constants;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractIndexManager;
import edu.ksu.cis.indus.staticanalyses.flow.modes.sensitive.OneContextInfoIndex;
import edu.ksu.cis.indus.staticanalyses.flow.modes.sensitive.allocation.AllocationContext;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.RefType;
import soot.Type;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocationSiteSensitiveIndexManager<E>
extends AbstractIndexManager<OneContextInfoIndex<E, Object>, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllocationSiteSensitiveIndexManager.class);
    private final Pattern pattern;
    private final boolean objectSensitiveArrayTracking;

    public AllocationSiteSensitiveIndexManager() {
        String _p = Constants.getObjectSensitivityScopePattern();
        this.pattern = _p != null ? Pattern.compile(_p) : null;
        this.objectSensitiveArrayTracking = Constants.getObjectSensitiveArrayTracking();
    }

    @Override
    protected OneContextInfoIndex<E, Object> createIndex(E o, Context c) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting index for " + o + " in " + c);
        }
        AllocationContext _ctxt = (AllocationContext)c;
        Type _type = ((Value)_ctxt.allocationSite).getType();
        if (_type instanceof RefType && (this.pattern == null || this.pattern.matcher(((RefType)_type).getClassName()).matches()) || this.objectSensitiveArrayTracking && _type instanceof ArrayType) {
            return new OneContextInfoIndex<E, Object>(o, _ctxt.getAllocationSite());
        }
        return new OneContextInfoIndex<E, Object>(o, null);
    }
}

