/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.MetricsProcessor;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CGBasedXMLizingProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAStringizer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAXMLizer;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OFAXMLizerCLI
extends SootBasedDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(OFAXMLizerCLI.class);
    private boolean cumulative;
    private String type;
    private final OFAXMLizer xmlizer = new OFAXMLizer();

    public static String getBaseNameOfFileAndRootMethods(Object root, Collection<SootMethod> methods) {
        String _result;
        if (root instanceof SootMethod) {
            SootMethod _sm = (SootMethod)root;
            _result = (String.valueOf(_sm.getDeclaringClass().getJavaStyleName()) + "_" + _sm.getSubSignature()).replaceAll(" ", "_");
            methods.add(_sm);
        } else {
            _result = "cumulative_" + System.currentTimeMillis();
            methods.addAll((Collection)root);
        }
        return _result;
    }

    public static void main(String[] args) {
        Options _options = new Options();
        Option _option = new Option("c", "cumulative", false, "Consider all root methods in the same execution.");
        _options.addOption(_option);
        _option = new Option("o", "output", true, "Directory into which xml files will be written into.");
        _option.setArgs(1);
        _options.addOption(_option);
        _option = new Option("j", "jimple", false, "Dump xmlized jimple.");
        _options.addOption(_option);
        _option = new Option("h", "help", false, "Display message.");
        _options.addOption(_option);
        _option = new Option("p", "soot-classpath", false, "Prepend this to soot class path.");
        _option.setArgs(1);
        _option.setArgName("classpath");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("t", "ofa-type", false, "Type of analysis : fioi, fsoi, fios, fsos, fioirt, fsoirt.");
        _option.setArgs(1);
        _option.setArgName("type");
        _option.setOptionalArg(false);
        _option.setRequired(true);
        _options.addOption(_option);
        _option = new Option("S", "scope", true, "The scope that should be analyzed.");
        _option.setArgs(1);
        _option.setArgName("scope");
        _option.setRequired(false);
        _options.addOption(_option);
        PosixParser _parser = new PosixParser();
        try {
            String _outputDir;
            CommandLine _cl = _parser.parse(_options, args);
            if (_cl.hasOption("h")) {
                OFAXMLizerCLI.printUsage(_options);
                System.exit(1);
            }
            if ((_outputDir = _cl.getOptionValue('o')) == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Defaulting to current directory for output.");
                }
                _outputDir = ".";
            }
            if (_cl.getArgList().isEmpty()) {
                throw new MissingArgumentException("Please specify atleast one class.");
            }
            OFAXMLizerCLI _cli = new OFAXMLizerCLI();
            _cli.xmlizer.setXmlOutputDir(_outputDir);
            _cli.xmlizer.setGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
            _cli.setCumulative(_cl.hasOption('c'));
            _cli.setClassNames(_cl.getArgList());
            _cli.type = _cl.getOptionValue('t');
            if (_cl.hasOption('p')) {
                _cli.addToSootClassPath(_cl.getOptionValue('p'));
            }
            if (_cl.hasOption('S')) {
                _cli.setScopeSpecFile(_cl.getOptionValue('S'));
            }
            _cli.initialize();
            _cli.execute(_cl.hasOption('j'));
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            System.out.println("Error while parsing command line. \n" + (Object)((Object)_e));
            OFAXMLizerCLI.printUsage(_options);
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    private static void printUsage(Options options) {
        String _cmdLineSyn = "java " + OFAXMLizerCLI.class.getName() + " <options> <classnames>";
        new HelpFormatter().printHelp(_cmdLineSyn, "Options are: ", options, "");
    }

    private <T extends ITokens<T, Value>> void execute(boolean dumpJimple) {
        IValueAnalyzer _aa;
        this.setInfoLogger(LOGGER);
        if (this.type.equals("fioi")) {
            _aa = OFAnalyzer.getFIOIAnalyzer("OFAXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else if (this.type.equals("fios")) {
            _aa = OFAnalyzer.getFIOSAnalyzer("OFAXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else if (this.type.equals("fsoi")) {
            _aa = OFAnalyzer.getFSOIAnalyzer("OFAXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else if (this.type.equals("fsos")) {
            _aa = OFAnalyzer.getFSOSAnalyzer("OFAXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else if (this.type.equals("fioirt")) {
            _aa = OFAnalyzer.getFSOIRTAnalyzer("OFAXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else if (this.type.equals("fsoirt")) {
            _aa = OFAnalyzer.getFSOIRTAnalyzer("OFAXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        } else {
            throw new IllegalArgumentException("ofa-type has to be one of the following: fioi, fsoi, fios, fsos, fioirt, fsoirt.");
        }
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList<OFABasedCallInfoCollector> _processors = new ArrayList<OFABasedCallInfoCollector>();
        CallGraphInfo _cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        ArrayList<SootMethod> _rm = new ArrayList<SootMethod>();
        ProcessingController _xmlcgipc = new ProcessingController();
        MetricsProcessor _countingProcessor = new MetricsProcessor();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(_aa);
        TagBasedProcessingFilter _tagFilter = new TagBasedProcessingFilter("OFAXMLizer:FA");
        _pc.setProcessingFilter((IProcessingFilter)_tagFilter);
        _xmlcgipc.setEnvironment(_aa.getEnvironment());
        CGBasedXMLizingProcessingFilter _xmlFilter = new CGBasedXMLizingProcessingFilter(_cgi);
        _xmlFilter.chain((IProcessingFilter)_tagFilter);
        _xmlcgipc.setProcessingFilter((IProcessingFilter)_xmlFilter);
        _xmlcgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        HashMap<Object, Object> _info = new HashMap<Object, Object>();
        _info.put(IValueAnalyzer.ID, _aa);
        _info.put("id of tag used by flow analysis", "OFAXMLizer:FA");
        ArrayList<Collection> _roots = new ArrayList<Collection>();
        if (this.cumulative) {
            _roots.add(this.getRootMethods());
        } else {
            _roots.addAll(this.getRootMethods());
        }
        Collections.sort(_roots, ToStringBasedComparator.getComparator());
        this.writeInfo("Root methods are: " + _roots.size() + "\n" + _roots);
        Iterator _k = _roots.iterator();
        while (_k.hasNext()) {
            _rm.clear();
            Object _root = _k.next();
            String _fileBaseName = OFAXMLizerCLI.getBaseNameOfFileAndRootMethods(_root, _rm);
            this.writeInfo("RootMethod: " + _root);
            this.writeInfo("BEGIN: FA");
            long _start = System.currentTimeMillis();
            _aa.reset();
            this.getBbm().reset();
            _aa.analyze(this.getEnvironment(), _rm);
            long _stop = System.currentTimeMillis();
            this.addTimeLog("FA", _stop - _start);
            this.writeInfo("END: FA");
            _callGraphInfoCollector.reset();
            _processors.clear();
            _processors.add(_callGraphInfoCollector);
            _processors.add((OFABasedCallInfoCollector)_countingProcessor);
            _pc.reset();
            _pc.driveProcessors(_processors);
            _processors.clear();
            _cgi.reset();
            _cgi.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
            ByteArrayOutputStream _stream = new ByteArrayOutputStream();
            new PrintWriter(_stream).write("STATISTICS: " + MapUtils.verbosePrint(new TreeMap(_countingProcessor.getStatistics())));
            this.writeInfo(_stream.toString());
            _info.put(AbstractXMLizer.FILE_NAME_ID, _fileBaseName);
            _info.put(IStmtGraphFactory.ID, this.getStmtGraphFactory());
            this.xmlizer.writeXML(_info);
            if (dumpJimple) {
                this.xmlizer.dumpJimple(_fileBaseName, this.xmlizer.getXmlOutputDir(), _xmlcgipc);
            }
            OFAStringizer _str = new OFAStringizer();
            _str.getOFAInfoAsString(_info, new PrintWriter(System.out));
        }
    }

    private void setCumulative(boolean option) {
        this.cumulative = option;
    }
}

