/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.SootClass;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;

public final class OFAXMLizer
extends AbstractXMLizer {
    static final Logger LOGGER = LoggerFactory.getLogger(OFAXMLizer.class);

    public String getFileName(String name) {
        return "ofa_" + OFAXMLizer.xmlizeString((String)name) + ".xml";
    }

    public void writeXML(Map info) {
        ProcessingController _ctrl = new ProcessingController();
        OFAnalyzer _ofa = (OFAnalyzer)info.get(IValueAnalyzer.ID);
        IEnvironment _env = _ofa.getEnvironment();
        TagBasedProcessingFilter _processingFilter = new TagBasedProcessingFilter((String)info.get("id of tag used by flow analysis"));
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory((IStmtGraphFactory)info.get(IStmtGraphFactory.ID));
        _ctrl.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _ctrl.setProcessingFilter((IProcessingFilter)_processingFilter);
        _ctrl.setEnvironment(_env);
        _processingFilter.chain((IProcessingFilter)new XMLizingProcessingFilter());
        File _f = new File(String.valueOf(this.getXmlOutputDir()) + File.separator + this.getFileName((String)info.get(FILE_NAME_ID)));
        try {
            FileWriter _writer = new FileWriter(_f);
            OFAXMLizingProcessor _processor = new OFAXMLizingProcessor(_writer, _ofa);
            _processor.hookup(_ctrl);
            _ctrl.process();
            _processor.unhook(_ctrl);
            _writer.close();
        }
        catch (IOException _e) {
            LOGGER.error("Error while xmlizing OFA information ", (Throwable)_e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OFAXMLizingProcessor
    extends AbstractProcessor {
        private final IJimpleIDGenerator idGenerator;
        private OFAnalyzer<?> ofa;
        private XMLOutputter xmlWriter;
        private boolean processingClass;
        private boolean processingMethod;

        public OFAXMLizingProcessor(FileWriter filewriter, OFAnalyzer<?> analyzer) {
            this.idGenerator = OFAXMLizer.this.getIdGenerator();
            this.ofa = analyzer;
            try {
                this.xmlWriter = new CustomXMLOutputter((Writer)filewriter);
            }
            catch (UnsupportedEncodingException _e) {
                LOGGER.error("This is not supposed to happen", (Throwable)_e);
            }
        }

        public void callback(ValueBox vBox, Context context) {
            ArrayList<String> _temp = new ArrayList<String>();
            Iterator _i = this.ofa.getValues(vBox.getValue(), context).iterator();
            while (_i.hasNext()) {
                _temp.add(_i.next().toString());
            }
            if (!_temp.isEmpty()) {
                Collections.sort(_temp);
                try {
                    Stmt _stmt = context.getStmt();
                    SootMethod _method = context.getCurrentMethod();
                    this.xmlWriter.startTag("program_point");
                    this.xmlWriter.attribute("id", this.idGenerator.getIdForValueBox(vBox, _stmt, _method));
                    Iterator _i2 = _temp.iterator();
                    while (_i2.hasNext()) {
                        this.xmlWriter.startTag("object");
                        this.xmlWriter.attribute("expr", OFAXMLizer.xmlizeString((String)((String)_i2.next())));
                        this.xmlWriter.endTag();
                    }
                    this.xmlWriter.endTag();
                }
                catch (IOException _e) {
                    LOGGER.error("Error while xmlizing OFA information ", (Throwable)_e);
                }
            }
        }

        public void callback(SootMethod method) {
            try {
                if (this.processingMethod) {
                    this.xmlWriter.endTag();
                } else {
                    this.processingMethod = true;
                }
                this.xmlWriter.startTag("method");
                this.xmlWriter.attribute("id", this.idGenerator.getIdForMethod(method));
                this.xmlWriter.attribute("name", method.getSignature());
                this.xmlizeParameterValues(method);
                this.xmlizeThrownValues(method);
            }
            catch (IOException _e) {
                LOGGER.error("Error while xmlizing OFA information ", (Throwable)_e);
            }
        }

        private void xmlizeThrownValues(SootMethod method) {
            ArrayList<String> _temp = new ArrayList<String>();
            Context _context = new Context();
            _context.setRootMethod(method);
            Iterator<Object> _i = this.ofa.getThrownValues(method, _context).iterator();
            while (_i.hasNext()) {
                _temp.add(_i.next().toString());
            }
            if (!_temp.isEmpty()) {
                Collections.sort(_temp);
                try {
                    this.xmlWriter.startTag("thrown");
                    _i = _temp.iterator();
                    while (_i.hasNext()) {
                        this.xmlWriter.startTag("object");
                        this.xmlWriter.attribute("expr", OFAXMLizer.xmlizeString((String)((String)_i.next())));
                        this.xmlWriter.endTag();
                    }
                    this.xmlWriter.endTag();
                }
                catch (IOException _e) {
                    LOGGER.error("Error while xmlizing OFA information ", (Throwable)_e);
                }
            }
        }

        private void xmlizeParameterValues(SootMethod method) throws IllegalStateException, IllegalArgumentException {
            ArrayList<String> _temp = new ArrayList<String>();
            Context _context = new Context();
            _context.setRootMethod(method);
            int _j = 0;
            while (_j < method.getParameterCount()) {
                _temp.clear();
                Iterator<Object> _i = this.ofa.getValuesForParameter(_j, _context).iterator();
                while (_i.hasNext()) {
                    _temp.add(_i.next().toString());
                }
                if (!_temp.isEmpty()) {
                    Collections.sort(_temp);
                    try {
                        this.xmlWriter.startTag("parameter");
                        this.xmlWriter.attribute("id", Integer.toString(_j));
                        _i = _temp.iterator();
                        while (_i.hasNext()) {
                            this.xmlWriter.startTag("object");
                            this.xmlWriter.attribute("expr", OFAXMLizer.xmlizeString((String)((String)_i.next())));
                            this.xmlWriter.endTag();
                        }
                        this.xmlWriter.endTag();
                    }
                    catch (IOException _e) {
                        LOGGER.error("Error while xmlizing OFA information ", (Throwable)_e);
                    }
                }
                ++_j;
            }
        }

        public void callback(SootClass clazz) {
            try {
                if (this.processingMethod) {
                    this.xmlWriter.endTag();
                }
                if (this.processingClass) {
                    this.xmlWriter.endTag();
                } else {
                    this.processingClass = true;
                }
                this.xmlWriter.startTag("class");
                this.xmlWriter.attribute("id", this.idGenerator.getIdForClass(clazz));
                this.xmlWriter.attribute("name", clazz.getName());
            }
            catch (IOException _e) {
                LOGGER.error("Error while xmlizing OFA information ", (Throwable)_e);
            }
            this.processingMethod = false;
        }

        public void consolidate() {
            try {
                this.xmlWriter.endDocument();
            }
            catch (IOException _e) {
                LOGGER.error("Error while xmlizing OFA information ", (Throwable)_e);
            }
        }

        public void hookup(ProcessingController ppc) {
            ppc.registerForAllValues((IProcessor)this);
            ppc.register((IProcessor)this);
        }

        public void processingBegins() {
            this.processingClass = false;
            this.processingMethod = false;
            try {
                this.xmlWriter.declaration();
                this.xmlWriter.startTag("ofa");
            }
            catch (IOException _e) {
                LOGGER.error("Error while xmlizing OFA information ", (Throwable)_e);
            }
        }

        public void unhook(ProcessingController ppc) {
            ppc.unregisterForAllValues((IProcessor)this);
            ppc.unregister((IProcessor)this);
        }
    }
}

