/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.xmlizer.XMLizingProcessingFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.ValueBox;
import soot.jimple.Stmt;

public final class OFAStringizer {
    static final Logger LOGGER = LoggerFactory.getLogger(OFAStringizer.class);

    public void getOFAInfoAsString(Map info, Writer writer) {
        ProcessingController _ctrl = new ProcessingController();
        OFAnalyzer _ofa = (OFAnalyzer)info.get(IValueAnalyzer.ID);
        IEnvironment _env = _ofa.getEnvironment();
        TagBasedProcessingFilter _processingFilter = new TagBasedProcessingFilter((String)info.get("id of tag used by flow analysis"));
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory((IStmtGraphFactory)info.get(IStmtGraphFactory.ID));
        _ctrl.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _ctrl.setProcessingFilter((IProcessingFilter)_processingFilter);
        _ctrl.setEnvironment(_env);
        _processingFilter.chain((IProcessingFilter)new XMLizingProcessingFilter());
        OFAXMLizingProcessor _processor = new OFAXMLizingProcessor(_ofa, writer);
        _processor.hookup(_ctrl);
        _ctrl.process();
        _processor.unhook(_ctrl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OFAXMLizingProcessor
    extends AbstractProcessor {
        private OFAnalyzer<?> ofa;
        private final Writer writer;

        public OFAXMLizingProcessor(OFAnalyzer<?> analyzer, Writer w) {
            this.ofa = analyzer;
            this.writer = w;
        }

        public void callback(ValueBox vBox, Context context) {
            try {
                this.writer.append("\n\t\t<");
                this.writer.append(vBox.getValue().toString());
                this.writer.append(">: ");
                Iterator _i = this.ofa.getValues(vBox.getValue(), context).iterator();
                while (_i.hasNext()) {
                    this.writer.append(_i.next().toString());
                    this.writer.append(", ");
                }
            }
            catch (IOException _e) {
                throw new RuntimeException(_e);
            }
        }

        public void callback(SootMethod method) {
            try {
                this.writer.append('\n');
                this.writer.append(method.getSignature());
            }
            catch (IOException _e) {
                throw new RuntimeException(_e);
            }
            this.xmlizeParameterValues(method);
            this.xmlizeThrownValues(method);
        }

        public void callback(Stmt stmt, Context context) {
            try {
                this.writer.append("\n\t");
                this.writer.append(stmt.toString());
            }
            catch (IOException _e) {
                throw new RuntimeException(_e);
            }
        }

        private void xmlizeThrownValues(SootMethod method) {
            Context _context = new Context();
            _context.setRootMethod(method);
            try {
                this.writer.append("\n\tThrows: ");
                Iterator _i = this.ofa.getThrownValues(method, _context).iterator();
                while (_i.hasNext()) {
                    this.writer.append(_i.next().toString());
                    this.writer.append(", ");
                }
            }
            catch (IOException _e) {
                throw new RuntimeException(_e);
            }
        }

        private void xmlizeParameterValues(SootMethod method) {
            Context _context = new Context();
            _context.setRootMethod(method);
            try {
                int _j = 0;
                while (_j < method.getParameterCount()) {
                    this.writer.append("\n\t");
                    this.writer.append("Param_");
                    this.writer.append(String.valueOf(_j));
                    this.writer.append(": ");
                    Iterator _i = this.ofa.getValuesForParameter(_j, _context).iterator();
                    while (_i.hasNext()) {
                        this.writer.append(_i.next().toString());
                        this.writer.append(", ");
                    }
                    ++_j;
                }
            }
            catch (IOException _e) {
                throw new RuntimeException(_e);
            }
        }

        public void hookup(ProcessingController ppc) {
            ppc.registerForAllValues((IProcessor)this);
            ppc.registerForAllStmts((IProcessor)this);
            ppc.register((IProcessor)this);
        }

        public void unhook(ProcessingController ppc) {
            ppc.unregisterForAllValues((IProcessor)this);
            ppc.unregisterForAllStmts((IProcessor)this);
            ppc.unregister((IProcessor)this);
        }
    }
}

