/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IVariantManager;
import edu.ksu.cis.indus.staticanalyses.flow.ValuedVariant;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAFGNode;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.IType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Trap;
import soot.TrapManager;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.IdentityStmt;
import soot.jimple.JimpleBody;
import soot.jimple.Stmt;
import soot.jimple.ThrowStmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodVariant<T extends ITokens<T, Value>>
extends AbstractMethodVariant<Value, T, OFAFGNode<T>, Type> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodVariant.class);
    private IStmtGraphFactory<?> stmtGraphFactory;

    protected MethodVariant(SootMethod sm, IVariantManager<ValuedVariant<OFAFGNode<T>>, Value> astVariantManager, FA<Value, T, OFAFGNode<T>, Type> theFA, IStmtGraphFactory<?> factory) {
        super(sm, astVariantManager, theFA);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: preprocessing of " + sm);
        }
        ITokenManager _tokenMgr = this.fa.getTokenManager();
        if (this.thisVar != null) {
            RefType _sootType = sm.getDeclaringClass().getType();
            MethodVariant.setFilterOfBasedOn((OFAFGNode)this.thisVar, (Type)_sootType, _tokenMgr);
        }
        if (this.returnVar != null) {
            MethodVariant.setFilterOfBasedOn((OFAFGNode)this.returnVar, sm.getReturnType(), _tokenMgr);
        }
        int _i = this.parameters.size() - 1;
        while (_i >= 0) {
            OFAFGNode _pNode = (OFAFGNode)this.parameters.get(_i);
            if (_pNode != null) {
                MethodVariant.setFilterOfBasedOn(_pNode, sm.getParameterType(_i), _tokenMgr);
            }
            --_i;
        }
        MethodVariant.setFilterOfBasedOn((OFAFGNode)this.thrownNode, (Type)this.fa.getClass("java.lang.Throwable").getType(), _tokenMgr);
        this.stmtGraphFactory = factory;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: preprocessed " + sm);
        }
    }

    static <T extends ITokens<T, Value>> void setFilterOfBasedOn(OFAFGNode<T> node, Type type, ITokenManager<T, Value, Type> tokenMgr) {
        if (node != null) {
            IType _baseType = tokenMgr.getTypeManager().getTokenTypeForRepType(type);
            ITokenFilter<T, Value> _baseFilter = tokenMgr.getTypeBasedFilter(_baseType);
            node.setFilter(_baseFilter);
        }
    }

    @Override
    public void process() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: processing of " + this.method);
        }
        if (this.method.isConcrete()) {
            JimpleBody _jb = (JimpleBody)this.stmtGraphFactory.getStmtGraph(this.method).getBody();
            ArrayList<Stmt> _stmtList = new ArrayList<Stmt>((Collection<Stmt>)_jb.getUnits());
            Iterator _i = _stmtList.iterator();
            while (_i.hasNext()) {
                this.stmt.process((Stmt)_i.next());
            }
            this.processBody(_jb, _stmtList);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.method + " is not a concrete method. Hence, it's body could not be retrieved.");
        }
        this.stmtGraphFactory = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: processing of " + this.method);
        }
    }

    @Override
    protected boolean shouldConsider(Type type) {
        return Util.isReferenceType((Type)type);
    }

    private void connectThrowNodesToThrownNode(JimpleBody body, List<Stmt> stmtList) {
        Context _ctxt = new Context();
        _ctxt.setRootMethod(this.method);
        Iterator<Stmt> _j = stmtList.iterator();
        int _jEnd = stmtList.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            Stmt _stmt = _j.next();
            _ctxt.setStmt(_stmt);
            if (_stmt instanceof ThrowStmt) {
                List _t = TrapManager.getTrapsAt((Unit)_stmt, (Body)body);
                ThrowStmt _throwStmt = (ThrowStmt)_stmt;
                SootClass _exp = ((RefType)_throwStmt.getOp().getType()).getSootClass();
                boolean _exceptionIsUncaught = true;
                Iterator _i = _t.iterator();
                while (_i.hasNext() && _exceptionIsUncaught) {
                    Trap _trap = (Trap)_i.next();
                    SootClass _sc = _trap.getException();
                    boolean bl = _exceptionIsUncaught = !_exp.equals(_sc) && !Util.isDescendentOf((SootClass)_exp, (SootClass)_sc);
                }
                if (_t.isEmpty() || _exceptionIsUncaught) {
                    _ctxt.setProgramPoint(_throwStmt.getOpBox());
                    ((OFAFGNode)this.queryASTNode(_throwStmt.getOp(), _ctxt)).addSucc((OFAFGNode)this.thrownNode);
                }
            } else if (_stmt.containsInvokeExpr()) {
                _ctxt.setProgramPoint(_stmt.getInvokeExprBox());
                ((OFAFGNode)this.queryThrowNode(_stmt.getInvokeExpr(), _ctxt)).addSucc((OFAFGNode)this.thrownNode);
            }
            ++_jIndex;
        }
    }

    private void processBody(JimpleBody body, List<Stmt> stmtList) {
        HashSet<ThrowStmt> _caught = new HashSet<ThrowStmt>();
        Context _exprCtxt = new Context();
        Context _catchCtxt = new Context();
        _exprCtxt.setRootMethod(this.method);
        _catchCtxt.setRootMethod(this.method);
        for (Trap _trap : body.getTraps()) {
            Stmt _begin = (Stmt)_trap.getBeginUnit();
            Stmt _end = (Stmt)_trap.getEndUnit();
            IdentityStmt _handlerStmt = (IdentityStmt)_trap.getHandlerUnit();
            CaughtExceptionRef _catchRef = (CaughtExceptionRef)_handlerStmt.getRightOp();
            SootClass _exception = _trap.getException();
            _catchCtxt.setStmt((Stmt)_handlerStmt);
            _catchCtxt.setProgramPoint(_handlerStmt.getRightOpBox());
            int _k = stmtList.indexOf(_end);
            int _j = stmtList.indexOf(_begin);
            while (_j < _k) {
                Stmt _tmp = stmtList.get(_j);
                if (!_caught.contains(_tmp)) {
                    _exprCtxt.setStmt(_tmp);
                    if (_tmp instanceof ThrowStmt) {
                        ThrowStmt _ts = (ThrowStmt)_tmp;
                        Value _op = _ts.getOp();
                        SootClass _scTemp = this.fa.getClass(((RefType)_op.getType()).getClassName());
                        if (Util.isDescendentOf((SootClass)_scTemp, (SootClass)_exception)) {
                            _exprCtxt.setProgramPoint(_ts.getOpBox());
                            OFAFGNode _throwNode = (OFAFGNode)this.getASTNode(_op, _exprCtxt);
                            _throwNode.addSucc((OFAFGNode)this.queryASTNode((Value)_catchRef, _catchCtxt));
                            _caught.add(_ts);
                        }
                    } else if (_tmp.containsInvokeExpr()) {
                        _exprCtxt.setProgramPoint(_tmp.getInvokeExprBox());
                        OFAFGNode _tempNode = (OFAFGNode)this.queryThrowNode(_tmp.getInvokeExpr(), _exprCtxt);
                        if (_tempNode != null) {
                            _tempNode.addSucc((OFAFGNode)this.queryASTNode((Value)_catchRef, _catchCtxt));
                        }
                    }
                }
                ++_j;
            }
        }
        this.connectThrowNodesToThrownNode(body, stmtList);
    }
}

