/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.AbstractAccessExprWork;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAFGNode;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.RefLikeType;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.ValueBox;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InvokeExprWork<T extends ITokens<T, Value>>
extends AbstractAccessExprWork<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokeExprWork.class);
    protected final boolean returnsRefLikeType;
    private final Collection<IMethodVariant<OFAFGNode<T>>> installedVariants = new HashSet<IMethodVariant<OFAFGNode<T>>>();

    public InvokeExprWork(IMethodVariant<OFAFGNode<T>> callerMethod, Context callContext, T tokenSet) {
        super(callerMethod, callContext, tokenSet);
        ValueBox _invocationExpr = callContext.getProgramPoint();
        if (!(_invocationExpr.getValue() instanceof InstanceInvokeExpr)) {
            throw new IllegalArgumentException("accessExprBox has to contain a InstanceInvokeExpr object as value.");
        }
        InstanceInvokeExpr _ie = (InstanceInvokeExpr)_invocationExpr.getValue();
        this.returnsRefLikeType = _ie.getMethod().getReturnType() instanceof RefLikeType;
    }

    public synchronized void execute() {
        InstanceInvokeExpr _e = (InstanceInvokeExpr)this.accessExprBox.getValue();
        ValueBox _vb = this.context.getProgramPoint();
        Collection _values = this.tokens.getValues();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(_values + " values arrived at base node of " + this.accessExprBox.getValue() + " in " + this.context);
        }
        for (Value _v : _values) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Value: " + _v);
            }
            if (_v instanceof NullConstant) continue;
            try {
                this.processExprAgainstReceiver(_e, _v);
            }
            catch (IllegalStateException _excp) {
                this.context.setProgramPoint(_vb);
                throw _excp;
            }
        }
        this.context.setProgramPoint(_vb);
        this.tokens.clear();
    }

    public String toString() {
        return "InvokeExprWork: " + this.caller.getMethod() + "@" + this.accessExprBox.getValue();
    }

    private void processExprAgainstReceiver(InstanceInvokeExpr expr, Value receiver) {
        SootMethod _sm;
        SootClass _sc;
        Type _t = receiver.getType();
        FA _fa = this.caller.getFA();
        if (_t instanceof RefType) {
            _sc = _fa.getClass(((RefType)receiver.getType()).getClassName());
        } else if (_t instanceof ArrayType) {
            _sc = _fa.getClass("java.lang.Object");
        } else {
            IllegalStateException _excp = new IllegalStateException("Non-reference/array type flowing into invocation site.");
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(expr.toString());
            }
            throw _excp;
        }
        try {
            _sm = Util.findDeclaringMethod((SootClass)_sc, (SootMethod)expr.getMethod());
        }
        catch (IllegalStateException _excp) {
            LOGGER.error(_sc + ":" + this.context.getCurrentMethod() + "@" + expr, (Throwable)_excp);
            throw _excp;
        }
        IMethodVariant _mv = _fa.getMethodVariant(_sm, this.context);
        if (!this.installedVariants.contains(_mv)) {
            int _j = 0;
            while (_j < _sm.getParameterCount()) {
                if (_sm.getParameterType(_j) instanceof RefLikeType) {
                    OFAFGNode _param = (OFAFGNode)_mv.queryParameterNode(_j);
                    this.context.setProgramPoint(expr.getArgBox(_j));
                    OFAFGNode _arg = (OFAFGNode)this.caller.queryASTNode(expr.getArg(_j), this.context);
                    _arg.addSucc(_param);
                }
                ++_j;
            }
            OFAFGNode _thisNode = (OFAFGNode)_mv.queryThisNode();
            this.context.setProgramPoint(expr.getBaseBox());
            OFAFGNode _receiverNode = (OFAFGNode)this.caller.queryASTNode(expr.getBase(), this.context);
            _receiverNode.addSucc(_thisNode);
            OFAFGNode _thrownNode = (OFAFGNode)_mv.queryThrownNode();
            this.context.setProgramPoint(this.accessExprBox);
            OFAFGNode _receivingNode = (OFAFGNode)this.caller.queryThrowNode((InvokeExpr)expr, this.context);
            _thrownNode.addSucc(_receivingNode);
            if (this.returnsRefLikeType) {
                OFAFGNode _returnNode = (OFAFGNode)_mv.queryReturnNode();
                OFAFGNode _returnValueNode = (OFAFGNode)this.caller.queryASTNode((Value)expr, this.context);
                _returnNode.addSucc(_returnValueNode);
            }
            this.installedVariants.add(_mv);
        }
    }
}

