/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.annotations.NonNull;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractExprSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNodeConnector;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IStmtSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.InvocationVariant;
import edu.ksu.cis.indus.staticanalyses.flow.ValuedVariant;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.ArrayAccessExprWork;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.FGAccessNode;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.FieldAccessExprWork;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.InvokeExprWork;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.MethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.Value2ValueMapper;
import edu.ksu.cis.indus.staticanalyses.flow.modes.sensitive.allocation.AllocationContext;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Local;
import soot.SootField;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.StringConstant;
import soot.jimple.ThisRef;
import soot.jimple.UnopExpr;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FlowInsensitiveExprSwitch<T extends ITokens<T, Value>>
extends AbstractExprSwitch<FlowInsensitiveExprSwitch<T>, Value, T, OFAFGNode<T>, Type> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowInsensitiveExprSwitch.class);
    private static final Map<String, StringConstant> STR_TO_CONST = new HashMap<String, StringConstant>();
    protected final ITokenManager<T, Value, Type> tokenMgr;
    protected final Value2ValueMapper valueRetriever;

    FlowInsensitiveExprSwitch(@NonNull IFGNodeConnector<OFAFGNode<T>> nodeConnector, @NonNull Value2ValueMapper type2valueMapper, @NonNull IStmtSwitch statementSwitch) {
        super(statementSwitch, nodeConnector);
        this.tokenMgr = this.fa != null ? this.fa.getTokenManager() : null;
        this.valueRetriever = type2valueMapper;
    }

    public void caseArrayRef(ArrayRef e) {
        this.process(e.getBaseBox());
        OFAFGNode _baseNode = (OFAFGNode)this.getFlowNode();
        OFAFGNode _ast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        MethodVariant.setFilterOfBasedOn(_ast, e.getType(), this.tokenMgr);
        ArrayAccessExprWork<T> _work = new ArrayAccessExprWork<T>(this.method, this.context, _ast, this.connector, this.tokenMgr.getNewTokenSet());
        FGAccessNode<T> _temp = new FGAccessNode<T>(_work, this.fa, this.tokenMgr);
        MethodVariant.setFilterOfBasedOn(_temp, e.getBase().getType(), this.tokenMgr);
        _baseNode.addSucc(_temp);
        this.process(e.getIndexBox());
        this.setFlowNode(_ast);
    }

    public void caseCastExpr(CastExpr e) {
        this.process(e.getOpBox());
        if (Util.isReferenceType((Type)e.getCastType())) {
            OFAFGNode _base = (OFAFGNode)this.getFlowNode();
            OFAFGNode _cast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
            MethodVariant.setFilterOfBasedOn(_cast, e.getType(), this.tokenMgr);
            _base.addSucc(_cast);
            this.setFlowNode(_cast);
        }
    }

    public void caseCaughtExceptionRef(CaughtExceptionRef e) {
        OFAFGNode _node = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        MethodVariant.setFilterOfBasedOn(_node, e.getType(), this.tokenMgr);
        this.setFlowNode(_node);
    }

    public void caseInstanceFieldRef(InstanceFieldRef e) {
        this.process(e.getBaseBox());
        OFAFGNode _baseNode = (OFAFGNode)this.getFlowNode();
        OFAFGNode _ast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        MethodVariant.setFilterOfBasedOn(_ast, e.getType(), this.tokenMgr);
        FieldAccessExprWork<T> _work = new FieldAccessExprWork<T>(this.method, this.context, _ast, this.connector, this.tokenMgr.getNewTokenSet());
        FGAccessNode<T> _temp = new FGAccessNode<T>(_work, this.fa, this.tokenMgr);
        MethodVariant.setFilterOfBasedOn(_temp, e.getBase().getType(), this.tokenMgr);
        _baseNode.addSucc(_temp);
        this.setFlowNode(_ast);
    }

    public void caseInstanceOfExpr(InstanceOfExpr e) {
        this.process(e.getOpBox());
    }

    public void caseInterfaceInvokeExpr(InterfaceInvokeExpr e) {
        this.processInstanceInvokeExpr((InstanceInvokeExpr)e);
    }

    public void caseLocal(Local e) {
        OFAFGNode _node = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        MethodVariant.setFilterOfBasedOn(_node, e.getType(), this.tokenMgr);
        this.setFlowNode(_node);
    }

    public void caseNewArrayExpr(NewArrayExpr e) {
        this.process(e.getSizeBox());
        Object _temp = null;
        boolean _flag = this.context instanceof AllocationContext;
        if (_flag) {
            _temp = ((AllocationContext)this.context).setAllocationSite(e);
        }
        OFAFGNode _ast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        MethodVariant.setFilterOfBasedOn(_ast, e.getType(), this.tokenMgr);
        this.fa.getArrayVariant((ArrayType)e.getType(), this.context);
        _ast.injectValue(this.valueRetriever.getValue((Value)e));
        this.setFlowNode(_ast);
        if (_flag) {
            ((AllocationContext)this.context).setAllocationSite(_temp);
        }
    }

    public void caseNewExpr(NewExpr e) {
        OFAFGNode _ast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        MethodVariant.setFilterOfBasedOn(_ast, e.getType(), this.tokenMgr);
        _ast.injectValue(this.valueRetriever.getValue((Value)e));
        this.setFlowNode(_ast);
    }

    public void caseNewMultiArrayExpr(NewMultiArrayExpr e) {
        ArrayType _arrayType = e.getBaseType();
        Type _baseType = _arrayType.baseType;
        Object _temp = null;
        boolean _flag = this.context instanceof AllocationContext;
        if (_flag) {
            _temp = ((AllocationContext)this.context).setAllocationSite(e);
        }
        int _i = _arrayType.numDimensions;
        int _sizes = e.getSizeCount();
        while (_i > 0 && _sizes > 0) {
            ArrayType _aType = ArrayType.v((Type)_baseType, (int)_i);
            ValuedVariant _array = this.fa.getArrayVariant(_aType, this.context);
            this.process(e.getSizeBox(_sizes - 1));
            ((OFAFGNode)_array.getFGNode()).injectValue(this.valueRetriever.getValue((Value)e));
            --_i;
            --_sizes;
        }
        if (_flag) {
            ((AllocationContext)this.context).setAllocationSite(_temp);
        }
        OFAFGNode _ast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        MethodVariant.setFilterOfBasedOn(_ast, e.getType(), this.tokenMgr);
        _ast.injectValue(this.valueRetriever.getValue((Value)e));
        this.setFlowNode(_ast);
    }

    public void caseNullConstant(NullConstant e) {
        OFAFGNode _ast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        _ast.injectValue((Value)e);
        this.setFlowNode(_ast);
    }

    public void caseParameterRef(ParameterRef e) {
        OFAFGNode _node = (OFAFGNode)this.method.queryParameterNode(e.getIndex());
        this.setFlowNode(_node);
    }

    public void caseSpecialInvokeExpr(SpecialInvokeExpr e) {
        this.processInvokedMethod((InvokeExpr)e);
    }

    public void caseStaticFieldRef(StaticFieldRef e) {
        SootField _field = e.getField();
        OFAFGNode _ast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        MethodVariant.setFilterOfBasedOn(_ast, e.getType(), this.tokenMgr);
        OFAFGNode _nonast = (OFAFGNode)this.fa.getFieldVariant(_field).getFGNode();
        MethodVariant.setFilterOfBasedOn(_nonast, _field.getType(), this.tokenMgr);
        this.connector.connect(_ast, _nonast);
        this.setFlowNode(_ast);
    }

    public void caseStaticInvokeExpr(StaticInvokeExpr e) {
        this.processInvokedMethod((InvokeExpr)e);
    }

    public void caseStringConstant(StringConstant e) {
        OFAFGNode _ast = (OFAFGNode)this.method.getASTNode((Value)e, this.context);
        _ast.injectValue((Value)this.getCanonicalStringConstant(e));
        this.setFlowNode(_ast);
    }

    public void caseThisRef(ThisRef e) {
        this.setFlowNode((OFAFGNode)this.method.queryThisNode());
    }

    public void caseVirtualInvokeExpr(VirtualInvokeExpr e) {
        this.processInstanceInvokeExpr((InstanceInvokeExpr)e);
    }

    @Override
    public void defaultCase(Object o) {
        Value _v = (Value)o;
        if (_v instanceof BinopExpr) {
            BinopExpr _temp = (BinopExpr)_v;
            this.process(_temp.getOp1Box());
            this.process(_temp.getOp2Box());
        } else if (_v instanceof UnopExpr) {
            UnopExpr _temp = (UnopExpr)_v;
            this.process(_temp.getOpBox());
        } else {
            super.defaultCase(o);
        }
    }

    @Override
    public FlowInsensitiveExprSwitch<T> getClone(Object ... o) {
        return new FlowInsensitiveExprSwitch<T>(this.connector, this.valueRetriever, (IStmtSwitch)o[0]);
    }

    protected void processInstanceInvokeExpr(InstanceInvokeExpr e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: processing " + e);
        }
        this.fa.processClass(e.getMethod().getDeclaringClass());
        this.process(e.getBaseBox());
        OFAFGNode _receiverNode = (OFAFGNode)this.getFlowNode();
        MethodVariant.setFilterOfBasedOn(_receiverNode, e.getBase().getType(), this.tokenMgr);
        int _i = 0;
        while (_i < e.getArgCount()) {
            this.process(e.getArgBox(_i));
            ++_i;
        }
        InvocationVariant _iv = (InvocationVariant)this.method.getASTVariant((Value)e, this.context);
        if (Util.isReferenceType((Type)e.getType())) {
            OFAFGNode _ast = (OFAFGNode)_iv.getFGNode();
            MethodVariant.setFilterOfBasedOn(_ast, e.getType(), this.tokenMgr);
            this.setFlowNode(_ast);
        } else {
            this.setFlowNode(null);
        }
        InvokeExprWork<T> _work = new InvokeExprWork<T>(this.method, this.context, this.tokenMgr.getNewTokenSet());
        FGAccessNode<T> _baseNode = new FGAccessNode<T>(_work, this.fa, this.tokenMgr);
        MethodVariant.setFilterOfBasedOn(_baseNode, e.getBase().getType(), this.tokenMgr);
        _receiverNode.addSucc(_baseNode);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: processed " + e);
        }
    }

    private StringConstant getCanonicalStringConstant(StringConstant e) {
        if (STR_TO_CONST.containsKey(e.value)) {
            return STR_TO_CONST.get(e.value);
        }
        STR_TO_CONST.put(e.value, e);
        return e;
    }

    private void processInvokedMethod(InvokeExpr e) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: processing " + e);
        }
        IMethodVariant _callee = this.fa.getMethodVariant(e.getMethod(), this.context);
        if (e instanceof SpecialInvokeExpr) {
            SpecialInvokeExpr _expr = (SpecialInvokeExpr)e;
            OFAFGNode _thisNode = (OFAFGNode)_callee.queryThisNode();
            this.process(_expr.getBaseBox());
            OFAFGNode _thisArgNode = (OFAFGNode)this.getFlowNode();
            MethodVariant.setFilterOfBasedOn(_thisArgNode, _expr.getBase().getType(), this.tokenMgr);
            _thisArgNode.addSucc(_thisNode);
        }
        int _i = 0;
        while (_i < e.getArgCount()) {
            if (Util.isReferenceType((Type)e.getArg(_i).getType())) {
                this.process(e.getArgBox(_i));
                OFAFGNode _argNode = (OFAFGNode)this.getFlowNode();
                MethodVariant.setFilterOfBasedOn(_argNode, e.getArg(_i).getType(), this.tokenMgr);
                _argNode.addSucc((OFAFGNode)_callee.queryParameterNode(_i));
            }
            ++_i;
        }
        InvocationVariant _iv = (InvocationVariant)this.method.getASTVariant((Value)e, this.context);
        OFAFGNode _throwNode = (OFAFGNode)_iv.getThrowNode();
        MethodVariant.setFilterOfBasedOn(_throwNode, (Type)this.fa.getClass("java.lang.Throwable").getType(), this.tokenMgr);
        ((OFAFGNode)_callee.queryThrownNode()).addSucc(_throwNode);
        if (Util.isReferenceType((Type)e.getType())) {
            OFAFGNode _ast = (OFAFGNode)_iv.getFGNode();
            MethodVariant.setFilterOfBasedOn(_ast, e.getType(), this.tokenMgr);
            ((OFAFGNode)_callee.queryReturnNode()).addSucc(_ast);
            this.setFlowNode(_ast);
        } else {
            this.setFlowNode(null);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: processed " + e);
        }
    }
}

