/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances.ofa;

import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import soot.RefType;
import soot.SootClass;
import soot.Value;
import soot.ValueBox;
import soot.jimple.NewExpr;
import soot.jimple.StringConstant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AllocationSiteCollectingProcessor
extends AbstractProcessor {
    private Map<SootClass, Collection<Value>> class2allocationSite = new HashMap<SootClass, Collection<Value>>();
    private IEnvironment env;

    public void callback(ValueBox vBox, Context context) {
        Value _v = vBox.getValue();
        if (_v instanceof StringConstant) {
            MapUtils.putIntoCollectionInMap(this.class2allocationSite, (Object)this.env.getClass("java.lang.String"), (Object)_v);
        } else if (_v instanceof NewExpr) {
            MapUtils.putIntoCollectionInMap(this.class2allocationSite, (Object)((RefType)_v.getType()).getSootClass(), (Object)_v);
        }
    }

    public Collection<Value> getAllocationSitesFor(SootClass clazz) {
        if (this.class2allocationSite.containsKey(clazz)) {
            return this.class2allocationSite.get(clazz);
        }
        return Collections.singleton(null);
    }

    public void hookup(ProcessingController ppc) {
        ppc.register(NewExpr.class, (IProcessor)this);
        ppc.register(StringConstant.class, (IProcessor)this);
        this.env = ppc.getEnvironment();
    }

    public void reset() {
        super.reset();
        this.class2allocationSite.clear();
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregister(NewExpr.class, (IProcessor)this);
        ppc.unregister(StringConstant.class, (IProcessor)this);
        this.env = null;
    }
}

