/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow.instances;

import edu.ksu.cis.indus.ErringTestCase;
import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallGraphTest;
import edu.ksu.cis.indus.staticanalyses.callgraphs.XMLBasedCallGraphTest;
import edu.ksu.cis.indus.staticanalyses.flow.FATest;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ValueAnalysisTestSetup;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.XMLBasedOFATest;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public final class ValueAnalysisRegressionTestSuite
extends TestCase {
    public static final String VALUE_ANALYSIS_TEST_PROPERTIES_FILE = "indus.staticanalyses.flow.instances.ValueAnalysisTest.properties.file";

    public static void main(String[] args) {
        String[] _suiteName = new String[]{ValueAnalysisRegressionTestSuite.class.getName()};
        TestRunner.main((String[])_suiteName);
    }

    public static Test suite() {
        TestSuite _suite = new TestSuite("Test for edu.ksu.cis.indus.staticanalyses.flow.instances");
        String _propFileName = System.getProperty(VALUE_ANALYSIS_TEST_PROPERTIES_FILE);
        if (_propFileName == null) {
            throw new RuntimeException("Please provide a property file like ValueAnalysisTest.properties via -Dindus.staticanalyses.flow.instances.ValueAnalysisTest.properties.file");
        }
        ValueAnalysisRegressionTestSuite.setupTests(_propFileName, _suite);
        return _suite;
    }

    private static void setupTests(String propFileName, TestSuite suite) {
        Properties _props = new Properties();
        try {
            _props.load(new FileInputStream(new File(propFileName)));
            String[] _configs = _props.getProperty("configs").split(" ");
            CompleteStmtGraphFactory _stmtGraphFactory = new CompleteStmtGraphFactory();
            int _i = 0;
            while (_i < _configs.length) {
                String _config = _configs[_i];
                String _classNames = _props.getProperty(String.valueOf(_config) + ".classNames");
                String _xmlTestDir = _props.getProperty(String.valueOf(_config) + ".xmlTestDir");
                String _xmlControlDir = _props.getProperty(String.valueOf(_config) + ".xmlControlDir");
                String _jimpleDumpDir = _props.getProperty(String.valueOf(_config) + ".jimpleXMLDumpDir");
                String _classpath = _props.getProperty(String.valueOf(_config) + ".classpath");
                String _str = TestHelper.checkXMLBasedTestExecutability((String)_config, (String)_xmlTestDir, (String)_xmlControlDir);
                try {
                    TestSuite _temp = new TestSuite(_config);
                    if (_str.length() > 0) {
                        _temp.addTest((Test)new ErringTestCase(_str));
                        TestHelper.appendSuiteNameToTestsIn((TestSuite)_temp, (boolean)true);
                        suite.addTest((Test)_temp);
                    } else {
                        _temp.addTestSuite(XMLBasedCallGraphTest.class);
                        _temp.addTestSuite(OFABasedCallGraphTest.class);
                        _temp.addTestSuite(XMLBasedOFATest.class);
                        _temp.addTestSuite(FATest.class);
                        TestHelper.appendSuiteNameToTestsIn((TestSuite)_temp, (boolean)true);
                        ValueAnalysisTestSetup _test = new ValueAnalysisTestSetup(_temp, _classNames, _classpath);
                        _test.setIdGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
                        _test.setJimpleXMLDumpLocation(_jimpleDumpDir);
                        _test.setStmtGraphFactory((IStmtGraphFactory)_stmtGraphFactory);
                        _test.setXMLTestDir(_xmlTestDir);
                        _test.setXMLControlDir(_xmlControlDir);
                        suite.addTest((Test)_test);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                ++_i;
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Specified property file does not exist.");
        }
    }
}

