/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.interfaces.IPrototype;
import edu.ksu.cis.indus.staticanalyses.flow.ASTVariantManager;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractVariantManager;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IIndex;
import edu.ksu.cis.indus.staticanalyses.flow.IIndexManager;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariantFactory;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MethodVariantManager<SYM, T extends ITokens<T, SYM>, N extends IFGNode<SYM, T, N>, R>
extends AbstractVariantManager<IMethodVariant<N>, SootMethod, SYM, T, N, R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodVariantManager.class);
    protected final IPrototype<? extends IIndexManager<? extends IIndex<?>, Value>> astIMPrototype;
    private final IMethodVariantFactory<SYM, T, N, R> mvFactory;

    MethodVariantManager(FA<SYM, T, N, R> theAnalysis, IIndexManager<? extends IIndex<?>, SootMethod> indexManager, IPrototype<? extends IIndexManager<? extends IIndex<?>, Value>> astIndexManagerPrototype, IMethodVariantFactory<SYM, T, N, R> factory) {
        super(theAnalysis, indexManager);
        this.astIMPrototype = astIndexManagerPrototype;
        this.mvFactory = factory;
    }

    @Override
    protected IMethodVariant<N> getNewVariant(SootMethod o) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("STATS: Processing method: " + o + "\t number: " + (this.getVariantCount() + 1));
        }
        ASTVariantManager _astVM = new ASTVariantManager(this.fa, (IIndexManager)this.astIMPrototype.getClone(new Object[0]));
        SootMethod _sootMethod = o;
        return this.mvFactory.create(_sootMethod, _astVM, this.fa);
    }
}

