/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.AbstractXMLBasedTestSetup;
import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.flow.FATest;
import edu.ksu.cis.indus.staticanalyses.flow.IFATest;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.tokens.BitSetTokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.JimpleXMLizerCLI;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestSuite;
import soot.G;
import soot.Type;
import soot.Value;

public class FATestSetup
extends AbstractXMLBasedTestSetup {
    public static final String TAG_NAME = "indus.staticanalyses.flow.FATestSetup:FA";
    protected IValueAnalyzer valueAnalyzer;
    protected final String classNames;
    private final String sootClassPath;

    protected FATestSetup(TestSuite test, String theNameOfClasses, String classpath) {
        super(test);
        this.sootClassPath = classpath;
        this.classNames = theNameOfClasses;
    }

    protected void setUp() throws Exception {
        super.setUp();
        SootBasedDriver _driver = new SootBasedDriver();
        _driver.addToSootClassPath(this.sootClassPath);
        _driver.setClassNames((Collection)Arrays.asList(this.classNames.split(" ")));
        _driver.initialize();
        this.valueAnalyzer = OFAnalyzer.getFSOIAnalyzer(TAG_NAME, new BitSetTokenManager<Value, Type>(new SootValueTypeManager()), _driver.getStmtGraphFactory());
        this.valueAnalyzer.analyze(_driver.getEnvironment(), _driver.getRootMethods());
        Collection _temp1 = TestHelper.getTestCasesReachableFromSuite((TestSuite)((TestSuite)this.getTest()), IFATest.class);
        for (IFATest _test : _temp1) {
            _test.setAnalyzer(this.valueAnalyzer);
            _test.setFATagName(TAG_NAME);
        }
        Collection _temp2 = TestHelper.getTestCasesReachableFromSuite((TestSuite)((TestSuite)this.getTest()), FATest.class);
        for (FATest _test : _temp2) {
            _test.setFA(((OFAnalyzer)this.valueAnalyzer).fa);
        }
        if (this.dumpLocation != null) {
            JimpleXMLizerCLI.writeJimpleAsXML((IEnvironment)_driver.getEnvironment(), (String)this.dumpLocation, null, (IJimpleIDGenerator)this.idGenerator, (IProcessingFilter)new TagBasedProcessingFilter(TAG_NAME));
        }
    }

    protected void tearDown() throws Exception {
        G.reset();
        this.valueAnalyzer.reset();
        this.valueAnalyzer = null;
        this.idGenerator.reset();
        super.tearDown();
    }
}

