/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IFATest;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;

public final class FATest
extends IndusTestCase
implements IFATest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FATest.class);
    private FA fa;
    private String faTagName;

    public void setAnalyzer(IValueAnalyzer valueAnalyzer) {
    }

    public void setFA(FA theFA) {
        this.fa = theFA;
    }

    public void setFATagName(String tagName) {
        this.faTagName = tagName;
    }

    public void testContainment() {
        this.checkContainmentOnTaggedEntity();
        this.checkContainmentOnUnTaggedEntity();
    }

    public void testProcessing() {
        Collection<SootClass> _processedClasses = this.fa.getClasses();
        for (SootClass _sc : this.fa.getScene().getClasses()) {
            if (_sc.hasTag(this.faTagName)) {
                FATest.assertTrue((boolean)_processedClasses.contains(_sc));
                continue;
            }
            FATest.assertFalse((boolean)_processedClasses.contains(_sc));
        }
    }

    protected void setUp() throws Exception {
        if (this.fa == null || this.faTagName == null) {
            throw new IllegalStateException("Please call setFA() and setFATagName() before using this test.");
        }
    }

    protected void tearDown() throws Exception {
        this.fa = null;
        this.faTagName = null;
    }

    private void checkContainmentOnTaggedEntity() {
        for (SootClass _sc : this.fa.getScene().getClasses()) {
            boolean _flag = false;
            if (LOGGER.isDebugEnabled() && _sc.hasTag(this.faTagName)) {
                LOGGER.debug("TAGGED Class: " + _sc);
            }
            for (SootField _sf : _sc.getFields()) {
                if (!_sf.hasTag(this.faTagName)) continue;
                _flag = true;
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("TAGGED Field: " + _sf);
            }
            for (SootMethod _sm : _sc.getMethods()) {
                if (_sm.hasTag(this.faTagName)) {
                    FATest.assertNotNull(this.fa.queryMethodVariant(_sm));
                    _flag = true;
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("TAGGED Method: " + _sm);
                    continue;
                }
                FATest.assertNull(this.fa.queryMethodVariant(_sm));
            }
            if (!_flag) continue;
            FATest.assertTrue((boolean)_sc.hasTag(this.faTagName));
        }
    }

    private void checkContainmentOnUnTaggedEntity() {
        for (SootClass _sc : this.fa.getScene().getClasses()) {
            if (_sc.hasTag(this.faTagName)) continue;
            Iterator _j = _sc.getFields().iterator();
            while (_j.hasNext()) {
                FATest.assertFalse((boolean)((SootField)_j.next()).hasTag(this.faTagName));
            }
            _j = _sc.getMethods().iterator();
            while (_j.hasNext()) {
                FATest.assertFalse((boolean)((SootMethod)_j.next()).hasTag(this.faTagName));
            }
        }
    }
}

