/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.common.collections.CollectionUtils;
import edu.ksu.cis.indus.common.collections.ITransformer;
import edu.ksu.cis.indus.common.collections.InvokeTransformer;
import edu.ksu.cis.indus.common.datastructures.IWork;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.PoolAwareWorkBag;
import edu.ksu.cis.indus.common.datastructures.WorkList;
import edu.ksu.cis.indus.common.soot.NamedTag;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IPrototype;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.Constants;
import edu.ksu.cis.indus.staticanalyses.flow.ClassManager;
import edu.ksu.cis.indus.staticanalyses.flow.IExprSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IIndex;
import edu.ksu.cis.indus.staticanalyses.flow.IIndexManager;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariantFactory;
import edu.ksu.cis.indus.staticanalyses.flow.IStmtSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.IWorkBagProvider;
import edu.ksu.cis.indus.staticanalyses.flow.MethodVariantManager;
import edu.ksu.cis.indus.staticanalyses.flow.ValuedVariant;
import edu.ksu.cis.indus.staticanalyses.flow.ValuedVariantManager;
import edu.ksu.cis.indus.staticanalyses.flow.optimizations.SCCBasedOptimizer;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalyzer;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Modifier;
import soot.RefType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.tagkit.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FA<SYM, T extends ITokens<T, SYM>, N extends IFGNode<SYM, T, N>, R>
implements IEnvironment,
IWorkBagProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FA.class);
    protected final Collection<SootMethod> rootMethods = new HashSet<SootMethod>();
    private final IActivePart.ActivePart activePart = new IActivePart.ActivePart();
    private final IAnalyzer analyzer;
    private ValuedVariantManager<ArrayType, SYM, T, N, R> arrayVariantManager;
    private final ClassManager classManager;
    private IWorkBag<IWork> currWorkBag;
    private IEnvironment environment;
    private ValuedVariantManager<SootField, SYM, T, N, R> instanceFieldVariantManager;
    private IPrototype<? extends IExprSwitch<N>> lhsVisitorPrototype;
    private MethodVariantManager<SYM, T, N, R> methodVariantManager;
    private IPrototype<N> nodePrototype;
    private IPrototype<? extends IExprSwitch<N>> rhsVisitorPrototype;
    private final SCCBasedOptimizer<SYM, T, N> sccBasedOptimizer = new SCCBasedOptimizer();
    private int sccOptimizationInterval;
    private ValuedVariantManager<SootField, SYM, T, N, R> staticFieldVariantManager;
    private IPrototype<? extends IStmtSwitch> stmtVisitorPrototype;
    private NamedTag tag;
    private final ITokenManager<T, SYM, R> tokenManager;
    private final IWorkBag<IWork>[] workBags = new IWorkBag[2];

    FA(IAnalyzer theAnalyzer, String tagName, ITokenManager<T, SYM, R> tokenMgr) {
        this.workBags[0] = new PoolAwareWorkBag((IWorkBag)new LIFOWorkBag());
        this.workBags[1] = new PoolAwareWorkBag((IWorkBag)new LIFOWorkBag());
        this.currWorkBag = this.workBags[0];
        this.analyzer = theAnalyzer;
        this.tag = new NamedTag(tagName);
        this.tokenManager = tokenMgr;
        this.sccOptimizationInterval = Constants.getSCCOptimizationIntervalForFA();
        this.classManager = new ClassManager(this);
    }

    public IActivePart getActivePart() {
        return this.activePart;
    }

    public final IAnalyzer getAnalyzer() {
        return this.analyzer;
    }

    public final ValuedVariant<N> getArrayVariant(ArrayType a) {
        return this.getArrayVariant(a, this.analyzer.getContext());
    }

    public final ValuedVariant<N> getArrayVariant(ArrayType a, Context context) {
        this.processType(a.baseType);
        return (ValuedVariant)this.arrayVariantManager.select(a, context);
    }

    public final SootClass getClass(String className) {
        return this.environment.getClass(className);
    }

    public Collection<SootClass> getClasses() {
        return Collections.unmodifiableCollection(this.classManager.classes);
    }

    public final ValuedVariant<N> getFieldVariant(SootField sf) {
        return this.getFieldVariant(sf, this.analyzer.getContext());
    }

    public final ValuedVariant<N> getFieldVariant(SootField sf, Context context) {
        ValuedVariant _temp = null;
        this.processClass(sf.getDeclaringClass());
        this.processType(sf.getType());
        sf.addTag(this.getTag());
        _temp = Modifier.isStatic((int)sf.getModifiers()) ? (ValuedVariant)this.staticFieldVariantManager.select(sf, context) : (ValuedVariant)this.instanceFieldVariantManager.select(sf, context);
        return _temp;
    }

    public final IExprSwitch<N> getLHSExpr(IStmtSwitch e) {
        return (IExprSwitch)this.lhsVisitorPrototype.getClone(new Object[]{e});
    }

    public final IMethodVariant<N> getMethodVariant(SootMethod sm) {
        return this.getMethodVariant(sm, this.analyzer.getContext());
    }

    public final IMethodVariant<N> getMethodVariant(SootMethod sm, Context context) {
        return (IMethodVariant)this.methodVariantManager.select(sm, context);
    }

    public final N getNewFGNode() {
        return (N)((IFGNode)this.nodePrototype.getClone(new Object[]{this}));
    }

    public final IExprSwitch<N> getRHSExpr(IStmtSwitch e) {
        return (IExprSwitch)this.rhsVisitorPrototype.getClone(new Object[]{e});
    }

    public Collection<SootMethod> getRoots() {
        return Collections.unmodifiableCollection(this.rootMethods);
    }

    public final int getSccOptimizationInterval() {
        return this.sccOptimizationInterval;
    }

    public final IEnvironment getScene() {
        return this.environment;
    }

    public final IStmtSwitch getStmt(IMethodVariant<N> e) {
        return (IStmtSwitch)this.stmtVisitorPrototype.getClone(new Object[]{e});
    }

    public final ITokenManager<T, SYM, R> getTokenManager() {
        return this.tokenManager;
    }

    @Override
    public final IWorkBag<IWork> getWorkBag() {
        return this.currWorkBag;
    }

    public boolean hasClass(String scName) {
        return this.environment.hasClass(scName);
    }

    public void processClass(SootClass clazz) {
        this.classManager.process(clazz);
    }

    public void removeClass(SootClass clazz) {
        this.environment.removeClass(clazz);
    }

    public void reset() {
        this.arrayVariantManager.reset();
        this.instanceFieldVariantManager.reset();
        this.methodVariantManager.reset();
        this.staticFieldVariantManager.reset();
        this.workBags[0].clear();
        this.workBags[1].clear();
        this.rootMethods.clear();
        this.classManager.reset();
        this.sccBasedOptimizer.reset();
        this.environment = null;
        this.activePart.activate();
        this.currWorkBag = this.workBags[0];
    }

    public final void setLhsVisitorPrototype(IPrototype<? extends IExprSwitch<N>> prototype) {
        this.lhsVisitorPrototype = prototype;
    }

    public void setNodePrototype(N node) {
        this.nodePrototype = node;
    }

    public final void setRhsVisitorPrototype(IPrototype<? extends IExprSwitch<N>> prototype) {
        this.rhsVisitorPrototype = prototype;
    }

    public final void setSccOptimizationInterval(int interval) {
        this.sccOptimizationInterval = interval;
    }

    public final void setStmtVisitorPrototype(IPrototype<? extends IStmtSwitch> prototype) {
        this.stmtVisitorPrototype = prototype;
    }

    public void setupArrayVariantManager(IIndexManager<? extends IIndex<?>, ArrayType> arrayIM) {
        this.arrayVariantManager = new ValuedVariantManager(this, arrayIM);
    }

    public void setupInstanceFieldVariantManager(IIndexManager<? extends IIndex<?>, SootField> instancefieldIM) {
        this.instanceFieldVariantManager = new ValuedVariantManager(this, instancefieldIM);
    }

    public void setupMethodVariantManager(IIndexManager<? extends IIndex<?>, SootMethod> mi, IPrototype<? extends IIndexManager<? extends IIndex<?>, Value>> astIMPrototype, IMethodVariantFactory<SYM, T, N, R> mvf) {
        this.methodVariantManager = new MethodVariantManager<SYM, T, N, R>(this, mi, astIMPrototype, mvf);
    }

    public void setupStaticFieldVariantManager(IIndexManager<? extends IIndex<?>, SootField> staticfieldIM) {
        this.staticFieldVariantManager = new ValuedVariantManager(this, staticfieldIM);
    }

    void analyze(IEnvironment env, SootMethod root) {
        this.environment = env;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting system processing...");
        }
        this.getMethodVariant(root);
        this.rootMethods.add(root);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Starting worklist processing...");
        }
        long _count = 0L;
        int _bagToggleCounter = 0;
        WorkList[] _workLists = new WorkList[]{new WorkList(this.workBags[0]), new WorkList(this.workBags[1])};
        while ((this.workBags[0].hasWork() || this.workBags[1].hasWork()) && this.activePart.canProceed()) {
            int _bagToProcess = _bagToggleCounter % 2;
            int _bagToCollect = ++_bagToggleCounter % 2;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing work pieces in workbag " + _bagToProcess);
            }
            this.currWorkBag = this.workBags[_bagToCollect];
            _count += (long)_workLists[_bagToProcess].process();
            if (this.sccOptimizationInterval <= 0 || ++_count <= (long)this.sccOptimizationInterval) continue;
            this.collapseSCCOfNodes();
            _count = 0L;
        }
    }

    Tag getTag() {
        return this.tag;
    }

    void processType(Type type) {
        if (type instanceof RefType) {
            this.classManager.process(this.getClass(((RefType)type).getClassName()));
        } else if (type instanceof ArrayType && ((ArrayType)type).baseType instanceof RefType) {
            this.classManager.process(this.getClass(((RefType)((ArrayType)type).baseType).getClassName()));
        }
    }

    final ValuedVariant<N> queryArrayVariant(ArrayType a) {
        return this.queryArrayVariant(a, this.analyzer.getContext());
    }

    final ValuedVariant<N> queryArrayVariant(ArrayType a, Context context) {
        return (ValuedVariant)this.arrayVariantManager.query(a, context);
    }

    final ValuedVariant<N> queryFieldVariant(SootField sf) {
        return this.queryFieldVariant(sf, this.analyzer.getContext());
    }

    final ValuedVariant<N> queryFieldVariant(SootField sf, Context context) {
        ValuedVariant _temp = null;
        _temp = Modifier.isStatic((int)sf.getModifiers()) ? (ValuedVariant)this.staticFieldVariantManager.query(sf, context) : (ValuedVariant)this.instanceFieldVariantManager.query(sf, context);
        return _temp;
    }

    final IMethodVariant<N> queryMethodVariant(SootMethod sm) {
        return this.queryMethodVariant(sm, this.analyzer.getContext());
    }

    final IMethodVariant<N> queryMethodVariant(SootMethod sm, Context context) {
        return (IMethodVariant)this.methodVariantManager.query(sm, context);
    }

    private void collapseSCCOfNodes() {
        HashSet<N> _rootNodes = new HashSet<N>();
        InvokeTransformer _transformer = new InvokeTransformer("getFGNode");
        CollectionUtils.transform(this.instanceFieldVariantManager.getVariants(), (ITransformer)_transformer, _rootNodes);
        CollectionUtils.transform(this.staticFieldVariantManager.getVariants(), (ITransformer)_transformer, _rootNodes);
        _rootNodes.addAll(this.getVariantsAtMethodInterfaces());
        this.sccBasedOptimizer.optimize(_rootNodes, this.tokenManager);
    }

    private Collection<N> getVariantsAtMethodInterfaces() {
        HashSet _result = new HashSet();
        Iterator _i = this.methodVariantManager.getVariants().iterator();
        int _iEnd = this.methodVariantManager.getVariants().size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            IMethodVariant _mv = (IMethodVariant)_i.next();
            _result.add(_mv.queryReturnNode());
            _result.add(_mv.queryThisNode());
            int _j = _mv.getMethod().getParameterCount() - 1;
            while (_j >= 0) {
                _result.add(_mv.queryParameterNode(_j));
                --_j;
            }
            ++_iIndex;
        }
        _result.remove(null);
        return _result;
    }
}

