/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.tagkit.Tag;

public class ClassManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassManager.class);
    final Collection<SootClass> classes = new HashSet<SootClass>();
    private final Context context;
    private final FA fa;

    ClassManager(FA theAnalysis) {
        this.fa = theAnalysis;
        this.context = new Context();
    }

    protected void process(SootClass sc) {
        if (!this.classes.contains(sc)) {
            Tag _theTag = this.fa.getTag();
            this.classes.add(sc);
            sc.addTag(_theTag);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("considered " + sc.getName());
            }
            this.includeClassInitializer(sc);
            HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(this.classes);
            HashSet<SootClass> _temp = new HashSet<SootClass>();
            if (Util.hasSuperclass((SootClass)sc)) {
                _temp.add(sc.getSuperclass());
            }
            _temp.addAll((Collection<SootClass>)sc.getInterfaces());
            _wb.addAllWorkNoDuplicates(_temp);
            while (_wb.hasWork()) {
                SootClass _sc = (SootClass)_wb.getWork();
                _sc.addTag(_theTag);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("considered " + _sc.getName());
                }
                this.includeClassInitializer(_sc);
                _temp.clear();
                if (Util.hasSuperclass((SootClass)_sc)) {
                    _temp.add(_sc.getSuperclass());
                }
                _temp.addAll((Collection<SootClass>)_sc.getInterfaces());
                _wb.addAllWorkNoDuplicates(_temp);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("STATS: # of classes processed is " + this.classes.size());
            }
        }
    }

    protected void reset() {
        this.classes.clear();
    }

    private void includeClassInitializer(SootClass sc) {
        if (sc.declaresMethodByName("<clinit>")) {
            SootMethod _method = sc.getMethodByName("<clinit>");
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("considered " + _method);
            }
            this.fa.getMethodVariant(_method, this.context);
        }
    }
}

