/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IIndex;
import edu.ksu.cis.indus.staticanalyses.flow.IIndexManager;
import edu.ksu.cis.indus.staticanalyses.flow.IVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IVariantManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractVariantManager<V extends IVariant, E, SYM, T extends ITokens<T, SYM>, N extends IFGNode<SYM, T, N>, R>
implements IVariantManager<V, E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractVariantManager.class);
    protected final FA<SYM, T, N, R> fa;
    private final IIndexManager<? extends IIndex<?>, E> idxManager;
    private final Map<IIndex<?>, V> index2variant = new HashMap();

    AbstractVariantManager(FA<SYM, T, N, R> theAnalysis, IIndexManager<? extends IIndex<?>, E> indexManager) {
        this.fa = theAnalysis;
        this.idxManager = indexManager;
    }

    @Override
    public final V query(E o, Context context) {
        return (V)((IVariant)this.index2variant.get(this.idxManager.getIndex(o, context)));
    }

    @Override
    public void reset() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("IVariant manager being reset.");
        }
        this.index2variant.clear();
        this.idxManager.reset();
    }

    @Override
    public final V select(E o, Context context) {
        IIndex<?> _index = this.idxManager.getIndex(o, context);
        IVariant _temp = null;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Entering - IIndex: " + _index + "\n" + o + "\n" + context);
        }
        if (this.index2variant.containsKey(_index)) {
            _temp = (IVariant)this.index2variant.get(_index);
        } else if (!this.fa.getAnalyzer().isStable()) {
            _temp = this.getNewVariant(o);
            this.index2variant.put(_index, _temp);
            _temp.process();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Exiting - IIndex");
        }
        return (V)_temp;
    }

    protected abstract V getNewVariant(E var1);

    protected int getVariantCount() {
        return this.index2variant.values().size();
    }

    Collection<V> getVariants() {
        return this.index2variant.values();
    }
}

