/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.IExprSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IStmtSwitch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Type;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.RetStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStmtSwitch<S extends AbstractStmtSwitch<S, N>, N extends IFGNode<?, ?, N>>
extends soot.jimple.AbstractStmtSwitch
implements IStmtSwitch {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStmtSwitch.class);
    protected final Context context;
    protected final IExprSwitch<N> lexpr;
    protected final IMethodVariant<N> method;
    protected final IExprSwitch<N> rexpr;

    protected AbstractStmtSwitch(IMethodVariant<N> m) {
        this.method = m;
        if (m != null) {
            this.context = m.getContext();
            this.lexpr = m.getFA().getLHSExpr(this);
            this.rexpr = m.getFA().getRHSExpr(this);
        } else {
            this.context = null;
            this.lexpr = null;
            this.rexpr = null;
        }
    }

    public void caseAssignStmt(AssignStmt stmt) {
        this.processDefinitionStmt((DefinitionStmt)stmt);
    }

    public void caseEnterMonitorStmt(EnterMonitorStmt stmt) {
        this.rexpr.process(stmt.getOpBox());
    }

    public void caseExitMonitorStmt(ExitMonitorStmt stmt) {
        this.rexpr.process(stmt.getOpBox());
    }

    public void caseIdentityStmt(IdentityStmt stmt) {
        this.processDefinitionStmt((DefinitionStmt)stmt);
    }

    public void caseIfStmt(IfStmt stmt) {
        this.rexpr.process(stmt.getConditionBox());
    }

    public void caseInvokeStmt(InvokeStmt stmt) {
        this.rexpr.process(stmt.getInvokeExprBox());
    }

    public void caseLookupSwitchStmt(LookupSwitchStmt stmt) {
        this.rexpr.process(stmt.getKeyBox());
    }

    public void caseRetStmt(RetStmt stmt) {
        this.rexpr.process(stmt.getStmtAddressBox());
    }

    public void caseReturnStmt(ReturnStmt stmt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: processing " + stmt);
        }
        if (Util.isReferenceType((Type)stmt.getOp().getType())) {
            this.rexpr.process(stmt.getOpBox());
            N _retNode = this.rexpr.getFlowNode();
            _retNode.addSucc(this.method.queryReturnNode());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: processed " + stmt);
        }
    }

    public void caseTableSwitchStmt(TableSwitchStmt stmt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing statement: " + stmt);
        }
        this.rexpr.process(stmt.getKeyBox());
    }

    public void caseThrowStmt(ThrowStmt stmt) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processing statement: " + stmt);
        }
        this.rexpr.process(stmt.getOpBox());
    }

    public void defaultCase(Object o) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(o + " is not handled.");
        }
    }

    public S getClone(Object ... o) {
        throw new UnsupportedOperationException("prototype(Object) is not supported.");
    }

    @Override
    public void process(Stmt stmtToProcess) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: processing " + stmtToProcess);
        }
        Stmt _temp = this.context.setStmt(stmtToProcess);
        stmtToProcess.apply((Switch)this);
        this.context.setStmt(_temp);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: processed " + stmtToProcess);
        }
    }

    protected abstract void processDefinitionStmt(DefinitionStmt var1);
}

