/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IStmtSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.IVariantManager;
import edu.ksu.cis.indus.staticanalyses.flow.InvocationVariant;
import edu.ksu.cis.indus.staticanalyses.flow.ValuedVariant;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.JimpleBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMethodVariant<SYM, T extends ITokens<T, SYM>, N extends IFGNode<SYM, T, N>, R>
implements IMethodVariant<N> {
    protected final FA<SYM, T, N, R> fa;
    protected final N returnVar;
    protected final N thisVar;
    protected final N thrownNode;
    protected final IStmtSwitch stmt;
    protected final IVariantManager<ValuedVariant<N>, Value> astvm;
    protected final SootMethod method;
    protected final List<N> parameters;
    private final Context context;

    protected AbstractMethodVariant(SootMethod sm, IVariantManager<ValuedVariant<N>, Value> astVariantManager, FA<SYM, T, N, R> theFA) {
        this.method = sm;
        this.astvm = astVariantManager;
        this.fa = theFA;
        this.context = this.fa.getAnalyzer().getContext().clone();
        this.context.callNewMethod(sm);
        this.fa.processClass(sm.getDeclaringClass());
        sm.addTag(this.fa.getTag());
        HashSet<Object> _typesToProcess = new HashSet<Object>();
        RefType _sootType = sm.getDeclaringClass().getType();
        if (!sm.isStatic() && this.shouldConsider((Type)_sootType)) {
            this.thisVar = this.fa.getNewFGNode();
            _typesToProcess.add(_sootType);
        } else {
            this.thisVar = null;
        }
        int _pCount = sm.getParameterCount();
        this.parameters = new ArrayList<N>(_pCount);
        int _i = 0;
        while (_i < _pCount) {
            if (this.shouldConsider(sm.getParameterType(_i))) {
                this.parameters.add(this.fa.getNewFGNode());
                _typesToProcess.add(sm.getParameterType(_i));
            } else {
                this.parameters.add(null);
            }
            ++_i;
        }
        if (this.shouldConsider(sm.getReturnType())) {
            this.returnVar = this.fa.getNewFGNode();
            _typesToProcess.add(sm.getReturnType());
        } else {
            this.returnVar = null;
        }
        this.thrownNode = this.fa.getNewFGNode();
        this.stmt = this.fa.getStmt(this);
        if (this.method.isConcrete()) {
            JimpleBody _jb = (JimpleBody)this.method.retrieveActiveBody();
            Iterator _i2 = _jb.getLocals().iterator();
            while (_i2.hasNext()) {
                Type _localType = ((Local)_i2.next()).getType();
                if (!this.shouldConsider(_localType)) continue;
                this.fa.processType(_localType);
            }
        }
        Iterator _i2 = _typesToProcess.iterator();
        while (_i2.hasNext()) {
            this.fa.processType((Type)_i2.next());
        }
    }

    @Override
    public final N getASTNode(Value v, Context c) {
        return this.getASTVariant(v, c).getFGNode();
    }

    @Override
    public final ValuedVariant<N> getASTVariant(Value v, Context ctxt) {
        return this.astvm.select(v, ctxt);
    }

    @Override
    public final Context getContext() {
        return this.context;
    }

    @Override
    public final FA<?, ?, N, ?> getFA() {
        return this.fa;
    }

    @Override
    public final SootMethod getMethod() {
        return this.method;
    }

    @Override
    public final N queryASTNode(Value v, Context c) {
        ValuedVariant<N> _var = this.queryASTVariant(v, c);
        N _temp = null;
        if (_var != null) {
            _temp = _var.getFGNode();
        }
        return _temp;
    }

    @Override
    public final ValuedVariant<N> queryASTVariant(Value v, Context c) {
        return this.astvm.query(v, c);
    }

    @Override
    public final N queryParameterNode(int index) {
        IFGNode _temp = null;
        if (index >= 0 && index <= this.method.getParameterCount()) {
            _temp = (IFGNode)this.parameters.get(index);
        }
        return (N)_temp;
    }

    @Override
    public final N queryReturnNode() {
        return this.returnVar;
    }

    @Override
    public final N queryThisNode() {
        return this.thisVar;
    }

    @Override
    public final N queryThrowNode(InvokeExpr e, Context c) {
        InvocationVariant _var = (InvocationVariant)this.queryASTVariant((Value)e, c);
        N _temp = null;
        if (_var != null) {
            _temp = _var.getThrowNode();
        }
        return _temp;
    }

    @Override
    public final N queryThrownNode() {
        return this.thrownNode;
    }

    protected abstract boolean shouldConsider(Type var1);
}

