/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.annotations.InternalUse;
import edu.ksu.cis.indus.common.datastructures.IWork;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.graph.SCCRelatedData;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IWorkBagProvider;
import edu.ksu.cis.indus.staticanalyses.flow.SendTokensWork;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenFilter;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@InternalUse
public abstract class AbstractFGNode<SYM, T extends ITokens<T, SYM>, N extends AbstractFGNode<SYM, T, N>>
implements IFGNode<SYM, T, N> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFGNode.class);
    protected final IWorkBagProvider workbagProvider;
    private ITokenFilter<T, SYM> filter;
    private boolean inSCCWithMultipleNodes;
    private SCCRelatedData sccData;
    private SendTokensWork<SYM, T, N> sendTokensWork;
    private Collection<N> succs = new HashSet<N>();
    private T tokens;

    protected AbstractFGNode(IWorkBagProvider provider, T tokenSet) {
        this.workbagProvider = provider;
        this.tokens = tokenSet;
    }

    @Override
    public void absorbTokensLazily(T tokensToBeInjected) {
        boolean _tokensWillBeAbsorbed;
        T _diff = tokensToBeInjected.diffTokens(this.tokens);
        boolean bl = _tokensWillBeAbsorbed = !_diff.isEmpty();
        if (_tokensWillBeAbsorbed) {
            IWorkBag<IWork> _workBag = this.workbagProvider.getWorkBag();
            if (this.sendTokensWork == null) {
                this.sendTokensWork = new SendTokensWork(this, _diff);
                _workBag.addWork(this.sendTokensWork);
            } else {
                this.sendTokensWork.addTokens(_diff);
                _workBag.addWorkNoDuplicates(this.sendTokensWork);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Values: " + _diff.getValues() + "\n into " + this);
            }
        }
    }

    @Override
    public void addSucc(N node) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Adding " + node + " as the successor to " + this);
        }
        this.succs.add(node);
        this.onNewSucc(node);
    }

    @Override
    public final SCCRelatedData getSCCRelatedData() {
        if (this.sccData == null) {
            this.sccData = new SCCRelatedData();
        }
        return this.sccData;
    }

    @Override
    public final Collection<N> getSuccs() {
        return this.succs;
    }

    @Override
    public final T getTokens() {
        return this.filterTokens(this.tokens);
    }

    @Override
    public final Collection<SYM> getValues() {
        return this.getTokens().getValues();
    }

    @Override
    public final void injectTokens(T newTokens) {
        boolean _injectedTokens;
        T _diffTokens = this.filterTokens(newTokens.diffTokens(this.tokens));
        boolean bl = _injectedTokens = !_diffTokens.isEmpty();
        if (_injectedTokens) {
            this.tokens.addTokens(_diffTokens);
            this.onNewTokens(_diffTokens);
        }
    }

    @Override
    public final void setFilter(ITokenFilter<T, SYM> filterToUse) {
        this.filter = filterToUse;
    }

    @Override
    public final void setInSCCWithMultipleNodes() {
        this.inSCCWithMultipleNodes = true;
    }

    @Override
    public final void setSCCRelatedData(SCCRelatedData data) {
        this.sccData = data;
    }

    @Override
    public final void setSuccessorSet(Collection<N> successors) {
        this.succs = successors;
    }

    public final void setTokenSendingWork(SendTokensWork<SYM, T, N> work) {
        assert (this.inSCCWithMultipleNodes) : "setInSCCWithMultipleNodes() before calling this method.";
        assert (work != null) : "The argument to this method cannot be null.";
        this.sendTokensWork = work;
    }

    @Override
    public final void setTokenSet(T newTokenSet) {
        this.tokens = newTokenSet;
    }

    public String toString() {
        return "IFGNode:" + this.hashCode();
    }

    protected final T filterTokens(T tokenSet) {
        T _result = this.filter != null ? this.filter.filter(tokenSet) : tokenSet;
        return _result;
    }

    protected void onNewSucc(N succ) {
        ((AbstractFGNode)succ).absorbTokensLazily(this.tokens);
    }

    protected void onNewTokens(T newTokens) {
        if (!this.succs.isEmpty()) {
            T _outTokens = this.filterTokens(newTokens);
            for (AbstractFGNode _succ : this.succs) {
                _succ.absorbTokensLazily(_outTokens);
            }
        }
    }

    void forgetSendTokensWork() {
        if (!this.inSCCWithMultipleNodes) {
            this.sendTokensWork = null;
        }
    }
}

