/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.AbstractStmtSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IExprSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNodeConnector;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IStmtSwitch;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AbstractJimpleValueSwitch;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExprSwitch<E extends AbstractExprSwitch<E, SYM, T, N, R>, SYM, T extends ITokens<T, SYM>, N extends IFGNode<SYM, T, N>, R>
extends AbstractJimpleValueSwitch
implements IExprSwitch<N> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractExprSwitch.class);
    protected final IFGNodeConnector<N> connector;
    protected final Context context;
    protected final FA<SYM, T, N, R> fa;
    protected final IMethodVariant<N> method;
    protected final IStmtSwitch stmtSwitch;
    private N resultFlowNode;

    protected AbstractExprSwitch(IStmtSwitch stmtVisitor, IFGNodeConnector<N> connectorToUse) {
        this.stmtSwitch = stmtVisitor;
        this.connector = connectorToUse;
        if (this.stmtSwitch != null) {
            this.context = ((AbstractStmtSwitch)this.stmtSwitch).context;
            this.method = ((AbstractStmtSwitch)this.stmtSwitch).method;
            this.fa = ((AbstractStmtSwitch)this.stmtSwitch).method.getFA();
        } else {
            this.context = null;
            this.method = null;
            this.fa = null;
        }
    }

    public void defaultCase(Object o) {
        this.setResult(this.method.getASTNode((Value)o, this.context));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(o + "(" + o.getClass() + ") is not handled.");
        }
    }

    public E getClone(Object ... o) {
        throw new UnsupportedOperationException("Parameterless prototype method is not supported.");
    }

    @Override
    public N getFlowNode() {
        return this.resultFlowNode;
    }

    @Override
    public void process(ValueBox v) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Started to process expression: " + v.getValue());
        }
        ValueBox _temp = this.context.setProgramPoint(v);
        v.getValue().apply((Switch)this);
        this.context.setProgramPoint(_temp);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Finished processing expression: " + v.getValue() + "\n" + this.getResult());
        }
    }

    @Override
    public void setFlowNode(N node) {
        this.resultFlowNode = node;
    }
}

