/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.flow;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.interfaces.AbstractStatus;
import edu.ksu.cis.indus.interfaces.IActivePart;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.staticanalyses.flow.FA;
import edu.ksu.cis.indus.staticanalyses.flow.IExprSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.IFGNode;
import edu.ksu.cis.indus.staticanalyses.flow.IMethodVariant;
import edu.ksu.cis.indus.staticanalyses.flow.IStmtSwitch;
import edu.ksu.cis.indus.staticanalyses.flow.InvocationVariant;
import edu.ksu.cis.indus.staticanalyses.flow.ValuedVariant;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokenManager;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnalyzer<SYM, T extends ITokens<T, SYM>, N extends IFGNode<SYM, T, N>, LE extends IExprSwitch<N>, RE extends IExprSwitch<N>, SS extends IStmtSwitch, R>
extends AbstractStatus
implements IValueAnalyzer<SYM> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAnalyzer.class);
    protected Context context;
    protected FA<SYM, T, N, R> fa;

    protected AbstractAnalyzer(Context theContext, String tagName, ITokenManager<T, SYM, R> tokenMgr) {
        this.context = theContext;
        this.fa = new FA(this, tagName, tokenMgr);
    }

    @Override
    public final void analyze(IEnvironment env, Collection<SootMethod> roots) {
        if (roots == null || roots.isEmpty()) {
            throw new IllegalStateException("There must be at least one root method to analyze.");
        }
        this.unstable();
        for (SootMethod _root : roots) {
            this.fa.analyze(env, _root);
        }
        this.stable();
    }

    @Override
    public final void analyze(IEnvironment env, SootMethod root) {
        if (root == null) {
            throw new IllegalStateException("Root method cannot be null.");
        }
        this.unstable();
        this.fa.analyze(env, root);
        this.stable();
    }

    @Override
    public IActivePart getActivePart() {
        return this.fa.getActivePart();
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public IEnvironment getEnvironment() {
        return this.fa;
    }

    @Override
    public final Collection<SYM> getThrownValues(InvokeExpr e, Context ctxt) {
        InvocationVariant _iv;
        Context _tmpCtxt = this.context;
        this.context = ctxt;
        IMethodVariant<N> _mv = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection _temp = Collections.emptySet();
        if (_mv != null && (_iv = (InvocationVariant)_mv.getASTVariant((Value)e, this.context)) != null) {
            _temp = _iv.getThrowNode().getValues();
        }
        this.context = _tmpCtxt;
        return _temp;
    }

    @Override
    public Collection<SYM> getThrownValues(SootMethod method, Context ctxt) {
        N _tv;
        Context _tmpCtxt = this.context;
        this.context = ctxt;
        IMethodVariant<N> _mv = this.fa.queryMethodVariant(method);
        Collection _temp = Collections.emptySet();
        if (_mv != null && (_tv = _mv.queryThrownNode()) != null) {
            _temp = _tv.getValues();
        }
        this.context = _tmpCtxt;
        return _temp;
    }

    @Override
    public final Collection<SYM> getValues(Value astChunk, Context ctxt) {
        Context _tmpCtxt = this.context;
        this.context = ctxt;
        Collection<SYM> _result = Collections.emptySet();
        _result = astChunk instanceof ParameterRef ? this.getValues((ParameterRef)astChunk) : this.getValues(astChunk);
        this.context = _tmpCtxt;
        return _result;
    }

    @Override
    public final Collection<SYM> getValuesForParameter(int paramIndex, Context ctxt) {
        N _queryParameterNode;
        Context _tmpCtxt = this.context;
        this.context = ctxt;
        IMethodVariant<N> _mv = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection _temp = Collections.emptySet();
        if (_mv != null && (_queryParameterNode = _mv.queryParameterNode(paramIndex)) != null) {
            _temp = _queryParameterNode.getValues();
        }
        this.context = _tmpCtxt;
        return _temp;
    }

    @Override
    public final Collection<SYM> getValuesForThis(Context ctxt) {
        Context _tmpCtxt = this.context;
        this.context = ctxt;
        IMethodVariant<N> _mv = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection _temp = Collections.emptySet();
        if (_mv != null) {
            _temp = _mv.queryThisNode().getValues();
        }
        this.context = _tmpCtxt;
        return _temp;
    }

    @Override
    public final void reset() {
        this.unstable();
        this.resetAnalysis();
        this.fa.reset();
    }

    protected final Collection<SYM> getValues(ArrayType a) {
        ValuedVariant<N> _v = this.fa.queryArrayVariant(a);
        Collection _temp = Collections.emptySet();
        if (_v != null) {
            N _n = _v.getFGNode();
            if (_n != null) {
                _temp = _n.getValues();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Values for array type " + a + " in node " + _n + " are " + _temp);
            }
        }
        return _temp;
    }

    protected final Collection<SYM> getValues(ParameterRef p) {
        IMethodVariant<N> _mv = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection _temp = Collections.emptySet();
        if (_mv != null) {
            int _index = p.getIndex();
            N _queryParameterNode = _mv.queryParameterNode(_index);
            if (_queryParameterNode != null) {
                _temp = _queryParameterNode.getValues();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Values for param " + p + " in node " + _queryParameterNode + " are " + _temp);
            }
        }
        return _temp;
    }

    protected final Collection<SYM> getValues(SootField sf) {
        ValuedVariant<N> _fv = this.fa.queryFieldVariant(sf);
        Collection _temp = Collections.emptySet();
        if (_fv != null) {
            _temp = _fv.getFGNode().getValues();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Values for field  " + sf + " are " + _temp);
            }
        }
        return _temp;
    }

    protected final Collection<SYM> getValues(Value v) {
        ValuedVariant<N> _astv;
        IMethodVariant<N> _mv = this.fa.queryMethodVariant(this.context.getCurrentMethod());
        Collection _temp = Collections.emptySet();
        if (_mv != null && (_astv = _mv.queryASTVariant(v, this.context)) != null) {
            _temp = _astv.getFGNode().getValues();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Values for ast " + v + " in node " + _astv.getFGNode() + " are " + _temp);
            }
        }
        return _temp;
    }

    @Empty
    protected final void resetAnalysis() {
    }
}

