/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.graph.SimpleEdgeGraph;
import edu.ksu.cis.indus.common.graph.SimpleEdgeGraphBuilder;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemDependenceGraphBuilder {
    private static final Object INTER_PROCEDURAL_DATA_DEPENDENCE = "Inter-procedural data dependence";
    private final Collection<SootClass> coreClasses;
    private final Collection<IDependencyAnalysis> deps;
    private final ICallGraphInfo callgraph;
    private final Pair.PairManager pairMgr = new Pair.PairManager(true, true);
    private final SimpleEdgeGraphBuilder<Pair<Stmt, SootMethod>> segb = new SimpleEdgeGraphBuilder();

    private SystemDependenceGraphBuilder(Collection<IDependencyAnalysis> dependences, ICallGraphInfo cgi, Collection<SootClass> classes) {
        this.deps = dependences;
        this.callgraph = cgi;
        this.coreClasses = classes;
    }

    public static SimpleEdgeGraph<Pair<Stmt, SootMethod>> getSystemDependenceGraph(Collection<IDependencyAnalysis> dependences, ICallGraphInfo cgi, Collection<SootClass> classes) {
        SystemDependenceGraphBuilder _builder = new SystemDependenceGraphBuilder(dependences, cgi, classes);
        return _builder.createGraph();
    }

    private void addEdgesFor(Stmt stmt, SootMethod method) {
        Pair _dest = this.pairMgr.getPair((Object)stmt, (Object)method);
        ArrayList<Pair> _sources = new ArrayList<Pair>();
        Iterator<IDependencyAnalysis> _i = this.deps.iterator();
        int _iEnd = this.deps.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            IDependencyAnalysis _da = _i.next();
            Collection<IDependencyAnalysis.DependenceSort> _ids = _da.getIds();
            Collection<Object> _dees = _da instanceof IdentifierBasedDataDA ? ((IdentifierBasedDataDA)_da).getDependees(stmt, method) : (_da instanceof IdentifierBasedDataDAv2 ? ((IdentifierBasedDataDAv2)_da).getDependees(stmt, method) : (_da instanceof ReferenceBasedDataDA || _da instanceof InterferenceDAv1 ? (stmt instanceof AssignStmt ? _da.getDependees(stmt, method) : (Collection)Collections.emptyList()) : _da.getDependees(stmt, method)));
            Iterator<DefinitionStmt> _j = _dees.iterator();
            int _jEnd = _dees.size();
            _sources.clear();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                DefinitionStmt _o = _j.next();
                if (_o instanceof Pair) {
                    _sources.add((Pair)_o);
                } else {
                    _sources.add(this.pairMgr.getPair((Object)((Stmt)_o), (Object)method));
                }
                ++_jIndex;
            }
            if (_ids.contains((Object)IDependencyAnalysis.DependenceSort.SYNCHRONIZATION_DA)) {
                this.segb.addEdgeFromTo(_sources, (Object)IDependencyAnalysis.DependenceSort.SYNCHRONIZATION_DA, (Object)_dest);
            }
            if (_ids.contains((Object)IDependencyAnalysis.DependenceSort.READY_DA)) {
                this.segb.addEdgeFromTo(_sources, (Object)IDependencyAnalysis.DependenceSort.READY_DA, (Object)_dest);
            }
            if (_ids.contains((Object)IDependencyAnalysis.DependenceSort.INTERFERENCE_DA)) {
                this.segb.addEdgeFromTo(_sources, (Object)IDependencyAnalysis.DependenceSort.INTERFERENCE_DA, (Object)_dest);
            }
            if (_ids.contains((Object)IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA)) {
                this.segb.addEdgeFromTo(_sources, (Object)IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA, (Object)_dest);
            }
            if (_ids.contains((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA)) {
                this.segb.addEdgeFromTo(_sources, (Object)IDependencyAnalysis.DependenceSort.CONTROL_DA, (Object)_dest);
            }
            if (_ids.contains((Object)IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA)) {
                this.segb.addEdgeFromTo(_sources, (Object)IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA, (Object)_dest);
            }
            ++_iIndex;
        }
        if (this.callgraph != null) {
            Collection _callers = this.callgraph.getCallers(method);
            Iterator _k = _callers.iterator();
            int _kEnd = _callers.size();
            int _kIndex = 0;
            while (_kIndex < _kEnd) {
                ICallGraphInfo.CallTriple _ctrp = (ICallGraphInfo.CallTriple)_k.next();
                _sources.add(this.pairMgr.getPair((Object)_ctrp.getStmt(), (Object)_ctrp.getMethod()));
                ++_kIndex;
            }
        }
        this.processForInterProceduralEdges((Pair<Stmt, SootMethod>)_dest);
    }

    private SimpleEdgeGraph<Pair<Stmt, SootMethod>> createGraph() {
        this.segb.createGraph();
        Iterator<SootClass> _j = this.coreClasses.iterator();
        int _jEnd = this.coreClasses.size();
        int _jIndex = 0;
        while (_jIndex < _jEnd) {
            SootClass _sc = _j.next();
            List _methods = _sc.getMethods();
            Iterator _k = _methods.iterator();
            int _kEnd = _methods.size();
            int _kIndex = 0;
            while (_kIndex < _kEnd) {
                SootMethod _sm = (SootMethod)_k.next();
                if (_sm.hasActiveBody()) {
                    Iterator _l = _sm.getActiveBody().getUnits().iterator();
                    int _lEnd = _sm.getActiveBody().getUnits().size();
                    int _lIndex = 0;
                    while (_lIndex < _lEnd) {
                        Stmt _stmt = (Stmt)_l.next();
                        this.addEdgesFor(_stmt, _sm);
                        ++_lIndex;
                    }
                }
                ++_kIndex;
            }
            ++_jIndex;
        }
        this.segb.finishBuilding();
        return (SimpleEdgeGraph)this.segb.getBuiltGraph();
    }

    private void processForInterProceduralEdges(Pair<Stmt, SootMethod> node) {
        block4: {
            IdentityStmt _s;
            SootMethod _sm;
            Stmt _stmt;
            block3: {
                _stmt = (Stmt)node.getFirst();
                _sm = (SootMethod)node.getSecond();
                if (!(_stmt instanceof ReturnStmt)) break block3;
                Iterator _i = this.callgraph.getCallers(_sm).iterator();
                int _iEnd = this.callgraph.getCallers(_sm).size();
                int _iIndex = 0;
                while (_iIndex < _iEnd) {
                    ICallGraphInfo.CallTriple _ctrp = (ICallGraphInfo.CallTriple)_i.next();
                    Stmt _dest = _ctrp.getStmt();
                    if (_dest instanceof AssignStmt) {
                        this.segb.addEdgeFromTo(node, INTER_PROCEDURAL_DATA_DEPENDENCE, (Object)this.pairMgr.getPair((Object)_dest, (Object)_ctrp.getMethod()));
                    }
                    ++_iIndex;
                }
                break block4;
            }
            if (!(_stmt instanceof IdentityStmt) || !((_s = (IdentityStmt)_stmt).getRightOp() instanceof ParameterRef)) break block4;
            Iterator _i = this.callgraph.getCallers(_sm).iterator();
            int _iEnd = this.callgraph.getCallers(_sm).size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                ICallGraphInfo.CallTriple _ctrp = (ICallGraphInfo.CallTriple)_i.next();
                this.segb.addEdgeFromTo((Object)this.pairMgr.getPair((Object)_ctrp.getStmt(), (Object)_ctrp.getMethod()), INTER_PROCEDURAL_DATA_DEPENDENCE, node);
                ++_iIndex;
            }
        }
    }
}

