/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SynchronizationDA
extends AbstractDependencyAnalysis<Stmt, SootMethod, MonitorStmt, SootMethod, Map<Stmt, Collection<MonitorStmt>>, MonitorStmt, SootMethod, Stmt, SootMethod, Map<MonitorStmt, Collection<Stmt>>> {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(SynchronizationDA.class);
    static final Logger LOGGER = LoggerFactory.getLogger(SynchronizationDA.class);
    private IMonitorInfo<?> monitorInfo;

    public SynchronizationDA() {
        super(IDependencyAnalysis.Direction.BI_DIRECTIONAL);
    }

    @Override
    public void analyze() {
        this.unstable();
        if (this.monitorInfo.isStable()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("BEGIN: Synchronization Dependence processing");
            }
            this.stable();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("analyze() - " + this.toString());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("END: Synchronization Dependence processing");
            }
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Monitor Info is unstable. So, passing up .");
        }
    }

    @Override
    public Collection<MonitorStmt> getDependees(Stmt dependentStmt, SootMethod method) {
        Map _temp = MapUtils.getMapFromMap((Map)this.dependent2dependee, (Object)method);
        HashSet<Object> _result = (HashSet<Object>)_temp.get(dependentStmt);
        if (_result == null) {
            _result = new HashSet<Object>(this.monitorInfo.getEnclosingMonitorStmts(dependentStmt, method, false));
            if (dependentStmt instanceof MonitorStmt) {
                Collection _monitorTriples = this.monitorInfo.getMonitorTriplesFor((MonitorStmt)dependentStmt, method);
                for (Triple _triple : _monitorTriples) {
                    EnterMonitorStmt _enter = (EnterMonitorStmt)_triple.getFirst();
                    ExitMonitorStmt _exit = (ExitMonitorStmt)_triple.getSecond();
                    if (!_enter.equals(dependentStmt) && !_exit.equals(dependentStmt)) continue;
                    _result.add(_enter);
                    _result.add(_exit);
                }
            }
            _temp.put(dependentStmt, _result);
        }
        return _result;
    }

    @Override
    public Collection<Stmt> getDependents(MonitorStmt dependeeStmt, SootMethod method) {
        Map _temp = MapUtils.getMapFromMap((Map)this.dependee2dependent, (Object)method);
        HashSet<Object> _result = (HashSet<Object>)_temp.get(dependeeStmt);
        if (_result == null) {
            Collection _monitors = this.monitorInfo.getMonitorTriplesFor(dependeeStmt, method);
            _result = new HashSet<Object>();
            Iterator _i = _monitors.iterator();
            int _iEnd = _monitors.size();
            int _iIndex = 0;
            while (_iIndex < _iEnd) {
                Triple _monitor = (Triple)_i.next();
                EnterMonitorStmt _enter = (EnterMonitorStmt)_monitor.getFirst();
                ExitMonitorStmt _exit = (ExitMonitorStmt)_monitor.getSecond();
                if (dependeeStmt.equals(_enter) || dependeeStmt.equals(_exit)) {
                    Collection _enclosedStmts = this.monitorInfo.getEnclosedStmts(_monitor, false);
                    _result.addAll(_enclosedStmts);
                    _result.add(_enter);
                    _result.add(_exit);
                }
                ++_iIndex;
            }
            _temp.put(dependeeStmt, _result);
        }
        return _result;
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.SYNCHRONIZATION_DA);
    }

    @Override
    public void reset() {
        super.reset();
    }

    public String toString() {
        return "The Statistics for Synchronization dependence is given by the monitor analysis used.\n" + this.monitorInfo.toString();
    }

    @Override
    protected IDependenceRetriever<Stmt, SootMethod, MonitorStmt, MonitorStmt, SootMethod, Stmt> getDependenceRetriever() {
        return new AbstractDependenceRetriever<Stmt, SootMethod, MonitorStmt, MonitorStmt, SootMethod, Stmt>(){

            @Override
            public Collection<Pair<MonitorStmt, SootMethod>> convertToConformantDependees(Collection<Stmt> dependents, MonitorStmt base, SootMethod context) {
                HashSet<Pair<MonitorStmt, SootMethod>> _result = new HashSet<Pair<MonitorStmt, SootMethod>>();
                for (Stmt _t2 : dependents) {
                    if (!(_t2 instanceof MonitorStmt)) continue;
                    _result.add((Pair<MonitorStmt, SootMethod>)new Pair((Object)((MonitorStmt)_t2), (Object)context));
                }
                return _result;
            }

            @Override
            public Collection<Pair<Stmt, SootMethod>> convertToConformantDependents(Collection<MonitorStmt> dependees, Stmt base, SootMethod context) {
                HashSet<Pair<Stmt, SootMethod>> _result = new HashSet<Pair<Stmt, SootMethod>>();
                for (Stmt stmt : dependees) {
                    _result.add((Pair<Stmt, SootMethod>)new Pair((Object)stmt, (Object)context));
                }
                return _result;
            }
        };
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.monitorInfo = (IMonitorInfo)this.info.get(IMonitorInfo.ID);
        if (this.monitorInfo == null) {
            throw new InitializationException(IMonitorInfo.ID + " was not provided in the info.");
        }
    }
}

