/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.SynchronizationDA;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StmtAndMethodBasedDependencyXMLizer<T1 extends Stmt, E2 extends Stmt>
extends AbstractProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(StmtAndMethodBasedDependencyXMLizer.class);
    IDependencyAnalysis<T1, SootMethod, ?, E2, SootMethod, ?> analysis;
    private Handler handler;
    private IJimpleIDGenerator idGenerator;
    private boolean processingClass;
    private boolean processingMethod;
    private int totalDependences;
    private XMLOutputter writer;

    public StmtAndMethodBasedDependencyXMLizer(XMLOutputter out, IJimpleIDGenerator generator, IDependencyAnalysis<T1, SootMethod, ?, E2, SootMethod, ?> depAnalysis) {
        this.writer = out;
        this.idGenerator = generator;
        this.analysis = depAnalysis;
        this.handler = new Handler();
    }

    public void callback(SootClass clazz) {
        block5: {
            try {
                if (this.processingMethod) {
                    this.writer.endTag();
                }
                if (this.processingClass) {
                    this.writer.endTag();
                } else {
                    this.processingClass = true;
                }
                this.writer.startTag("class");
                this.writer.attribute("id", this.idGenerator.getIdForClass(clazz));
                this.processingMethod = false;
            }
            catch (IOException _e) {
                if (!LOGGER.isWarnEnabled()) break block5;
                LOGGER.warn("Error while writing dependency info.", (Throwable)_e);
            }
        }
    }

    public void callback(SootMethod method) {
        block4: {
            try {
                if (this.processingMethod) {
                    this.writer.endTag();
                } else {
                    this.processingMethod = true;
                }
                this.writer.startTag("method");
                this.writer.attribute("id", this.idGenerator.getIdForMethod(method));
            }
            catch (IOException _e) {
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn("Error while writing dependency info.", (Throwable)_e);
            }
        }
    }

    public void callback(Stmt stmt, Context context) {
        block17: {
            SootMethod _method = context.getCurrentMethod();
            try {
                Collection<?> _dependents = this.handler.canHandleDependee(stmt) ? this.analysis.getDependents(this.handler.castToCompatibleDependee(stmt), _method) : (Collection<?>)Collections.emptySet();
                Collection<Object> _dependees = this.handler.canHandleDependent(stmt) ? (this.analysis instanceof IdentifierBasedDataDA ? ((IdentifierBasedDataDA)this.analysis).getDependees(stmt, _method) : (this.analysis instanceof IdentifierBasedDataDAv2 ? ((IdentifierBasedDataDAv2)this.analysis).getDependees(stmt, _method) : this.analysis.getDependees(this.handler.castToCompatibleDependent(stmt), _method))) : (Collection<DefinitionStmt>)Collections.emptySet();
                if (!_dependents.isEmpty() || !_dependees.isEmpty()) {
                    this.writer.startTag("dependency_info");
                    this.writer.attribute("stmtId", this.idGenerator.getIdForStmt(stmt, _method));
                    this.totalDependences += _dependents.size();
                    for (Object obj : _dependents) {
                        String _tid = null;
                        if (obj instanceof Pair) {
                            Pair _pair;
                            Object _first = ((Pair)obj).getFirst();
                            if (_first instanceof Stmt) {
                                _pair = (Pair)obj;
                                _tid = this.idGenerator.getIdForStmt((Stmt)_pair.getFirst(), (SootMethod)_pair.getSecond());
                            } else {
                                _pair = (Pair)obj;
                                _tid = this.idGenerator.getIdForStmt((Stmt)_pair.getSecond(), _method);
                            }
                        } else if (obj instanceof Stmt) {
                            _tid = this.idGenerator.getIdForStmt((Stmt)obj, _method);
                        }
                        if (_tid == null) continue;
                        this.writer.startTag("dependent");
                        this.writer.attribute("tid", _tid);
                        this.writer.endTag();
                    }
                    for (Object object : _dependees) {
                        String _eid = null;
                        if (object instanceof Pair) {
                            Pair _pair = (Pair)object;
                            _eid = this.idGenerator.getIdForStmt((Stmt)_pair.getFirst(), (SootMethod)_pair.getSecond());
                        } else if (object instanceof Stmt) {
                            _eid = this.idGenerator.getIdForStmt((Stmt)object, _method);
                        }
                        if (_eid == null) continue;
                        this.writer.startTag("dependee");
                        this.writer.attribute("eid", _eid);
                        this.writer.endTag();
                    }
                    this.writer.endTag();
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No informtion: " + stmt + " @ " + _method + " -- Dependents = " + _dependents.isEmpty() + " " + "Dependees = " + _dependees.isEmpty() + " " + this.analysis.getIds());
                }
            }
            catch (IOException _e) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Error while writing dependency info.", (Throwable)_e);
                }
            }
            catch (ClassCastException _e) {
                if (!LOGGER.isWarnEnabled()) break block17;
                LOGGER.warn("Error retrieving dependency info for " + stmt + " in the context " + context, (Throwable)_e);
            }
        }
    }

    public void consolidate() {
        block4: {
            try {
                if (this.processingMethod) {
                    this.writer.endTag();
                }
                if (this.processingClass) {
                    this.writer.endTag();
                }
                this.writer.startTag("count");
                this.writer.pcdata(String.valueOf(this.totalDependences));
                this.writer.endDocument();
            }
            catch (IOException _e) {
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn("Error while writing dependency info.", (Throwable)_e);
            }
        }
    }

    public void hookup(ProcessingController ppc) {
        ppc.registerForAllStmts((IProcessor)this);
        ppc.register((IProcessor)this);
    }

    public void processingBegins() {
        block2: {
            try {
                this.writer.declaration();
                this.writer.startTag("dependency");
                ArrayList<IDependencyAnalysis.DependenceSort> _t = new ArrayList<IDependencyAnalysis.DependenceSort>(this.analysis.getIds());
                Collections.sort(_t);
                this.writer.attribute("id", ((Object)_t).toString());
                this.writer.attribute("class", this.analysis.getClass().getName());
            }
            catch (IOException _e) {
                if (!LOGGER.isWarnEnabled()) break block2;
                LOGGER.warn("Error while writing dependency info.", (Throwable)_e);
            }
        }
    }

    public void unhook(ProcessingController ppc) {
        ppc.unregisterForAllStmts((IProcessor)this);
        ppc.unregister((IProcessor)this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Handler {
        Handler() {
        }

        boolean canHandleDependee(Stmt stmt) {
            boolean _result = StmtAndMethodBasedDependencyXMLizer.this.analysis instanceof IdentifierBasedDataDA || StmtAndMethodBasedDependencyXMLizer.this.analysis instanceof IdentifierBasedDataDAv2 ? stmt instanceof DefinitionStmt : (StmtAndMethodBasedDependencyXMLizer.this.analysis instanceof ReferenceBasedDataDA || StmtAndMethodBasedDependencyXMLizer.this.analysis instanceof InterferenceDAv1 ? stmt instanceof AssignStmt : (StmtAndMethodBasedDependencyXMLizer.this.analysis instanceof SynchronizationDA ? stmt instanceof MonitorStmt : true));
            return _result;
        }

        boolean canHandleDependent(Stmt stmt) {
            boolean _result = StmtAndMethodBasedDependencyXMLizer.this.analysis instanceof ReferenceBasedDataDA || StmtAndMethodBasedDependencyXMLizer.this.analysis instanceof InterferenceDAv1 ? stmt instanceof AssignStmt : true;
            return _result;
        }

        E2 castToCompatibleDependee(Stmt stmt) {
            return (Stmt)((Class)((Object)((Object)StmtAndMethodBasedDependencyXMLizer.this)).getClass().getTypeParameters()[1].getBounds()[0]).cast(stmt);
        }

        T1 castToCompatibleDependent(Stmt stmt) {
            return (Stmt)((Class)((Object)((Object)StmtAndMethodBasedDependencyXMLizer.this)).getClass().getTypeParameters()[0].getBounds()[0]).cast(stmt);
        }
    }
}

