/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysisTest;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

class StmtAndMethodBasedDependencyAnalysisTest
extends AbstractDependencyAnalysisTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(StmtAndMethodBasedDependencyAnalysisTest.class);

    StmtAndMethodBasedDependencyAnalysisTest() {
    }

    protected void verifyDAFor(Stmt unit, SootMethod sm) {
        IDependencyAnalysis _da = this.getDA();
        this.verifyDependentPosition(unit, sm, _da);
        this.verifyDependeePosition(unit, sm, _da);
    }

    private void verifyDependeePosition(Stmt dependee, SootMethod method, IDependencyAnalysis dependencyAnalysis) {
        Collection _dependents = dependencyAnalysis.getDependents(dependee, method);
        if (!_dependents.isEmpty()) {
            Object _temp = _dependents.iterator().next();
            Object _dependee = _temp instanceof Pair ? new Pair((Object)dependee, (Object)method) : dependee;
            for (Object _o : _dependents) {
                Stmt _stmt;
                SootMethod _method = method;
                if (_o instanceof Pair) {
                    Pair _pair = (Pair)_o;
                    _stmt = (Stmt)_pair.getFirst();
                    _method = (SootMethod)_pair.getSecond();
                } else if (_o instanceof Stmt) {
                    _stmt = (Stmt)_o;
                } else {
                    LOGGER.error("This class can only handle Pair and Stmt as targets of dependence information.");
                    throw new IllegalStateException("This class can only handle Pair and Stmt as targets of dependence information.");
                }
                StmtAndMethodBasedDependencyAnalysisTest.assertTrue((String)("Dependee:" + this.getDA().getClass().getName() + ": (" + dependee + ", " + method + ") -> (" + _stmt + ", " + _method + ")"), (boolean)dependencyAnalysis.getDependees(_stmt, _method).contains(_dependee));
            }
        }
    }

    private void verifyDependentPosition(Stmt dependent, SootMethod method, IDependencyAnalysis dependencyAnalysis) {
        Collection _dependees = dependencyAnalysis.getDependees(dependent, method);
        if (!_dependees.isEmpty()) {
            Object _temp = _dependees.iterator().next();
            Object _dependent = _temp instanceof Pair ? new Pair((Object)dependent, (Object)method) : dependent;
            for (Object _o : _dependees) {
                Stmt _stmt;
                SootMethod _method = method;
                if (_o instanceof Pair) {
                    Pair _pair = (Pair)_o;
                    _stmt = (Stmt)_pair.getFirst();
                    _method = (SootMethod)_pair.getSecond();
                } else if (_o instanceof Stmt) {
                    _stmt = (Stmt)_o;
                } else {
                    LOGGER.error("This class can only handle Pair and Stmt as targets of dependence information.");
                    throw new IllegalStateException("This class can only handle Pair and Stmt as targets of dependence information.");
                }
                StmtAndMethodBasedDependencyAnalysisTest.assertTrue((String)("Dependent:" + this.getDA().getClass().getName() + ": (" + dependent + ", " + method + ") -> (" + _stmt + ", " + _method + ")"), (boolean)dependencyAnalysis.getDependents(_stmt, _method).contains(_dependent));
            }
        }
    }
}

