/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.PairRetriever;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.AssignStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceBasedDataDA
extends AbstractDependencyAnalysis<AssignStmt, SootMethod, Pair<AssignStmt, SootMethod>, Object, Map<Pair<AssignStmt, SootMethod>, Collection<Pair<AssignStmt, SootMethod>>>, AssignStmt, SootMethod, Pair<AssignStmt, SootMethod>, Object, Map<Pair<AssignStmt, SootMethod>, Collection<Pair<AssignStmt, SootMethod>>>> {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(ReferenceBasedDataDA.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceBasedDataDA.class);
    private IUseDefInfo<Pair<AssignStmt, SootMethod>, Pair<AssignStmt, SootMethod>> aliasedUD;
    private IUseDefInfo<Pair<AssignStmt, SootMethod>, Pair<AssignStmt, SootMethod>> staticFieldRefUD;

    public ReferenceBasedDataDA() {
        super(IDependencyAnalysis.Direction.BI_DIRECTIONAL);
    }

    @Override
    public void analyze() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Reference Based Data Dependence processing");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ReferenceBasedDataDA.analyze() - " + this.toString());
        }
        if (this.aliasedUD.isStable()) {
            this.stable();
        } else {
            this.unstable();
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Reference Based Data Dependence processing");
        }
    }

    @Override
    public Collection<Pair<AssignStmt, SootMethod>> getDependees(AssignStmt stmt, SootMethod method) {
        Collection _result = stmt.containsArrayRef() || stmt.containsFieldRef() ? (this.staticFieldRefUD != null ? (Collection)SetUtils.union((Collection)this.aliasedUD.getDefs((Stmt)stmt, method), (Collection)this.staticFieldRefUD.getDefs((Stmt)stmt, method)) : this.aliasedUD.getDefs((Stmt)stmt, method)) : (Collection)Collections.emptyList();
        return _result;
    }

    @Override
    public Collection<Pair<AssignStmt, SootMethod>> getDependents(AssignStmt stmt, SootMethod method) {
        Collection _result = stmt.containsArrayRef() || stmt.containsFieldRef() ? (this.staticFieldRefUD != null ? (Collection)SetUtils.union((Collection)this.aliasedUD.getUses((DefinitionStmt)stmt, method), (Collection)this.staticFieldRefUD.getUses((DefinitionStmt)stmt, method)) : this.aliasedUD.getUses((DefinitionStmt)stmt, method)) : (Collection)Collections.emptyList();
        return _result;
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.REFERENCE_BASED_DATA_DA);
    }

    public String toString() {
        return this.aliasedUD + "\n" + this.staticFieldRefUD;
    }

    @Override
    protected IDependenceRetriever<AssignStmt, SootMethod, Pair<AssignStmt, SootMethod>, AssignStmt, SootMethod, Pair<AssignStmt, SootMethod>> getDependenceRetriever() {
        return new PairRetriever<AssignStmt, SootMethod, AssignStmt, AssignStmt, SootMethod, AssignStmt>();
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.aliasedUD = (IUseDefInfo)this.info.get(IUseDefInfo.ALIASED_USE_DEF_ID);
        if (this.aliasedUD == null) {
            throw new InitializationException(IUseDefInfo.ALIASED_USE_DEF_ID + " was not provided.");
        }
        this.staticFieldRefUD = (IUseDefInfo)this.info.get(IUseDefInfo.GLOBAL_USE_DEF_ID);
        if (this.staticFieldRefUD == null) {
            LOGGER.info(IUseDefInfo.GLOBAL_USE_DEF_ID + " was not provided.  Hence, static field reference based dependence" + " info will not be provided.");
        }
    }
}

