/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.BackwardDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.ForwardDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.IDirectionSensitiveInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Value;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadyDAv2
extends ReadyDAv1 {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadyDAv2.class);
    protected IEscapeInfo ecba;

    protected ReadyDAv2(IDirectionSensitiveInfo directionSensitiveInfo, IDependencyAnalysis.Direction direction) {
        super(directionSensitiveInfo, direction);
    }

    public static ReadyDAv1 getBackwardReadyDA() {
        return new ReadyDAv2(new BackwardDirectionSensitiveInfo(), IDependencyAnalysis.Direction.BACKWARD_DIRECTION);
    }

    public static ReadyDAv1 getForwardReadyDA() {
        return new ReadyDAv2(new ForwardDirectionSensitiveInfo(), IDependencyAnalysis.Direction.FORWARD_DIRECTION);
    }

    @Override
    public void analyze() {
        this.unstable();
        if (this.ecba.isStable()) {
            super.analyze();
        }
    }

    @Override
    protected boolean ifDependentOnByRule2(Pair<EnterMonitorStmt, SootMethod> enterPair, Pair<ExitMonitorStmt, SootMethod> exitPair) {
        boolean _result = super.ifDependentOnByRule2(enterPair, exitPair);
        if (_result) {
            boolean _flag2;
            boolean _flag1;
            SootMethod _enterMethod = (SootMethod)enterPair.getSecond();
            SootMethod _exitMethod = (SootMethod)exitPair.getSecond();
            EnterMonitorStmt _o1 = (EnterMonitorStmt)enterPair.getFirst();
            ExitMonitorStmt _o2 = (ExitMonitorStmt)exitPair.getFirst();
            if (_o1 == null) {
                _flag1 = this.ecba.thisEscapes(_enterMethod);
            } else {
                Value _enter = _o1.getOp();
                _flag1 = this.ecba.escapes(_enter, _enterMethod);
            }
            if (_o2 == null) {
                _flag2 = this.ecba.thisEscapes(_exitMethod);
            } else {
                Value _exit = _o2.getOp();
                _flag2 = this.ecba.escapes(_exit, _exitMethod);
            }
            _result = _flag1 && _flag2;
        }
        return _result;
    }

    @Override
    protected boolean ifDependentOnByRule4(Pair<InvokeStmt, SootMethod> wPair, Pair<InvokeStmt, SootMethod> nPair) {
        boolean _result = super.ifDependentOnByRule4(wPair, nPair);
        if (_result) {
            Value _notify = ((VirtualInvokeExpr)((InvokeStmt)nPair.getFirst()).getInvokeExpr()).getBase();
            Value _wait = ((VirtualInvokeExpr)((InvokeStmt)wPair.getFirst()).getInvokeExpr()).getBase();
            SootMethod _wMethod = (SootMethod)wPair.getSecond();
            SootMethod _nMethod = (SootMethod)nPair.getSecond();
            _result = this.ecba.escapes(_notify, _nMethod) && this.ecba.escapes(_wait, _wMethod);
        }
        return _result;
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.ecba = (IEscapeInfo)this.info.get(IEscapeInfo.ID);
        if (this.ecba == null) {
            LOGGER.error(IEscapeInfo.ID + " was not provided in info.");
            throw new InitializationException(IEscapeInfo.ID + " was not provided in info.");
        }
    }
}

