/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.datastructures.Triple;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.Util;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.concurrency.SafeLockAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.PairRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.BackwardDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.ForwardDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.IDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.modes.sensitive.allocation.AllocationContext;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.MonitorStmt;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadyDAv1
extends AbstractDependencyAnalysis<Stmt, SootMethod, Pair<Stmt, SootMethod>, SootMethod, Map<Stmt, Collection<Pair<Stmt, SootMethod>>>, Stmt, SootMethod, Pair<Stmt, SootMethod>, SootMethod, Map<Stmt, Collection<Pair<Stmt, SootMethod>>>> {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(ReadyDAv1.class);
    public static final int RULE_1 = 1;
    public static final int RULE_2 = 2;
    public static final int RULE_3 = 4;
    public static final int RULE_4 = 8;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadyDAv1.class);
    protected int rules = 15;
    final Map<SootMethod, Collection<EnterMonitorStmt>> enterMonitors = new HashMap<SootMethod, Collection<EnterMonitorStmt>>();
    final Map<SootMethod, Collection<ExitMonitorStmt>> exitMonitors = new HashMap<SootMethod, Collection<ExitMonitorStmt>>();
    final Map<SootMethod, Collection<InvokeStmt>> notifies = new HashMap<SootMethod, Collection<InvokeStmt>>();
    final Collection<SootMethod> readyMethods = new HashSet<SootMethod>();
    final Map<SootMethod, Collection<InvokeStmt>> waits = new HashMap<SootMethod, Collection<InvokeStmt>>();
    private ICallGraphInfo callgraph;
    private boolean considerCallSites;
    private final IDirectionSensitiveInfo directionSensInfo;
    private IEnvironment env;
    private IMonitorInfo<?> monitorInfo;
    private IValueAnalyzer<?> ofa;
    private Pair.PairManager pairMgr;
    private SafeLockAnalysis safelockAnalysis;
    private IThreadGraphInfo threadgraph;
    private boolean useOFA;
    private boolean useSafeLockAnalysis;

    protected ReadyDAv1(IDirectionSensitiveInfo directionSensitiveInfo, IDependencyAnalysis.Direction direction) {
        super(direction);
        this.directionSensInfo = directionSensitiveInfo;
        this.preprocessor = new PreProcessor();
        this.considerCallSites = false;
    }

    public static ReadyDAv1 getBackwardReadyDA() {
        return new ReadyDAv1(new BackwardDirectionSensitiveInfo(), IDependencyAnalysis.Direction.BACKWARD_DIRECTION);
    }

    public static ReadyDAv1 getForwardReadyDA() {
        return new ReadyDAv1(new ForwardDirectionSensitiveInfo(), IDependencyAnalysis.Direction.FORWARD_DIRECTION);
    }

    @Override
    public void analyze() {
        this.unstable();
        if (this.monitorInfo.isStable() && this.callgraph.isStable() && this.threadgraph.isStable() && (!this.useSafeLockAnalysis || this.safelockAnalysis.isStable())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("BEGIN: Ready Dependence [" + this.getClass() + "] processing");
            }
            if (!this.threadgraph.getCreationSites().isEmpty()) {
                this.processRules();
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("analyze() - " + this.toString());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("END: Ready Dependence processing");
            }
            this.stable();
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Delaying execution as prerequisites are unsatisfied.");
        }
    }

    @Override
    public Collection<Pair<Stmt, SootMethod>> getDependees(Stmt dependentStmt, SootMethod method) {
        return this.getDependenceHelper(dependentStmt, method, this.dependent2dependee);
    }

    @Override
    public Collection<Pair<Stmt, SootMethod>> getDependents(Stmt dependeeStmt, SootMethod method) {
        return this.getDependenceHelper(dependeeStmt, method, this.dependee2dependent);
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.READY_DA);
    }

    public int getRules() {
        return this.rules;
    }

    @Override
    public void reset() {
        super.reset();
        this.enterMonitors.clear();
        this.exitMonitors.clear();
        this.waits.clear();
        this.notifies.clear();
    }

    public void setConsiderCallSites(boolean consider) {
        this.considerCallSites = consider;
    }

    public void setRules(int rulesParam) {
        if ((rulesParam & 0xFFFFFFF0) != 0) {
            throw new IllegalArgumentException("rules has to be a combination of RULE_XX constants defined in this class.");
        }
        this.rules = rulesParam;
    }

    public final void setUseOFA(boolean flag) {
        this.useOFA = flag;
    }

    public void setUseSafeLockAnalysis(boolean b) {
        this.useSafeLockAnalysis = b;
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("Statistics for Ready dependence as calculated by " + this.getClass().getName() + "\n");
        int _edgeCount1 = 0;
        StringBuffer _temp = new StringBuffer();
        for (Map.Entry _entry : this.dependent2dependee.entrySet()) {
            Object _method = _entry.getKey();
            _result.append("In method " + _method + "\n ");
            for (Map.Entry _entry1 : ((Map)_entry.getValue()).entrySet()) {
                Object _dependent = _entry1.getKey();
                int _localEdgeCount = 0;
                for (Object _dependee : (Collection)_entry1.getValue()) {
                    _temp.append("\t\t" + _dependee + " <-- " + _dependent + "\n");
                }
                _localEdgeCount += ((Collection)_entry1.getValue()).size();
                Object _key = _entry1.getKey();
                _result.append("\tFor " + _key + "[");
                if (_key != null) {
                    _result.append(_key.hashCode());
                } else {
                    _result.append(0);
                }
                _result.append("] there are " + _localEdgeCount + " Ready dependence edges.\n");
                _result.append(_temp);
                _temp.delete(0, _temp.length());
                _edgeCount1 += _localEdgeCount;
            }
        }
        _result.append("A total of " + _edgeCount1 + " Ready dependence edges exist.");
        return _result.toString();
    }

    @Override
    protected IDependenceRetriever<Stmt, SootMethod, Pair<Stmt, SootMethod>, Stmt, SootMethod, Pair<Stmt, SootMethod>> getDependenceRetriever() {
        return new PairRetriever<Stmt, SootMethod, Stmt, Stmt, SootMethod, Stmt>();
    }

    protected final boolean ifDependentOnBasedOnOFAByRule4(Pair<InvokeStmt, SootMethod> waitPair, Pair<InvokeStmt, SootMethod> notifyPair) {
        SootMethod _waitMethod = (SootMethod)waitPair.getSecond();
        SootMethod _notifyMethod = (SootMethod)notifyPair.getSecond();
        InvokeStmt _wStmt = (InvokeStmt)waitPair.getFirst();
        InvokeStmt _nStmt = (InvokeStmt)notifyPair.getFirst();
        AllocationContext _context = new AllocationContext();
        InstanceInvokeExpr _wExpr = (InstanceInvokeExpr)_wStmt.getInvokeExpr();
        _context.setProgramPoint(_wExpr.getBaseBox());
        _context.setStmt((Stmt)_wStmt);
        _context.setRootMethod(_waitMethod);
        Collection<?> _col1 = this.ofa.getValues(_wExpr.getBase(), _context);
        InstanceInvokeExpr _nExpr = (InstanceInvokeExpr)_nStmt.getInvokeExpr();
        _context.setProgramPoint(_nExpr.getBaseBox());
        _context.setStmt((Stmt)_nStmt);
        _context.setRootMethod(_notifyMethod);
        Collection<?> _col2 = this.ofa.getValues(_nExpr.getBase(), _context);
        NullConstant _n = NullConstant.v();
        Collection _temp = SetUtils.intersection(_col1, _col2);
        while (_temp.remove(_n)) {
        }
        boolean _result = !_temp.isEmpty();
        return _result;
    }

    protected boolean ifDependentOnByRule2(Pair<EnterMonitorStmt, SootMethod> enterPair, Pair<ExitMonitorStmt, SootMethod> exitPair) {
        SootMethod _sm1 = (SootMethod)enterPair.getSecond();
        boolean _result = this.isLockUnsafe((MonitorStmt)enterPair.getFirst(), _sm1);
        if (_result) {
            RefType _exitMonitorOpType;
            RefType _enterMonitorOptype;
            SootMethod _sm2 = (SootMethod)exitPair.getSecond();
            boolean _syncedStaticMethod1 = false;
            boolean _syncedStaticMethod2 = false;
            EnterMonitorStmt _o1 = (EnterMonitorStmt)enterPair.getFirst();
            if (_o1 == null) {
                _enterMonitorOptype = _sm1.getDeclaringClass().getType();
                _syncedStaticMethod1 = _sm1.isStatic();
            } else {
                _enterMonitorOptype = _o1.getOp().getType();
            }
            ExitMonitorStmt _o2 = (ExitMonitorStmt)exitPair.getFirst();
            if (_o2 == null) {
                _exitMonitorOpType = _sm2.getDeclaringClass().getType();
                _syncedStaticMethod2 = _sm2.isStatic();
            } else {
                _exitMonitorOpType = _o2.getOp().getType();
            }
            if (_syncedStaticMethod1 && _syncedStaticMethod2) {
                _result = _enterMonitorOptype.equals(_exitMonitorOpType);
            } else if (_syncedStaticMethod1 ^ _syncedStaticMethod2) {
                _result = true;
            } else {
                _result = Util.isSameOrSubType((Type)_enterMonitorOptype, (Type)_exitMonitorOpType, (IEnvironment)this.env);
                if (_result && this.useOFA) {
                    _result = this.ifDependentOnBasedOnOFAByRule2(enterPair, exitPair);
                }
            }
        }
        return _result;
    }

    protected boolean ifDependentOnByRule4(Pair<InvokeStmt, SootMethod> wPair, Pair<InvokeStmt, SootMethod> nPair) {
        InvokeStmt _wait;
        SootClass _waitClass;
        InvokeStmt _notify = (InvokeStmt)nPair.getFirst();
        SootClass _notifyClass = this.env.getClass(((RefType)((InstanceInvokeExpr)_notify.getInvokeExpr()).getBase().getType()).getClassName());
        boolean _result = Util.isHierarchicallyRelated((SootClass)_notifyClass, (SootClass)(_waitClass = this.env.getClass(((RefType)((InstanceInvokeExpr)(_wait = (InvokeStmt)wPair.getFirst()).getInvokeExpr()).getBase().getType()).getClassName())));
        if (_result && this.useOFA) {
            _result = this.ifDependentOnBasedOnOFAByRule4(wPair, nPair);
        }
        return _result;
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.env = (IEnvironment)this.info.get(IEnvironment.ID);
        if (this.env == null) {
            throw new InitializationException(IEnvironment.ID + " was not provided in info.");
        }
        this.callgraph = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.callgraph == null) {
            throw new InitializationException(ICallGraphInfo.ID + " was not provided in info.");
        }
        this.threadgraph = (IThreadGraphInfo)this.info.get(IThreadGraphInfo.ID);
        if (this.threadgraph == null) {
            throw new InitializationException(IThreadGraphInfo.ID + " was not provided in info.");
        }
        this.pairMgr = (Pair.PairManager)this.info.get(Pair.PairManager.ID);
        if (this.pairMgr == null) {
            throw new InitializationException(Pair.PairManager.ID + " was not provided in info.");
        }
        this.ofa = (OFAnalyzer)this.info.get(IValueAnalyzer.ID);
        if (this.useOFA && this.ofa == null) {
            throw new InitializationException(IValueAnalyzer.ID + " was not provided in the info.");
        }
        this.monitorInfo = (IMonitorInfo)this.info.get(IMonitorInfo.ID);
        if (this.monitorInfo == null) {
            String _msg = "An interface with id, " + IMonitorInfo.ID + ", was not provided.";
            LOGGER.error(_msg);
            throw new InitializationException(_msg);
        }
        this.safelockAnalysis = (SafeLockAnalysis)this.info.get(SafeLockAnalysis.ID);
        if (this.useSafeLockAnalysis && this.safelockAnalysis == null) {
            String _msg = "An interface with id, " + SafeLockAnalysis.ID + ", was not provided.";
            LOGGER.error(_msg);
            throw new InitializationException(_msg);
        }
    }

    private boolean callsReadyMethod(Stmt stmt, SootMethod caller) {
        boolean _result = this.considerCallSites && stmt.containsInvokeExpr() ? this.callgraph.areAnyMethodsReachableFrom(this.readyMethods, stmt, caller) : false;
        return _result;
    }

    private Map<SootMethod, Collection<Stmt>> collectDependeesInMethods() {
        HashMap<SootMethod, Collection<Stmt>> _method2dependeeMap = new HashMap<SootMethod, Collection<Stmt>>();
        if ((this.rules & 1) != 0) {
            for (SootMethod _method : this.enterMonitors.keySet()) {
                if (!_method.isConcrete()) continue;
                Collection<EnterMonitorStmt> _enterMonitorStmts = this.enterMonitors.get(_method);
                HashSet<EnterMonitorStmt> _col = new HashSet<EnterMonitorStmt>();
                Iterator<EnterMonitorStmt> _j = _enterMonitorStmts.iterator();
                int _jEnd = _enterMonitorStmts.size();
                int _jIndex = 0;
                while (_jIndex < _jEnd) {
                    EnterMonitorStmt _enter = _j.next();
                    boolean _unsafe = this.isLockUnsafe((MonitorStmt)_enter, _method);
                    if (_unsafe) {
                        _col.add(_enter);
                    }
                    ++_jIndex;
                }
                _method2dependeeMap.put(_method, _col);
            }
        }
        if ((this.rules & 4) != 0) {
            for (SootMethod _method : this.waits.keySet()) {
                MapUtils.putAllIntoCollectionInMap(_method2dependeeMap, (Object)_method, this.waits.get(_method));
            }
        }
        return _method2dependeeMap;
    }

    private Collection<Pair<Stmt, SootMethod>> getDependenceHelper(Stmt stmt, SootMethod method, Map<SootMethod, Map<Stmt, Collection<Pair<Stmt, SootMethod>>>> map) {
        Map<Stmt, Collection<Pair<Stmt, SootMethod>>> _temp = map.get(method);
        Collection<Pair<Stmt, SootMethod>> _result = Collections.emptyList();
        if (_temp != null && _temp.containsKey(stmt)) {
            _result = Collections.unmodifiableCollection(_temp.get(stmt));
        }
        return _result;
    }

    private Collection<Pair<ExitMonitorStmt, SootMethod>> getExitMonitorStmtMethodPairs() {
        HashSet<Pair<ExitMonitorStmt, SootMethod>> _temp = new HashSet<Pair<ExitMonitorStmt, SootMethod>>();
        for (Map.Entry<SootMethod, Collection<ExitMonitorStmt>> _entry : this.exitMonitors.entrySet()) {
            SootMethod _method = _entry.getKey();
            for (ExitMonitorStmt _o : _entry.getValue()) {
                _temp.add((Pair<ExitMonitorStmt, SootMethod>)this.pairMgr.getPair((Object)_o, (Object)_method));
            }
        }
        return _temp;
    }

    private boolean ifDependentOnBasedOnOFAByRule2(Pair<EnterMonitorStmt, SootMethod> enterPair, Pair<ExitMonitorStmt, SootMethod> exitPair) {
        boolean _result;
        Collection<?> _col2;
        Collection<?> _col1;
        SootMethod _enterMethod = (SootMethod)enterPair.getSecond();
        SootMethod _exitMethod = (SootMethod)exitPair.getSecond();
        EnterMonitorStmt _enterStmt = (EnterMonitorStmt)enterPair.getFirst();
        ExitMonitorStmt _exitStmt = (ExitMonitorStmt)exitPair.getFirst();
        boolean _syncedStaticMethod1 = false;
        boolean _syncedStaticMethod2 = false;
        Context _context = new Context();
        if (_enterStmt == null) {
            _syncedStaticMethod1 = _enterMethod.isStatic();
            if (!_syncedStaticMethod1) {
                _context.setRootMethod(_enterMethod);
                _col1 = this.ofa.getValuesForThis(_context);
            } else {
                _col1 = Collections.emptyList();
            }
        } else {
            _context.setProgramPoint(_enterStmt.getOpBox());
            _context.setStmt((Stmt)_enterStmt);
            _context.setRootMethod(_enterMethod);
            _col1 = this.ofa.getValues(_enterStmt.getOp(), _context);
        }
        if (_exitStmt == null) {
            _syncedStaticMethod2 = _exitMethod.isStatic();
            if (!_syncedStaticMethod2) {
                _context.setProgramPoint(null);
                _context.setStmt(null);
                _context.setRootMethod(_exitMethod);
                _col2 = this.ofa.getValuesForThis(_context);
            } else {
                _col2 = Collections.emptyList();
            }
        } else {
            _context.setProgramPoint(_exitStmt.getOpBox());
            _context.setStmt((Stmt)_exitStmt);
            _context.setRootMethod(_exitMethod);
            _col2 = this.ofa.getValues(_exitStmt.getOp(), _context);
        }
        if (_syncedStaticMethod1 ^ _syncedStaticMethod2) {
            _result = true;
        } else {
            NullConstant _n = NullConstant.v();
            Collection _temp = SetUtils.intersection(_col1, (Collection)_col2);
            while (_temp.remove(_n)) {
            }
            _result = !_temp.isEmpty();
        }
        return _result;
    }

    private boolean isLockUnsafe(MonitorStmt monitorStmt, SootMethod method) {
        boolean _result = true;
        if (this.useSafeLockAnalysis) {
            _result = monitorStmt == null ? !this.safelockAnalysis.isLockSafe(method) : !this.safelockAnalysis.isLockSafe(monitorStmt, method);
        }
        return _result;
    }

    private boolean processMonitorInfo() {
        boolean _result = false;
        Collection _reachableMethods = this.callgraph.getReachableMethods();
        Iterator _i = _reachableMethods.iterator();
        int _iEnd = _reachableMethods.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            SootMethod _method = (SootMethod)_i.next();
            Collection _monitorTriplesIn = this.monitorInfo.getMonitorTriplesIn(_method);
            Iterator _j = _monitorTriplesIn.iterator();
            int _jEnd = _monitorTriplesIn.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Triple _monitor = (Triple)_j.next();
                EnterMonitorStmt _enter = (EnterMonitorStmt)_monitor.getFirst();
                if (_enter == null) {
                    MapUtils.putIntoCollectionInMap(this.enterMonitors, (Object)_method, null);
                    MapUtils.putIntoCollectionInMap(this.exitMonitors, (Object)_method, null);
                } else {
                    MapUtils.putIntoCollectionInMap(this.enterMonitors, (Object)_method, (Object)_enter);
                    MapUtils.putIntoCollectionInMap(this.exitMonitors, (Object)_method, (Object)((ExitMonitorStmt)_monitor.getSecond()));
                }
                ++_jIndex;
            }
            if (_jEnd > 0) {
                _result = true;
                this.readyMethods.add(_method);
            }
            ++_iIndex;
        }
        return _result;
    }

    private void processRule1And3() {
        HashSet _processed = new HashSet();
        HistoryAwareLIFOWorkBag _workbag = new HistoryAwareLIFOWorkBag(_processed);
        Map<SootMethod, Collection<Stmt>> _method2dependeeMap = this.collectDependeesInMethods();
        if (this.waits.size() == 0 ^ this.notifies.size() == 0 && LOGGER.isWarnEnabled()) {
            LOGGER.warn("There are wait()s and/or notify()s in this program without corresponding notify()s and/or wait()s that occur in different threads.");
        }
        HashSet<Pair<Stmt, SootMethod>> _dependents = new HashSet<Pair<Stmt, SootMethod>>();
        for (SootMethod _method : _method2dependeeMap.keySet()) {
            BasicBlockGraph _bbGraph = this.getBasicBlockGraph(_method);
            Collection<Stmt> _dependees = _method2dependeeMap.get(_method);
            Map _dents2dees = MapUtils.getMapFromMap((Map)this.dependent2dependee, (Object)_method);
            for (Stmt _o : _dependees) {
                if (!(_o instanceof Stmt)) continue;
                Stmt _dependee = _o;
                BasicBlockGraph.BasicBlock _bb = _bbGraph.getEnclosingBlock(_dependee);
                Collection<Stmt> _sl = this.directionSensInfo.getIntraBBDependents(_bb, _dependee);
                _dependents.clear();
                Pair _pair = this.pairMgr.getPair((Object)_dependee, (Object)_method);
                boolean _shouldContinue = this.recordDependent2DependeeInfo(_dependents, _method, _dependees, _dents2dees, _sl, (Pair<Stmt, SootMethod>)_pair);
                if (_shouldContinue) {
                    _workbag.clear();
                    _processed.clear();
                    _workbag.addAllWork(this.directionSensInfo.getFollowersOfBB(_bb));
                    while (_workbag.hasWork()) {
                        _bb = (BasicBlockGraph.BasicBlock)_workbag.getWork();
                        _shouldContinue = this.recordDependent2DependeeInfo(_dependents, _method, _dependees, _dents2dees, _bb.getStmtsOf(), (Pair<Stmt, SootMethod>)_pair);
                        if (!_shouldContinue) continue;
                        _workbag.addAllWork(this.directionSensInfo.getFollowersOfBB(_bb));
                    }
                }
                Map _dees2dents = MapUtils.getMapFromMap((Map)this.dependee2dependent, (Object)_method);
                MapUtils.putAllIntoCollectionInMap((Map)_dees2dents, (Object)_dependee, _dependents);
            }
        }
    }

    private void processRule2() {
        HashSet<Pair> _dependents = new HashSet<Pair>();
        Collection<Pair<ExitMonitorStmt, SootMethod>> _temp = this.getExitMonitorStmtMethodPairs();
        Iterator<Pair<ExitMonitorStmt, SootMethod>> _i = _temp.iterator();
        int _iEnd = _temp.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Pair<ExitMonitorStmt, SootMethod> _exitPair = _i.next();
            ExitMonitorStmt _exit = (ExitMonitorStmt)_exitPair.getFirst();
            SootMethod _exitMethod = (SootMethod)_exitPair.getSecond();
            Set<Map.Entry<SootMethod, Collection<EnterMonitorStmt>>> _entrySet = this.enterMonitors.entrySet();
            Iterator<Map.Entry<SootMethod, Collection<EnterMonitorStmt>>> _j = _entrySet.iterator();
            int _jEnd = _entrySet.size();
            _dependents.clear();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                Map.Entry<SootMethod, Collection<EnterMonitorStmt>> _entry = _j.next();
                SootMethod _enterMethod = _entry.getKey();
                Collection<EnterMonitorStmt> _collection = _entry.getValue();
                Iterator<EnterMonitorStmt> _iter = _collection.iterator();
                int _iterEnd = _collection.size();
                int _iterIndex = 0;
                while (_iterIndex < _iterEnd) {
                    Pair _enterPair;
                    EnterMonitorStmt _enter = _iter.next();
                    if (this.typesAreCompatible(_enter, _enterMethod, _exit, _exitMethod) && this.ifDependentOnByRule2((Pair<EnterMonitorStmt, SootMethod>)(_enterPair = this.pairMgr.getPair((Object)_enter, (Object)_enterMethod)), _exitPair)) {
                        Map _dents2dees = MapUtils.getMapFromMap((Map)this.dependent2dependee, (Object)_enterMethod);
                        Pair _nPair = this.pairMgr.getPair((Object)_enter, (Object)_enterMethod);
                        Pair _xPair = this.pairMgr.getPair((Object)_exit, (Object)_exitMethod);
                        MapUtils.putIntoCollectionInMap((Map)_dents2dees, (Object)_enter, (Object)_xPair);
                        _dependents.add(_nPair);
                    }
                    ++_iterIndex;
                }
                ++_jIndex;
            }
            if (!_dependents.isEmpty()) {
                Map _dees2dents = MapUtils.getMapFromMap((Map)this.dependee2dependent, (Object)_exitMethod);
                MapUtils.putAllIntoCollectionInMap((Map)_dees2dents, (Object)_exit, _dependents);
            }
            ++_iIndex;
        }
    }

    private void processRule4() {
        HashSet<Pair> _dependents = new HashSet<Pair>();
        for (Map.Entry<SootMethod, Collection<InvokeStmt>> _nEntry : this.notifies.entrySet()) {
            SootMethod _nMethod = _nEntry.getKey();
            for (InvokeStmt _notify : _nEntry.getValue()) {
                Pair _notifyPair = this.pairMgr.getPair((Object)_notify, (Object)_nMethod);
                Pair _nPair = this.pairMgr.getPair((Object)_notify, (Object)_nMethod);
                _dependents.clear();
                for (Map.Entry<SootMethod, Collection<InvokeStmt>> _wEntry : this.waits.entrySet()) {
                    SootMethod _wMethod = _wEntry.getKey();
                    for (InvokeStmt _wait : _wEntry.getValue()) {
                        Pair _waitPair = this.pairMgr.getPair((Object)_wait, (Object)_wMethod);
                        if (!this.ifDependentOnByRule4((Pair<InvokeStmt, SootMethod>)_waitPair, (Pair<InvokeStmt, SootMethod>)_notifyPair)) continue;
                        Map _dents2dees = MapUtils.getMapFromMap((Map)this.dependent2dependee, (Object)_wMethod);
                        Pair _wPair = this.pairMgr.getPair((Object)_wait, (Object)_wMethod);
                        MapUtils.putIntoCollectionInMap((Map)_dents2dees, (Object)_wait, (Object)_nPair);
                        _dependents.add(_wPair);
                    }
                }
                if (_dependents.isEmpty()) continue;
                Map _dees2dents = MapUtils.getMapFromMap((Map)this.dependee2dependent, (Object)_nMethod);
                MapUtils.putAllIntoCollectionInMap((Map)_dees2dents, (Object)_notify, _dependents);
            }
        }
    }

    private void processRules() {
        boolean _syncExists = this.processMonitorInfo();
        if (_syncExists) {
            if ((this.rules & 5) != 0) {
                this.processRule1And3();
            }
            if ((this.rules & 2) != 0) {
                this.processRule2();
            }
        }
        if ((this.rules & 8) != 0 && !this.waits.isEmpty() && !this.notifies.isEmpty()) {
            if (!_syncExists && LOGGER.isWarnEnabled()) {
                LOGGER.warn("All waits and in this system are unsafe - they are not embedded in a synchronized block.");
            }
            this.processRule4();
        }
    }

    private boolean recordDependent2DependeeInfo(Collection<Pair<Stmt, SootMethod>> dependents, SootMethod method, Collection<Stmt> dependees, Map<Stmt, Collection<Pair<Stmt, SootMethod>>> dents2dees, Collection<Stmt> stmts, Pair<Stmt, SootMethod> pair) {
        boolean _shouldContinue = true;
        Iterator<Stmt> _k = stmts.iterator();
        while (_k.hasNext() && _shouldContinue) {
            Stmt _stmt = _k.next();
            MapUtils.putIntoCollectionInMap(dents2dees, (Object)_stmt, pair);
            dependents.add((Pair<Stmt, SootMethod>)this.pairMgr.getPair((Object)_stmt, (Object)method));
            boolean bl = _shouldContinue = !dependees.contains(_stmt) && !this.callsReadyMethod(_stmt, method);
        }
        return _shouldContinue;
    }

    private boolean typesAreCompatible(EnterMonitorStmt enter, SootMethod enterMethod, ExitMonitorStmt exit, SootMethod exitMethod) {
        boolean _result;
        if (enter == null) {
            SootClass _nClass = enterMethod.getDeclaringClass();
            if (enterMethod.isStatic()) {
                if (exit == null) {
                    SootClass _xClass = exitMethod.getDeclaringClass();
                    _result = exitMethod.isStatic() ? _xClass.equals(_nClass) : Util.isDescendentOf((SootClass)_xClass, (String)"java.lang.Class");
                } else {
                    Type _xType = exit.getOp().getType();
                    if (_xType instanceof RefType) {
                        SootClass _xClass = ((RefType)_xType).getSootClass();
                        _result = Util.isDescendentOf((SootClass)_xClass, (String)"java.lang.Class");
                    } else {
                        _result = false;
                    }
                }
            } else if (exit == null) {
                SootClass _xClass = exitMethod.getDeclaringClass();
                _result = exitMethod.isStatic() ? false : Util.isHierarchicallyRelated((SootClass)_nClass, (SootClass)_xClass);
            } else {
                Type _xType = exit.getOp().getType();
                if (_xType instanceof RefType) {
                    SootClass _xClass = ((RefType)_xType).getSootClass();
                    _result = Util.isHierarchicallyRelated((SootClass)_nClass, (SootClass)_xClass);
                } else {
                    _result = _nClass.getName().equals("java.lang.Object");
                }
            }
        } else {
            Type _nType = enter.getOp().getType();
            if (_nType instanceof RefType) {
                SootClass _nClass = enterMethod.getDeclaringClass();
                if (exit == null) {
                    SootClass _xClass = exitMethod.getDeclaringClass();
                    _result = exitMethod.isStatic() ? Util.isDescendentOf((SootClass)_nClass, (String)"java.lang.Class") : Util.isDescendentOf((SootClass)_xClass, (SootClass)_nClass);
                } else {
                    Type _xType = exit.getOp().getType();
                    if (_xType instanceof RefType) {
                        SootClass _xClass = ((RefType)_xType).getSootClass();
                        _result = Util.isDescendentOf((SootClass)_xClass, (SootClass)_nClass);
                    } else {
                        _result = _nClass.getName().equals("java.lang.Object");
                    }
                }
            } else if (exit == null) {
                SootClass _xClass = exitMethod.getDeclaringClass();
                _result = exitMethod.isStatic() ? false : _xClass.getName().equals("java.lang.Object");
            } else {
                Type _xType = exit.getOp().getType();
                if (_xType instanceof RefType) {
                    SootClass _xClass = ((RefType)_xType).getSootClass();
                    _result = _xClass.getName().equals("java.lang.Object");
                } else {
                    _result = _xType.equals(_nType);
                }
            }
        }
        return _result;
    }

    private class PreProcessor
    extends AbstractProcessor {
        private PreProcessor() {
        }

        public void callback(Stmt stmt, Context context) {
            SootMethod _method = context.getCurrentMethod();
            InvokeExpr _expr = stmt.getInvokeExpr();
            if (_expr instanceof VirtualInvokeExpr) {
                VirtualInvokeExpr _invokeExpr = (VirtualInvokeExpr)_expr;
                SootMethod _callee = _invokeExpr.getMethod();
                Map<SootMethod, Collection<InvokeStmt>> _method2stmts = null;
                if (Util.isWaitMethod((SootMethod)_callee)) {
                    _method2stmts = ReadyDAv1.this.waits;
                } else if (Util.isNotifyMethod((SootMethod)_callee)) {
                    _method2stmts = ReadyDAv1.this.notifies;
                }
                if (_method2stmts != null) {
                    MapUtils.putIntoCollectionInMap(_method2stmts, (Object)_method, (Object)((InvokeStmt)stmt));
                }
            }
        }

        public void consolidate() {
            ReadyDAv1.this.readyMethods.addAll((Collection<SootMethod>)ReadyDAv1.this.waits.keySet());
        }

        public void hookup(ProcessingController ppc) {
            ppc.register(InvokeStmt.class, (IProcessor)this);
        }

        public void unhook(ProcessingController ppc) {
            ppc.unregister(InvokeStmt.class, (IProcessor)this);
        }
    }
}

