/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.datastructures.IWorkBag;
import edu.ksu.cis.indus.common.datastructures.LIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonTerminationSensitiveEntryControlDA
extends AbstractControlDA {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(NonTerminationSensitiveEntryControlDA.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(NonTerminationSensitiveEntryControlDA.class);
    protected List<BasicBlockGraph.BasicBlock> nodesCache;
    protected Collection<BasicBlockGraph.BasicBlock> nodesWithChildrenCache;
    private final Pair.PairManager pairMgr = new Pair.PairManager(false, true);

    public NonTerminationSensitiveEntryControlDA() {
        super(IDependencyAnalysis.Direction.BI_DIRECTIONAL);
    }

    @Override
    public void analyze() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Entry Control Dependence processing");
        }
        this.analyze(this.callgraph.getReachableMethods());
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Entry Control Dependence processing");
        }
    }

    public void analyze(Collection<SootMethod> methods) {
        this.unstable();
        for (SootMethod _currMethod : methods) {
            BasicBlockGraph _bbGraph = this.getBasicBlockGraph(_currMethod);
            if (_bbGraph == null) {
                LOGGER.error("Method " + _currMethod.getSignature() + " did not have a basic block graph.");
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing method: " + _currMethod.getSignature());
            }
            BitSet[] _bbCDBitSets = this.computeControlDependency(_bbGraph);
            this.fixupMaps(_bbCDBitSets, _currMethod);
        }
        this.nodesCache = null;
        this.nodesWithChildrenCache = null;
        this.pairMgr.reset();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("analyze() - " + this.toString());
        }
        this.stable();
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.callgraph == null) {
            throw new InitializationException(ICallGraphInfo.ID + " was not provided.");
        }
    }

    private boolean accumulateTokensAtNode(BasicBlockGraph.BasicBlock bb, BitSet[][] tokenSets) {
        boolean _result = false;
        int _nodeIndex = this.nodesCache.indexOf(bb);
        Iterator<BasicBlockGraph.BasicBlock> _ctrlPoints = this.nodesWithChildrenCache.iterator();
        int _iIndex = this.nodesWithChildrenCache.size() - 1;
        while (_iIndex >= 0) {
            BasicBlockGraph.BasicBlock _ctrlPointNode = _ctrlPoints.next();
            int _ctrlPointNodeIndex = this.nodesCache.indexOf(_ctrlPointNode);
            BitSet _nodesCtrlPointBitSet = tokenSets[_nodeIndex][_ctrlPointNodeIndex];
            if (_nodesCtrlPointBitSet.cardinality() == this.getFanoutNumOf(_ctrlPointNode) && _nodeIndex != _ctrlPointNodeIndex) {
                _result |= this.copyAncestorBitSetsFromTo(_ctrlPointNodeIndex, _nodeIndex, tokenSets);
            }
            --_iIndex;
        }
        return _result;
    }

    private BitSet[] calculateCDFromTokenInfo(BitSet[][] tokenSets) {
        BitSet[] _result = new BitSet[this.nodesCache.size()];
        Iterator<BasicBlockGraph.BasicBlock> _i = this.nodesWithChildrenCache.iterator();
        int _j = this.nodesWithChildrenCache.size();
        while (_j > 0) {
            BasicBlockGraph.BasicBlock _controlPoint = _i.next();
            int _cpIndex = this.nodesCache.indexOf(_controlPoint);
            int _succsSize = this.getFanoutNumOf(_controlPoint);
            int _k = this.nodesCache.size() - 1;
            while (_k >= 0) {
                int _cardinality;
                BitSet _tokens = tokenSets[_k][_cpIndex];
                if (_tokens != null && (_cardinality = _tokens.cardinality()) > 0 && _cardinality != _succsSize) {
                    BitSet _temp = _result[_k];
                    if (_temp == null) {
                        _result[_k] = _temp = new BitSet();
                    }
                    _temp.set(_cpIndex);
                }
                --_k;
            }
            --_j;
        }
        return _result;
    }

    private BitSet[] computeControlDependency(BasicBlockGraph graph) {
        this.nodesCache = graph.getNodes();
        this.nodesWithChildrenCache = this.getNodesWithChildren();
        int _size = this.nodesCache.size();
        BitSet[][] _tokenSets = new BitSet[_size][_size];
        int _i = _size - 1;
        while (_i >= 0) {
            int _j = _size - 1;
            while (_j >= 0) {
                _tokenSets[_i][_j] = new BitSet();
                --_j;
            }
            --_i;
        }
        IWorkBag<Pair<BasicBlockGraph.BasicBlock, Boolean>> _wb = this.injectTokensAndGenerateWorkForTokenPropagation(_tokenSets);
        while (_wb.hasWork()) {
            Pair _pair = (Pair)_wb.getWork();
            _wb.addAllWorkNoDuplicates(this.processNode((Pair<BasicBlockGraph.BasicBlock, Boolean>)_pair, _tokenSets));
            if (!LOGGER.isDebugEnabled()) continue;
            StringBuffer _msg = new StringBuffer();
            int _i2 = _size - 1;
            while (_i2 >= 0) {
                _msg.append("{");
                int _j = _size - 1;
                while (_j >= 0) {
                    _msg.append(String.valueOf(_tokenSets[_i2][_j].toString()) + ",");
                    --_j;
                }
                _msg.append("}");
                --_i2;
            }
            LOGGER.debug("computeControlDependency() - Node being processed : _node = " + _pair.getFirst() + "nodeIndex = " + this.nodesCache.indexOf(_pair.getFirst()) + " _tokenSets = " + _msg);
        }
        return this.calculateCDFromTokenInfo(_tokenSets);
    }

    private boolean copyAncestorBitSetsFromTo(int src, int dest, BitSet[][] tokenSets) {
        boolean _result = false;
        BitSet _temp = new BitSet();
        BitSet[] _srcBitSets = tokenSets[src];
        BitSet[] _destBitSets = tokenSets[dest];
        Iterator<BasicBlockGraph.BasicBlock> _i = this.nodesWithChildrenCache.iterator();
        int _iEnd = this.nodesWithChildrenCache.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            BasicBlockGraph.BasicBlock _ancestor = _i.next();
            int _ancestorIndex = this.nodesCache.indexOf(_ancestor);
            if (dest != _ancestorIndex) {
                BitSet _srcsAncestorBitSet = _srcBitSets[_ancestorIndex];
                BitSet _destAndAncestorBitSet = _destBitSets[_ancestorIndex];
                _temp.clear();
                _temp.or(_srcsAncestorBitSet);
                _temp.andNot(_destAndAncestorBitSet);
                _result |= !_temp.isEmpty();
                _destAndAncestorBitSet.or(_temp);
            }
            ++_iIndex;
        }
        return _result;
    }

    private void fixupMaps(BitSet[] bbCDBitSets, SootMethod method) {
        List<Stmt> _sl = this.getStmtList(method);
        ArrayList _mDependee = new ArrayList();
        ArrayList _mDependent = new ArrayList();
        int _i = _sl.size();
        while (_i > 0) {
            _mDependee.add(null);
            _mDependent.add(null);
            --_i;
        }
        boolean _flag = false;
        int _i2 = bbCDBitSets.length - 1;
        while (_i2 >= 0) {
            BitSet _cd = bbCDBitSets[_i2];
            _flag |= _cd != null;
            if (_cd != null) {
                ArrayList<Stmt> _cdp = new ArrayList<Stmt>();
                BasicBlockGraph.BasicBlock _bb = this.nodesCache.get(_i2);
                Iterator _j = _bb.getStmtsOf().iterator();
                while (_j.hasNext()) {
                    _mDependee.set(_sl.indexOf(_j.next()), _cdp);
                }
                int _j2 = _cd.nextSetBit(0);
                while (_j2 != -1) {
                    BasicBlockGraph.BasicBlock _cdbb = this.nodesCache.get(_j2);
                    Stmt _cdStmt = _cdbb.getTrailerStmt();
                    _cdp.add(_cdStmt);
                    int _deIndex = _sl.indexOf(_cdStmt);
                    ArrayList _dees = (ArrayList)_mDependent.get(_deIndex);
                    if (_dees == null) {
                        _dees = new ArrayList();
                        _mDependent.set(_deIndex, _dees);
                    }
                    _dees.addAll(_bb.getStmtsOf());
                    _j2 = _cd.nextSetBit(_j2 + 1);
                }
            }
            --_i2;
        }
        if (_flag) {
            this.dependee2dependent.put(method, new ArrayList(_mDependent));
            this.dependent2dependee.put(method, new ArrayList(_mDependee));
        } else {
            this.dependee2dependent.put(method, null);
            this.dependent2dependee.put(method, null);
        }
    }

    private Collection<BasicBlockGraph.BasicBlock> getNodesWithChildren() {
        HashSet<BasicBlockGraph.BasicBlock> _result = new HashSet<BasicBlockGraph.BasicBlock>();
        for (BasicBlockGraph.BasicBlock _b : this.nodesCache) {
            if (this.getFanoutNumOf(_b) <= 1) continue;
            _result.add(_b);
        }
        return _result;
    }

    private IWorkBag<Pair<BasicBlockGraph.BasicBlock, Boolean>> injectTokensAndGenerateWorkForTokenPropagation(BitSet[][] tokenSets) {
        LIFOWorkBag _wb = new LIFOWorkBag();
        for (BasicBlockGraph.BasicBlock _node : this.nodesWithChildrenCache) {
            int _nodeIndex = this.nodesCache.indexOf(_node);
            Collection _succs = _node.getSuccsOf();
            Iterator _k = _succs.iterator();
            int _j = _succs.size();
            int _count = 0;
            while (_j > 0) {
                BasicBlockGraph.BasicBlock _succ = (BasicBlockGraph.BasicBlock)_k.next();
                int _succIndex = this.nodesCache.indexOf(_succ);
                BitSet _temp = tokenSets[_succIndex][_nodeIndex];
                _temp.set(_count);
                _wb.addWorkNoDuplicates((Object)this.pairMgr.getPair((Object)_succ, (Object)Boolean.TRUE));
                --_j;
                ++_count;
            }
        }
        return _wb;
    }

    private Collection<Pair<BasicBlockGraph.BasicBlock, Boolean>> processNode(Pair<BasicBlockGraph.BasicBlock, Boolean> pair, BitSet[][] tokenSets) {
        BasicBlockGraph.BasicBlock _node = (BasicBlockGraph.BasicBlock)pair.getFirst();
        boolean _addedDueToTokePropagation = (Boolean)pair.getSecond();
        boolean _accumlatedTokens = this.accumulateTokensAtNode(_node, tokenSets);
        Collection<Pair<BasicBlockGraph.BasicBlock, Boolean>> _result = Collections.emptySet();
        if (_addedDueToTokePropagation || _accumlatedTokens) {
            int _size = this.getFanoutNumOf(_node);
            if (_size == 1) {
                _result = this.processNodeWithOneChild(_node, tokenSets);
            } else if (_size > 1) {
                int _nodeIndex = this.nodesCache.indexOf(_node);
                _result = new HashSet<Pair<BasicBlockGraph.BasicBlock, Boolean>>();
                int _iEnd = this.nodesCache.size();
                int _iIndex = 0;
                while (_iIndex < _iEnd) {
                    BitSet _bitSet = tokenSets[_iIndex][_nodeIndex];
                    if (_bitSet.cardinality() == _size) {
                        _result.add((Pair<BasicBlockGraph.BasicBlock, Boolean>)this.pairMgr.getPair((Object)this.nodesCache.get(_iIndex), (Object)_accumlatedTokens));
                    }
                    ++_iIndex;
                }
            }
        }
        return _result;
    }

    private Collection<Pair<BasicBlockGraph.BasicBlock, Boolean>> processNodeWithOneChild(BasicBlockGraph.BasicBlock node, BitSet[][] tokenSets) {
        boolean _addflag = false;
        int _nodeIndex = this.nodesCache.indexOf(node);
        BitSet[] _nodeBitSets = tokenSets[_nodeIndex];
        BasicBlockGraph.BasicBlock _succ = (BasicBlockGraph.BasicBlock)node.getSuccsOf().iterator().next();
        int _succIndex = this.nodesCache.indexOf(_succ);
        BitSet[] _succBitSets = tokenSets[_succIndex];
        BitSet _temp = new BitSet();
        Iterator<BasicBlockGraph.BasicBlock> _i = this.nodesWithChildrenCache.iterator();
        int _iEnd = this.nodesWithChildrenCache.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            BasicBlockGraph.BasicBlock _ancestor = _i.next();
            int _ancIndex = this.nodesCache.indexOf(_ancestor);
            BitSet _nodeAncestorTokenSet = _nodeBitSets[_ancIndex];
            BitSet _succAncestorTokenSet = _succBitSets[_ancIndex];
            _temp.clear();
            _temp.or(_nodeAncestorTokenSet);
            _temp.andNot(_succAncestorTokenSet);
            if (!_temp.isEmpty()) {
                _succAncestorTokenSet.or(_temp);
                _addflag |= true;
            }
            ++_iIndex;
        }
        Collection _result = _addflag ? (Collection)Collections.singleton(this.pairMgr.getPair((Object)_succ, (Object)Boolean.TRUE)) : (Collection)Collections.emptySet();
        return _result;
    }
}

