/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.ListUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IndirectDependenceAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationSensitiveEntryControlDA;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NonTerminationInsensitiveEntryControlDA
extends AbstractControlDA {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(NonTerminationInsensitiveEntryControlDA.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(NonTerminationInsensitiveEntryControlDA.class);
    private final NonTerminationSensitiveEntryControlDA entryControlDA = new NonTerminationSensitiveEntryControlDA();
    private final boolean useIndirectBackwardDependence;

    public NonTerminationInsensitiveEntryControlDA() {
        this(false);
    }

    NonTerminationInsensitiveEntryControlDA(boolean indirect) {
        super(IDependencyAnalysis.Direction.BI_DIRECTIONAL);
        this.useIndirectBackwardDependence = indirect;
    }

    @Override
    public void analyze() {
        this.analyze(this.callgraph.getReachableMethods());
    }

    public void analyze(Collection<SootMethod> methods) {
        this.unstable();
        this.entryControlDA.analyze(methods);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Entry Control Dependence processing");
        }
        IDependencyAnalysis<Stmt, SootMethod, Stmt, Stmt, SootMethod, Stmt> _nda = this.useIndirectBackwardDependence ? this.entryControlDA.getIndirectVersionOfDependence() : this.entryControlDA;
        for (SootMethod _method : methods) {
            this.processMethod(_method, _nda);
        }
        if (LOGGER.isDebugEnabled()) {
            if (_nda instanceof IndirectDependenceAnalysis) {
                LOGGER.debug(((IndirectDependenceAnalysis)_nda).toString(methods));
            } else {
                LOGGER.debug(((Object)_nda).toString());
            }
            LOGGER.debug(this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Entry Control Dependence processing");
        }
        this.stable();
    }

    @Override
    public void setBasicBlockGraphManager(BasicBlockGraphMgr bbm) {
        super.setBasicBlockGraphManager(bbm);
        this.entryControlDA.setBasicBlockGraphManager(bbm);
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.callgraph == null) {
            throw new InitializationException(ICallGraphInfo.ID + " was not provided.");
        }
        this.entryControlDA.initialize(this.info);
    }

    private Collection<Collection<BasicBlockGraph.BasicBlock>> getControlSinksOf(BasicBlockGraph graph) {
        ArrayList<Collection<BasicBlockGraph.BasicBlock>> _result = new ArrayList<Collection<BasicBlockGraph.BasicBlock>>();
        List _sccs = graph.getSCCs(true);
        Iterator _i = _sccs.iterator();
        int _iEnd = _sccs.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            boolean _isAControlSink = true;
            List _scc = (List)_i.next();
            int _sccSize = _scc.size();
            if (_scc.size() > 1) {
                Iterator _j = _scc.iterator();
                int _jIndex = 0;
                while (_jIndex < _sccSize && _isAControlSink) {
                    BasicBlockGraph.BasicBlock _node = (BasicBlockGraph.BasicBlock)_j.next();
                    _isAControlSink &= _scc.containsAll(_node.getSuccsOf()) && !_node.isAnExitBlock();
                    ++_jIndex;
                }
            } else {
                BasicBlockGraph.BasicBlock _node = (BasicBlockGraph.BasicBlock)_scc.iterator().next();
                _isAControlSink &= _node.getSuccsOf().contains(_node) || _node.isAnExitBlock();
            }
            if (_isAControlSink) {
                _result.add(_scc);
            }
            ++_iIndex;
        }
        return _result;
    }

    private Collection<BasicBlockGraph.BasicBlock> getNodesOfSinksNotContainingNode(INode node, Collection<Collection<BasicBlockGraph.BasicBlock>> sinks) {
        ArrayList<BasicBlockGraph.BasicBlock> _result = new ArrayList<BasicBlockGraph.BasicBlock>();
        Iterator<Collection<BasicBlockGraph.BasicBlock>> _i = sinks.iterator();
        int _iEnd = sinks.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Collection<BasicBlockGraph.BasicBlock> _sinkNodes = _i.next();
            if (!_sinkNodes.contains(node)) {
                _result.addAll(_sinkNodes);
            }
            ++_iIndex;
        }
        return _result;
    }

    private void processMethod(SootMethod method, IDependencyAnalysis da) {
        List _methodLocalDee2Dent = MapUtils.getListFromMap((Map)this.dependee2dependent, (Object)method);
        List _methodLocalDent2Dee = MapUtils.getListFromMap((Map)this.dependent2dependee, (Object)method);
        List<Stmt> _stmtList = this.getStmtList(method);
        int _size = _stmtList.size();
        ListUtils.ensureSize((List)_methodLocalDent2Dee, (int)_size, null);
        ListUtils.ensureSize((List)_methodLocalDee2Dent, (int)_size, null);
        BasicBlockGraph _bbg = this.getBasicBlockGraph(method);
        Collection<Collection<BasicBlockGraph.BasicBlock>> _sinks = this.getControlSinksOf(_bbg);
        ArrayList _dependees = new ArrayList();
        List _nodes = _bbg.getNodes();
        HistoryAwareLIFOWorkBag _wb = new HistoryAwareLIFOWorkBag(_dependees);
        Iterator _i = _nodes.iterator();
        int _iEnd = _nodes.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            BasicBlockGraph.BasicBlock _dependentBB = (BasicBlockGraph.BasicBlock)_i.next();
            Collection<BasicBlockGraph.BasicBlock> _sinkNodes = this.getNodesOfSinksNotContainingNode((INode)_dependentBB, _sinks);
            _dependees.clear();
            _wb.addAllWork(da.getDependees(_dependentBB.getLeaderStmt(), method));
            while (_wb.hasWork()) {
                Stmt _dependeeStmt = (Stmt)_wb.getWork();
                BasicBlockGraph.BasicBlock _dependeeBB = _bbg.getEnclosingBlock(_dependeeStmt);
                if (this.shouldRemoveDependenceBetween(_dependeeBB, _dependentBB, _sinkNodes)) {
                    this.updateDependence(_dependentBB, _dependeeBB, _methodLocalDee2Dent, _methodLocalDent2Dee, _stmtList, true);
                    _wb.addAllWork(da.getDependees(_dependeeBB.getTrailerStmt(), method));
                    continue;
                }
                this.updateDependence(_dependentBB, _dependeeBB, _methodLocalDee2Dent, _methodLocalDent2Dee, _stmtList, false);
            }
            ++_iIndex;
        }
    }

    private boolean shouldRemoveDependenceBetween(BasicBlockGraph.BasicBlock dependeeBB, BasicBlockGraph.BasicBlock dependentBB, Collection<BasicBlockGraph.BasicBlock> sinkNodes) {
        HashSet<BasicBlockGraph.BasicBlock> _visited = new HashSet<BasicBlockGraph.BasicBlock>();
        HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_visited);
        boolean _notcd = true;
        _visited.add(dependentBB);
        _wb.addWork((Object)dependeeBB);
        while (_wb.hasWork() && _notcd) {
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_wb.getWork();
            if (sinkNodes.contains(_bb)) {
                _notcd = false;
                continue;
            }
            _wb.addAllWorkNoDuplicates(_bb.getSuccsOf());
        }
        return _notcd;
    }

    private void updateDependence(BasicBlockGraph.BasicBlock dependentBB, BasicBlockGraph.BasicBlock dependeeBB, List<Collection<Stmt>> methodLocalDee2Dent, List<Collection<Stmt>> methodLocalDent2Dee, List<Stmt> stmtList, boolean remove) {
        Stmt _deeStmt = dependeeBB.getTrailerStmt();
        Collection _stmtLevelDependentSet = (Collection)ListUtils.getAtIndexFromListUsingFactory(methodLocalDee2Dent, (int)stmtList.indexOf(_deeStmt), (IFactory)SetUtils.getFactory());
        List _dents = dependentBB.getStmtsOf();
        if (remove) {
            _stmtLevelDependentSet.removeAll(_dents);
        } else {
            _stmtLevelDependentSet.addAll(_dents);
        }
        Iterator _i = _dents.iterator();
        int _iEnd = _dents.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            Stmt _dentStmt = (Stmt)_i.next();
            Collection _stmtLevelDependeeSet = (Collection)ListUtils.getAtIndexFromListUsingFactory(methodLocalDent2Dee, (int)stmtList.indexOf(_dentStmt), (IFactory)SetUtils.getFactory());
            if (remove) {
                _stmtLevelDependeeSet.remove(_deeStmt);
            } else {
                _stmtLevelDependeeSet.add(_deeStmt);
            }
            ++_iIndex;
        }
    }
}

