/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.ToStringBasedComparator;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.processing.AbstractProcessor;
import edu.ksu.cis.indus.processing.Context;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.PairRetriever;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.modes.sensitive.allocation.AllocationContext;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.NullConstant;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterferenceDAv1
extends AbstractDependencyAnalysis<AssignStmt, SootMethod, Pair<AssignStmt, SootMethod>, Object, Map<Pair<AssignStmt, SootMethod>, Collection<Pair<AssignStmt, SootMethod>>>, AssignStmt, SootMethod, Pair<AssignStmt, SootMethod>, Object, Map<Pair<AssignStmt, SootMethod>, Collection<Pair<AssignStmt, SootMethod>>>> {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(InterferenceDAv1.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(InterferenceDAv1.class);
    protected Pair.PairManager pairMgr;
    protected IThreadGraphInfo tgi;
    private IValueAnalyzer<Value> ofa;
    private boolean useOFA;

    public InterferenceDAv1() {
        super(IDependencyAnalysis.Direction.BI_DIRECTIONAL);
        this.preprocessor = new PreProcessor();
    }

    @Override
    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Interference Dependence [" + this.getClass() + "] processing");
        }
        if (this.tgi.getCreationSites().isEmpty()) {
            this.stable();
            return;
        }
        for (Object _o : this.dependent2dependee.keySet()) {
            if (this.dependee2dependent.get(_o) == null) continue;
            Map _dtMap = (Map)this.dependent2dependee.get(_o);
            Map _deMap = (Map)this.dependee2dependent.get(_o);
            for (Pair _dt : _dtMap.keySet()) {
                for (Pair _de : _deMap.keySet()) {
                    if (!this.isDependentOn((Pair<AssignStmt, SootMethod>)_dt, (Pair<AssignStmt, SootMethod>)_de)) continue;
                    MapUtils.putIntoCollectionInMap((Map)_dtMap, (Object)_dt, (Object)_de);
                    MapUtils.putIntoCollectionInMap((Map)_deMap, (Object)_de, (Object)_dt);
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("analyze() - " + this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Interference Dependence processing");
        }
        this.stable();
    }

    @Override
    public Collection<Pair<AssignStmt, SootMethod>> getDependees(AssignStmt stmt, SootMethod method) {
        Collection _result = Collections.emptySet();
        Map _pair2set = null;
        Type _dependent = null;
        if (stmt.containsArrayRef()) {
            _dependent = stmt.getArrayRef().getBase().getType();
        } else if (stmt.containsFieldRef()) {
            _dependent = stmt.getFieldRef().getField();
        }
        if (_dependent != null) {
            _pair2set = MapUtils.queryMap((Map)this.dependent2dependee, (Object)_dependent);
            Collection _set = MapUtils.queryCollection((Map)_pair2set, (Object)this.pairMgr.getPair((Object)stmt, (Object)method));
            _result = Collections.unmodifiableCollection(_set);
        }
        return _result;
    }

    @Override
    public Collection<Pair<AssignStmt, SootMethod>> getDependents(AssignStmt stmt, SootMethod method) {
        Collection _result = Collections.emptyList();
        Map _pair2set = null;
        Type _dependee = null;
        if (stmt.containsArrayRef()) {
            _dependee = stmt.getArrayRef().getBase().getType();
        } else if (stmt.containsFieldRef()) {
            _dependee = stmt.getFieldRef().getField();
        }
        if (_dependee != null) {
            _pair2set = MapUtils.queryMap((Map)this.dependee2dependent, (Object)_dependee);
            Collection _set = MapUtils.queryCollection((Map)_pair2set, (Object)this.pairMgr.getPair((Object)stmt, (Object)method));
            _result = Collections.unmodifiableCollection(_set);
        }
        return _result;
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.INTERFERENCE_DA);
    }

    @Override
    public void reset() {
        super.reset();
    }

    public final void setUseOFA(boolean flag) {
        this.useOFA = flag;
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("Statistics for Interference dependence as calculated by " + this.getClass().getName() + "\n");
        int _lEdgeCount = 0;
        int _edgeCount = 0;
        StringBuffer _temp = new StringBuffer();
        ArrayList _entrySet = new ArrayList(this.dependent2dependee.entrySet());
        Collections.sort(_entrySet, ToStringBasedComparator.getComparator());
        for (Map.Entry _entry : _entrySet) {
            _lEdgeCount = 0;
            for (Map.Entry _entry2 : ((Map)_entry.getValue()).entrySet()) {
                Collection _collection = (Collection)_entry2.getValue();
                if (_collection == null) continue;
                Iterator _k = _collection.iterator();
                while (_k.hasNext()) {
                    _temp.append("\t\t" + _entry2.getKey() + " --> " + _k.next() + "\n");
                }
                _lEdgeCount += _collection.size();
            }
            _result.append("\tFor " + _entry.getKey() + " there are " + _lEdgeCount + " Interference dependence edges.\n");
            _result.append(_temp);
            _temp.delete(0, _temp.length());
            _edgeCount += _lEdgeCount;
        }
        _result.append("A total of " + _edgeCount + " Interference dependence edges exist.");
        return _result.toString();
    }

    @Override
    protected IDependenceRetriever<AssignStmt, SootMethod, Pair<AssignStmt, SootMethod>, AssignStmt, SootMethod, Pair<AssignStmt, SootMethod>> getDependenceRetriever() {
        return new PairRetriever<AssignStmt, SootMethod, AssignStmt, AssignStmt, SootMethod, AssignStmt>();
    }

    protected boolean isArrayDependentOn(Pair<AssignStmt, SootMethod> dependent, Pair<AssignStmt, SootMethod> dependee, ArrayRef dependentArrayRef, ArrayRef dependeeArrayRef) {
        Type _t2;
        Type _t1 = dependeeArrayRef.getBase().getType();
        boolean _result = _t1.equals(_t2 = dependentArrayRef.getBase().getType());
        if (_result && this.useOFA) {
            _result = this.isArrayDependentOnByOFA(dependent, dependee);
        }
        return _result;
    }

    protected boolean isInstanceFieldDependentOn(Pair<AssignStmt, SootMethod> dependent, Pair<AssignStmt, SootMethod> dependee, InstanceFieldRef dependentFieldRef, InstanceFieldRef dependeeFieldRef) {
        boolean _result;
        SootField _ifr2 = dependentFieldRef.getField();
        boolean bl = _result = dependeeFieldRef.getField().equals(_ifr2) && !_ifr2.isFinal();
        if (_result && this.useOFA) {
            _result = this.isFieldDependentOnByOFA(dependent, dependee);
        }
        return _result;
    }

    protected boolean isStaticFieldDependentOn(Pair<AssignStmt, SootMethod> dependent, Pair<AssignStmt, SootMethod> dependee, StaticFieldRef dependentFieldRef, StaticFieldRef dependeeFieldRef) {
        boolean _result;
        SootField _field = dependeeFieldRef.getField();
        boolean bl = _result = dependentFieldRef.getField().equals(_field) && !_field.isFinal();
        if (_result) {
            SootMethod _deeMethod = (SootMethod)dependee.getSecond();
            String _name = _deeMethod.getName();
            _result = !_name.equals("<clinit>") || !_field.getDeclaringClass().equals(_deeMethod.getDeclaringClass());
        }
        return _result;
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.ofa = (OFAnalyzer)this.info.get(IValueAnalyzer.ID);
        if (this.useOFA && this.ofa == null) {
            throw new InitializationException(IValueAnalyzer.ID + " was not provided in the info.");
        }
        this.pairMgr = (Pair.PairManager)this.info.get(Pair.PairManager.ID);
        if (this.pairMgr == null) {
            throw new InitializationException(Pair.PairManager.ID + " was not provided in info.");
        }
        this.tgi = (IThreadGraphInfo)this.info.get(IThreadGraphInfo.ID);
        if (this.tgi == null) {
            throw new InitializationException(IThreadGraphInfo.ID + " was not provided in info.");
        }
    }

    private boolean isArrayDependentOnByOFA(Pair<AssignStmt, SootMethod> dependent, Pair<AssignStmt, SootMethod> dependee) {
        ArrayRef _ifr1 = (ArrayRef)((AssignStmt)dependee.getFirst()).getLeftOp();
        ArrayRef _ifr2 = (ArrayRef)((AssignStmt)dependent.getFirst()).getRightOp();
        AllocationContext _context = new AllocationContext();
        _context.setProgramPoint(_ifr1.getBaseBox());
        _context.setStmt((Stmt)dependee.getFirst());
        _context.setRootMethod((SootMethod)dependee.getSecond());
        Collection<Value> _c1 = this.ofa.getValues(_ifr1.getBase(), _context);
        _context.setProgramPoint(_ifr2.getBaseBox());
        _context.setStmt((Stmt)dependent.getFirst());
        _context.setRootMethod((SootMethod)dependent.getSecond());
        Collection<Value> _c2 = this.ofa.getValues(_ifr2.getBase(), _context);
        Collection _temp = SetUtils.intersection(_c1, _c2);
        while (_temp.remove(NullConstant.v())) {
        }
        boolean _result = !_temp.isEmpty();
        return _result;
    }

    private boolean isDependentOn(Pair<AssignStmt, SootMethod> dependent, Pair<AssignStmt, SootMethod> dependee) {
        SootMethod _dtMethod;
        boolean _result;
        SootMethod _deMethod = (SootMethod)dependee.getSecond();
        boolean bl = _result = !this.tgi.mustOccurInSameThread(_deMethod, _dtMethod = (SootMethod)dependent.getSecond());
        if (_result) {
            Value _de = ((AssignStmt)dependee.getFirst()).getLeftOp();
            Value _dt = ((AssignStmt)dependent.getFirst()).getRightOp();
            if (_de instanceof ArrayRef && _dt instanceof ArrayRef) {
                _result = this.isArrayDependentOn(dependent, dependee, (ArrayRef)_dt, (ArrayRef)_de);
            } else if (_dt instanceof InstanceFieldRef && _de instanceof InstanceFieldRef) {
                _result = this.isInstanceFieldDependentOn(dependent, dependee, (InstanceFieldRef)_dt, (InstanceFieldRef)_de);
            } else if (_dt instanceof StaticFieldRef && _de instanceof StaticFieldRef) {
                _result = this.isStaticFieldDependentOn(dependent, dependee, (StaticFieldRef)_dt, (StaticFieldRef)_de);
            }
        }
        return _result;
    }

    private boolean isFieldDependentOnByOFA(Pair<AssignStmt, SootMethod> dependent, Pair<AssignStmt, SootMethod> dependee) {
        InstanceFieldRef _ifr1 = (InstanceFieldRef)((AssignStmt)dependee.getFirst()).getLeftOp();
        InstanceFieldRef _ifr2 = (InstanceFieldRef)((AssignStmt)dependent.getFirst()).getRightOp();
        AllocationContext _context = new AllocationContext();
        _context.setProgramPoint(_ifr1.getBaseBox());
        _context.setStmt((Stmt)dependee.getFirst());
        _context.setRootMethod((SootMethod)dependee.getSecond());
        Collection<Value> _c1 = this.ofa.getValues(_ifr1.getBase(), _context);
        _context.setProgramPoint(_ifr2.getBaseBox());
        _context.setStmt((Stmt)dependent.getFirst());
        _context.setRootMethod((SootMethod)dependent.getSecond());
        Collection<Value> _c2 = this.ofa.getValues(_ifr2.getBase(), _context);
        Collection _temp = SetUtils.intersection(_c1, _c2);
        while (_temp.remove(NullConstant.v())) {
        }
        boolean _result = !_temp.isEmpty();
        return _result;
    }

    private class PreProcessor
    extends AbstractProcessor {
        private PreProcessor() {
        }

        public void callback(Stmt stmt, Context context) {
            AssignStmt _as = (AssignStmt)stmt;
            Map _temp = null;
            if (_as.containsFieldRef()) {
                if (_as.getLeftOp() instanceof FieldRef) {
                    SootField _sf = ((FieldRef)_as.getLeftOp()).getField();
                    _temp = MapUtils.getMapFromMap((Map)InterferenceDAv1.this.dependee2dependent, (Object)_sf);
                } else {
                    SootField _sf = ((FieldRef)_as.getRightOp()).getField();
                    _temp = MapUtils.getMapFromMap((Map)InterferenceDAv1.this.dependent2dependee, (Object)_sf);
                }
            } else if (_as.containsArrayRef()) {
                if (_as.getLeftOp() instanceof ArrayRef) {
                    ArrayType _at = (ArrayType)((ArrayRef)_as.getLeftOp()).getBase().getType();
                    _temp = MapUtils.getMapFromMap((Map)InterferenceDAv1.this.dependee2dependent, (Object)_at);
                } else {
                    ArrayType _at = (ArrayType)((ArrayRef)_as.getRightOp()).getBase().getType();
                    _temp = MapUtils.getMapFromMap((Map)InterferenceDAv1.this.dependent2dependee, (Object)_at);
                }
            }
            if (_temp != null) {
                _temp.put(InterferenceDAv1.this.pairMgr.getPair((Object)_as, (Object)context.getCurrentMethod()), null);
            }
        }

        public void hookup(ProcessingController ppc) {
            if (InterferenceDAv1.this.tgi == null) {
                throw new IllegalStateException("Please setup the enclosing analysis before starting preprocessing.");
            }
            if (!InterferenceDAv1.this.tgi.getCreationSites().isEmpty()) {
                ppc.register(AssignStmt.class, (IProcessor)this);
            }
        }

        public void unhook(ProcessingController ppc) {
            if (InterferenceDAv1.this.tgi == null) {
                throw new IllegalStateException("Please setup the enclosing analysis before starting preprocessing.");
            }
            if (!InterferenceDAv1.this.tgi.getCreationSites().isEmpty()) {
                ppc.unregister(AssignStmt.class, (IProcessor)this);
            }
        }
    }
}

