/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.ListUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.FIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.StmtRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.BackwardDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.ForwardDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.IDirectionSensitiveInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InterProceduralDivergenceDA
extends AbstractDependencyAnalysis<Stmt, SootMethod, Stmt, SootMethod, List<Collection<Stmt>>, Stmt, SootMethod, Stmt, SootMethod, Map<Stmt, Collection<Stmt>>> {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(InterProceduralDivergenceDA.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(InterProceduralDivergenceDA.class);
    private ICallGraphInfo callgraph;
    private final IDirectionSensitiveInfo directionSensInfo;

    private InterProceduralDivergenceDA(IDirectionSensitiveInfo directionSensitiveInfo, IDependencyAnalysis.Direction direction) {
        super(direction);
        this.directionSensInfo = directionSensitiveInfo;
    }

    public static InterProceduralDivergenceDA getDivergenceDA(IDependencyAnalysis.Direction direction) {
        InterProceduralDivergenceDA _result;
        if (direction.equals((Object)IDependencyAnalysis.Direction.FORWARD_DIRECTION)) {
            _result = new InterProceduralDivergenceDA(new ForwardDirectionSensitiveInfo(), direction);
        } else if (direction.equals((Object)IDependencyAnalysis.Direction.BACKWARD_DIRECTION)) {
            _result = new InterProceduralDivergenceDA(new BackwardDirectionSensitiveInfo(), direction);
        } else {
            String _msg = "Argument should be either 'IDependencyAnalysis.FORWARD_DIRECTION' or 'IDependencyAnalysis.BACKWARD_DIRECTION'. Provided argument was " + direction.toString();
            LOGGER.error("getForwardDivergenceDA()");
            throw new IllegalArgumentException(_msg);
        }
        return _result;
    }

    @Override
    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Divergence Dependence processing");
        }
        HashMap<SootMethod, Collection<Stmt>> _method2preDivPoints = new HashMap<SootMethod, Collection<Stmt>>();
        this.findDivergencePoints(_method2preDivPoints);
        for (Map.Entry _entry : _method2preDivPoints.entrySet()) {
            SootMethod _method = (SootMethod)_entry.getKey();
            Collection _divergentStmts = (Collection)_entry.getValue();
            Collection<BasicBlockGraph.BasicBlock> _succsOfDivergentBBs = this.calculateIntraBBDependence(_method, _divergentStmts);
            this.calculateInterBBDependence(_method, _succsOfDivergentBBs, _divergentStmts);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Divergence Dependence processing");
        }
        this.stable();
    }

    @Override
    public Collection<Stmt> getDependees(Stmt dependentStmt, SootMethod method) {
        int _indexOf;
        Collection _result = Collections.emptyList();
        List _list = (List)this.dependent2dependee.get(method);
        if (_list != null && (_indexOf = this.getStmtList(method).indexOf(dependentStmt)) > -1) {
            _result = (Collection)ListUtils.getAtIndexFromList((List)_list, (int)_indexOf, (Object)Collections.emptyList());
        }
        return _result;
    }

    @Override
    public Collection<Stmt> getDependents(Stmt dependeeStmt, SootMethod method) {
        Map _stmt2List = MapUtils.getEmptyMapFromMap((Map)this.dependee2dependent, (Object)method);
        Collection _result = MapUtils.queryCollection((Map)_stmt2List, (Object)dependeeStmt);
        return Collections.unmodifiableCollection(_result);
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.DIVERGENCE_DA);
    }

    @Override
    public void reset() {
        super.reset();
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("Statistics for divergence dependence as calculated by " + this.getClass().getName() + "[" + this.hashCode() + "]\n");
        int _localEdgeCount = 0;
        int _edgeCount = 0;
        StringBuffer _temp = new StringBuffer();
        for (Map.Entry _entry : this.dependent2dependee.entrySet()) {
            SootMethod _method = (SootMethod)_entry.getKey();
            _localEdgeCount = 0;
            List<Stmt> _stmts = this.getStmtList(_method);
            List _dependees = (List)_entry.getValue();
            int _j = 0;
            while (_j < _stmts.size()) {
                Collection _c = (Collection)_dependees.get(_j);
                if (_c != null) {
                    _temp.append("\t\t" + _stmts.get(_j) + " --> " + _c + "\n");
                    _localEdgeCount += _c.size();
                }
                ++_j;
            }
            _result.append("\tFor " + _method + " there are " + _localEdgeCount + " divergence dependence edges.\n");
            _result.append(_temp);
            _temp.delete(0, _temp.length());
            _edgeCount += _localEdgeCount;
        }
        _result.append("A total of " + _edgeCount + " divergence dependence edges exist.");
        return _result.toString();
    }

    @Override
    protected IDependenceRetriever<Stmt, SootMethod, Stmt, Stmt, SootMethod, Stmt> getDependenceRetriever() {
        return new StmtRetriever();
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.callgraph == null) {
            throw new InitializationException(ICallGraphInfo.ID + " was not provided.");
        }
    }

    private void calculateInterBBDependence(SootMethod method, Collection<BasicBlockGraph.BasicBlock> succsOfDivergentBBs, Collection<Stmt> divergentStmts) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Processing method " + method + " with divergent blocks: " + succsOfDivergentBBs);
        }
        List<Stmt> _sl = this.getStmtList(method);
        FIFOWorkBag _wb = new FIFOWorkBag();
        HashSet<Stmt> _dents = new HashSet<Stmt>();
        _wb.addAllWork(succsOfDivergentBBs);
        while (_wb.hasWork()) {
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_wb.getWork();
            Stmt _firstStmt = this.directionSensInfo.getFirstStmtInBB(_bb);
            int _firstStmtIndex = _sl.indexOf(_firstStmt);
            Collection _dees = (Collection)((List)this.dependent2dependee.get(method)).get(_firstStmtIndex);
            _dents.clear();
            if (!divergentStmts.contains(_firstStmt)) {
                Collection<Stmt> _bbStmts = this.directionSensInfo.getIntraBBDependents(_bb, _firstStmt);
                for (Stmt _stmt : _bbStmts) {
                    _dents.add(_stmt);
                    if (divergentStmts.contains(_stmt)) break;
                }
            }
            if (!succsOfDivergentBBs.contains(_bb)) {
                Collection<BasicBlockGraph.BasicBlock> _succs = this.recordDepAcrossBB(method, divergentStmts, _dees, _dents, this.directionSensInfo.getFollowersOfBB(_bb));
                _wb.addAllWorkNoDuplicates(_succs);
                continue;
            }
            this.recordDependenceInfoInBB(_dees, method, _dents);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Processing method " + method);
        }
    }

    private Collection<BasicBlockGraph.BasicBlock> calculateIntraBBDependence(SootMethod method, Collection<Stmt> divergencePoints) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Processing method " + method + " with divergent points: " + divergencePoints);
        }
        HashSet<BasicBlockGraph.BasicBlock> _result = new HashSet<BasicBlockGraph.BasicBlock>();
        List<Stmt> _sl = this.getStmtList(method);
        HashSet<Stmt> _dependents = new HashSet<Stmt>();
        BasicBlockGraph _bbg = this.getBasicBlockGraph(method);
        List _dees = MapUtils.getListFromMap((Map)this.dependent2dependee, (Object)method);
        ListUtils.ensureSize((List)_dees, (int)_sl.size(), null);
        for (Stmt _divPoint2 : divergencePoints) {
            BasicBlockGraph.BasicBlock _bb = _bbg.getEnclosingBlock(_divPoint2);
            for (Stmt _divPoint2 : _bb.getStmtsOf()) {
                if (divergencePoints.contains(_divPoint2)) break;
            }
            _dependents.clear();
            Collection<Stmt> _bbStmts = this.directionSensInfo.getIntraBBDependents(_bb, _divPoint2);
            for (Stmt _stmt : _bbStmts) {
                _dependents.add(_stmt);
                if (!divergencePoints.contains(_stmt)) continue;
                this.recordDependenceInfoInBB((Collection<Stmt>)Collections.singleton(_divPoint2), method, _dependents);
                _divPoint2 = _stmt;
                _dependents.clear();
            }
            Collection<BasicBlockGraph.BasicBlock> _temp = this.recordDepAcrossBB(method, divergencePoints, (Collection<Stmt>)Collections.singleton(_divPoint2), _dependents, _bb.getSuccsOf());
            _result.addAll(_temp);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Processing method " + method);
        }
        return _result;
    }

    private void findDivergencePoints(Map<SootMethod, Collection<Stmt>> method2divPoints) {
        Collection<SootMethod> _temp = this.findDivergentMethods();
        HistoryAwareLIFOWorkBag _divMethods = new HistoryAwareLIFOWorkBag(new HashSet());
        _divMethods.addAllWork(_temp);
        while (_divMethods.hasWork()) {
            SootMethod _callee = (SootMethod)_divMethods.getWork();
            for (ICallGraphInfo.CallTriple _ctrp : this.callgraph.getCallers(_callee)) {
                SootMethod _caller = _ctrp.getMethod();
                Collection _c = MapUtils.getCollectionFromMap(method2divPoints, (Object)_caller);
                Stmt _stmt = _ctrp.getStmt();
                _c.add(_stmt);
                _divMethods.addWork((Object)_caller);
            }
        }
    }

    private Collection<SootMethod> findDivergentMethods() {
        ArrayList<SootMethod> _result = new ArrayList<SootMethod>();
        for (SootMethod _method : this.callgraph.getReachableMethods()) {
            BasicBlockGraph _bbg = this.getBasicBlockGraph(_method);
            Collection _sccs = _bbg.getSCCs(true);
            boolean _doesNotContainLoops = true;
            Iterator _j = _sccs.iterator();
            while (_j.hasNext() && _doesNotContainLoops) {
                List _scc = (List)_j.next();
                BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_scc.iterator().next();
                boolean bl = _doesNotContainLoops = _scc.size() == 1 && !_bb.getSuccsOf().contains(_bb);
            }
            if (_doesNotContainLoops) continue;
            _result.add(_method);
        }
        return _result;
    }

    private Collection<BasicBlockGraph.BasicBlock> recordDepAcrossBB(SootMethod method, Collection<Stmt> preDivPoints, Collection<Stmt> dependees, Collection<Stmt> dependents, Collection<BasicBlockGraph.BasicBlock> succs) {
        ArrayList<BasicBlockGraph.BasicBlock> _result = new ArrayList<BasicBlockGraph.BasicBlock>();
        for (BasicBlockGraph.BasicBlock _succ : succs) {
            Stmt _firstStmt = this.directionSensInfo.getFirstStmtInBB(_succ);
            dependents.add(_firstStmt);
            if (preDivPoints.contains(_firstStmt)) continue;
            _result.add(_succ);
        }
        this.recordDependenceInfoInBB(dependees, method, dependents);
        return _result;
    }

    private void recordDependenceInfoInBB(Collection<Stmt> dependees, SootMethod method, Collection<Stmt> dependents) {
        List _de = (List)this.dependent2dependee.get(method);
        List<Stmt> _sl = this.getStmtList(method);
        for (Stmt _dependent : dependents) {
            Collection _dees = (Collection)ListUtils.getAtIndexFromListUsingFactory((List)_de, (int)_sl.indexOf(_dependent), (IFactory)ListUtils.getFactory());
            _dees.addAll(dependees);
        }
        Map _stmt2List = MapUtils.getMapFromMap((Map)this.dependee2dependent, (Object)method);
        for (Stmt _dependee : dependees) {
            Collection _dents = MapUtils.getCollectionFromMap((Map)_stmt2List, (Object)_dependee);
            _dents.addAll(dependents);
        }
    }
}

