/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.annotations.Empty;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareFIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.Constants;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import soot.SootMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IndirectDependenceAnalysis<T1, C1, E1, KE, VT, E2, C2, T2, KT, VE>
implements IDependencyAnalysis<T1, C1, E1, E2, C2, T2> {
    private final IDependencyAnalysis<T1, C1, E1, E2, C2, T2> da;
    private final Map<Pair<E2, C2>, Collection<T2>> dependee2dependent = new HashMap<Pair<E2, C2>, Collection<T2>>(Constants.getNumOfMethodsInApplication());
    private final Map<Pair<T1, C1>, Collection<E1>> dependent2dependee = new HashMap<Pair<T1, C1>, Collection<E1>>(Constants.getNumOfMethodsInApplication());
    private final IDependenceRetriever<T1, C1, E1, E2, C2, T2> retriever;

    IndirectDependenceAnalysis(IDependencyAnalysis<T1, C1, E1, E2, C2, T2> dependenceAnalysis, IDependenceRetriever<T1, C1, E1, E2, C2, T2> daRetriever) {
        this.da = dependenceAnalysis;
        this.retriever = daRetriever;
    }

    @Override
    @Empty
    public void analyze() {
    }

    @Override
    @Empty
    public boolean doesPreProcessing() {
        return false;
    }

    @Override
    public Collection<E1> getDependees(T1 dependent, C1 context) {
        Pair _key = new Pair(dependent, context);
        Collection<E1> _result = this.dependent2dependee.get(_key);
        if (_result == null) {
            _result = new ArrayList<E1>();
            ArrayList _processed = new ArrayList();
            HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_processed);
            Collection<E1> _dependees = this.da.getDependees(dependent, context);
            _result.addAll(_dependees);
            _wb.addAllWork(this.retriever.convertToConformantDependents(_dependees, dependent, context));
            while (_wb.hasWork()) {
                Pair _work = (Pair)_wb.getWork();
                Collection<E1> _dependees2 = this.retriever.getDependees(this.da, _work.getFirst(), _work.getSecond());
                _result.addAll(_dependees);
                _wb.addAllWork(this.retriever.convertToConformantDependents(_dependees2, _work.getFirst(), _work.getSecond()));
            }
            this.dependent2dependee.put(_key, _result);
        }
        return Collections.unmodifiableCollection(_result);
    }

    @Override
    public Collection<T2> getDependents(E2 dependee, C2 context) {
        Pair _key = new Pair(dependee, context);
        Collection<T2> _result = this.dependee2dependent.get(_key);
        if (_result == null) {
            _result = new ArrayList<T2>();
            ArrayList _processed = new ArrayList();
            HistoryAwareFIFOWorkBag _wb = new HistoryAwareFIFOWorkBag(_processed);
            Collection<T2> _dependents = this.da.getDependents(dependee, context);
            _result.addAll(_dependents);
            _wb.addAllWork(this.retriever.convertToConformantDependees(_dependents, dependee, context));
            while (_wb.hasWork()) {
                Pair _work = (Pair)_wb.getWork();
                Collection<T2> _dependents2 = this.retriever.getDependents(this.da, _work.getFirst(), _work.getSecond());
                _result.addAll(_dependents2);
                _wb.addAllWork(this.retriever.convertToConformantDependees(_dependents2, _work.getFirst(), _work.getSecond()));
            }
            this.dependee2dependent.put(_key, _result);
        }
        return Collections.unmodifiableCollection(_result);
    }

    @Override
    public IDependencyAnalysis.Direction getDirection() {
        return this.da.getDirection();
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return this.da.getIds();
    }

    @Override
    public IDependencyAnalysis<T1, C1, E1, E2, C2, T2> getIndirectVersionOfDependence() {
        return this;
    }

    @Override
    @Empty
    public IProcessor getPreProcessor() {
        return null;
    }

    @Override
    @Empty
    public void initialize(Map<Comparable<?>, Object> infoParam) throws InitializationException {
    }

    @Override
    public boolean isStable() {
        return this.da.isStable();
    }

    @Override
    public void reset() {
        this.dependee2dependent.clear();
        this.dependent2dependee.clear();
    }

    @Override
    @Empty
    public void setBasicBlockGraphManager(BasicBlockGraphMgr bbm) {
    }

    public String toString(Collection<SootMethod> methods) {
        return "Statistics for indirect dependence as calculated by " + this.getClass().getName() + "\n" + MapUtils.verbosePrint(this.dependee2dependent);
    }
}

