/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.cfg.LocalUseDefAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.LocalStmtPairRetriever;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierBasedDataDAv2
extends AbstractDependencyAnalysis<Pair<Local, Stmt>, SootMethod, DefinitionStmt, SootMethod, IUseDefInfo<DefinitionStmt, Pair<Local, Stmt>>, DefinitionStmt, SootMethod, Pair<Local, Stmt>, SootMethod, IUseDefInfo<DefinitionStmt, Pair<Local, Stmt>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierBasedDataDAv2.class);
    private ICallGraphInfo callgraph;

    public IdentifierBasedDataDAv2() {
        super(IDependencyAnalysis.Direction.BI_DIRECTIONAL);
    }

    @Override
    public final void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Identifier Based Data Dependence processing");
        }
        for (SootMethod _currMethod : this.callgraph.getReachableMethods()) {
            UnitGraph _unitGraph = this.getUnitGraph(_currMethod);
            if (_unitGraph != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Processing " + _currMethod.getSignature());
                }
                IUseDefInfo<DefinitionStmt, Pair<Local, Stmt>> _useDef = this.getLocalUseDefAnalysis(_currMethod);
                this.dependee2dependent.put(_currMethod, _useDef);
                this.dependent2dependee.put(_currMethod, _useDef);
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("Method " + _currMethod.getSignature() + " does not have a unit graph.");
        }
        this.stable();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("analyze() - " + this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END:  Identifier Based Data Dependence processing");
        }
    }

    @Override
    public final Collection<DefinitionStmt> getDependees(Pair<Local, Stmt> programPoint, SootMethod method) {
        Collection _result = Collections.emptyList();
        if (programPoint != null) {
            IUseDefInfo _useDefAnalysis = (IUseDefInfo)this.dependee2dependent.get(method);
            if (_useDefAnalysis != null) {
                Stmt _stmt = (Stmt)programPoint.getSecond();
                Local _local = (Local)programPoint.getFirst();
                _result = _useDefAnalysis.getDefs(_local, _stmt, method);
            } else if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("getDependees(programPoint = " + programPoint + ", method = " + method + ") - No dependents found for ");
            }
        }
        return _result;
    }

    @Override
    public Collection<DefinitionStmt> getDependees(Stmt stmt, SootMethod method) {
        Collection _result = Collections.emptyList();
        IUseDefInfo _useDefAnalysis = (IUseDefInfo)this.dependee2dependent.get(method);
        if (_useDefAnalysis != null) {
            _result = _useDefAnalysis.getDefs(stmt, method);
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("getDependees(stmt = " + stmt + ", method = " + method + ") - No dependents found for ");
        }
        return _result;
    }

    @Override
    public final Collection<Pair<Local, Stmt>> getDependents(DefinitionStmt programPoint, SootMethod method) {
        IUseDefInfo _useDefAnalysis = (IUseDefInfo)this.dependee2dependent.get(method);
        Collection _result = Collections.emptyList();
        if (_useDefAnalysis != null) {
            _result = _useDefAnalysis.getUses(programPoint, method);
        }
        return _result;
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA);
    }

    public final String toString() {
        StringBuffer _result = new StringBuffer("Statistics for Identifier-based Data dependence as calculated by " + this.getClass().getName() + "\n");
        int _localEdgeCount = 0;
        int _edgeCount = 0;
        StringBuffer _temp = new StringBuffer();
        for (Map.Entry _entry : this.dependee2dependent.entrySet()) {
            _localEdgeCount = 0;
            IUseDefInfo _useDef = (IUseDefInfo)_entry.getValue();
            SootMethod _sm = (SootMethod)_entry.getKey();
            if (_sm.hasActiveBody()) {
                for (Stmt _stmt : this.getStmtList(_sm)) {
                    if (!(_stmt instanceof DefinitionStmt)) continue;
                    Collection _uses = _useDef.getUses((DefinitionStmt)_stmt, _sm);
                    Iterator _k = _uses.iterator();
                    while (_k.hasNext()) {
                        _temp.append("\t\t" + _stmt + " <-- " + _k.next() + "\n");
                    }
                    _localEdgeCount += _uses.size();
                }
            }
            _result.append("\tFor " + _sm + " there are " + _localEdgeCount + " Identifier-based Data dependence edges.\n");
            _result.append(_temp);
            _temp.delete(0, _temp.length());
            _edgeCount += _localEdgeCount;
        }
        _result.append("A total of " + _edgeCount + " Identifier-based Data dependence edges exist.");
        return _result.toString();
    }

    @Override
    protected IDependenceRetriever<Pair<Local, Stmt>, SootMethod, DefinitionStmt, DefinitionStmt, SootMethod, Pair<Local, Stmt>> getDependenceRetriever() {
        return new LocalStmtPairRetriever();
    }

    protected IUseDefInfo<DefinitionStmt, Pair<Local, Stmt>> getLocalUseDefAnalysis(SootMethod method) {
        return new LocalUseDefAnalysis(this.getUnitGraph(method));
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.callgraph == null) {
            throw new InitializationException(ICallGraphInfo.ID + " was not provided.");
        }
    }
}

