/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.LocalStmtPairRetriever;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Local;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierBasedDataDA
extends AbstractDependencyAnalysis<Pair<Local, Stmt>, SootMethod, DefinitionStmt, SootMethod, List<Map<Local, Collection<DefinitionStmt>>>, DefinitionStmt, SootMethod, Pair<Local, Stmt>, SootMethod, List<Collection<Pair<Local, Stmt>>>> {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(IdentifierBasedDataDA.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierBasedDataDA.class);
    private ICallGraphInfo callgraph;

    public IdentifierBasedDataDA() {
        super(IDependencyAnalysis.Direction.BI_DIRECTIONAL);
    }

    static final Collection<DefinitionStmt> getDependeesHelper(Stmt stmt, SootMethod method, IDependencyAnalysis<Pair<Local, Stmt>, SootMethod, DefinitionStmt, ?, ?, ?> da) {
        Collection<DefinitionStmt> _result = Collections.emptySet();
        for (ValueBox _vb : stmt.getUseBoxes()) {
            Value _v = _vb.getValue();
            if (!(_v instanceof Local)) continue;
            Collection<DefinitionStmt> _c = da.getDependees((Pair<Local, Stmt>)new Pair((Object)((Local)_v), (Object)stmt), method);
            if (_c != null) {
                _result = Collections.unmodifiableCollection(_c);
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("No dependence information available for " + stmt + " in " + method);
        }
        return _result;
    }

    @Override
    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Identifier Based Data Dependence processing");
        }
        for (SootMethod _currMethod : this.callgraph.getReachableMethods()) {
            UnitGraph _unitGraph = this.getUnitGraph(_currMethod);
            if (_unitGraph == null) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("Method " + _currMethod.getSignature() + " does not have a unit graph.");
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Processing " + _currMethod.getSignature());
            }
            this.calculateDAForMethod(_currMethod, _unitGraph);
        }
        this.stable();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("analyze() - " + this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END:  Identifier Based Data Dependence processing");
        }
    }

    @Override
    public Collection<DefinitionStmt> getDependees(Pair<Local, Stmt> programPoint, SootMethod method) {
        Collection _result = Collections.emptySet();
        if (programPoint != null) {
            Stmt _stmt = (Stmt)programPoint.getSecond();
            Local _local = (Local)programPoint.getFirst();
            List _dependees = (List)this.dependent2dependee.get(method);
            if (_dependees != null) {
                Map _local2defs = (Map)_dependees.get(this.getStmtList(method).indexOf(_stmt));
                Collection _c = (Collection)_local2defs.get(_local);
                if (_c != null) {
                    _result = Collections.unmodifiableCollection(_c);
                } else if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("No dependence information available for " + programPoint + " in " + method);
                }
            }
        }
        return _result;
    }

    @Override
    public Collection<DefinitionStmt> getDependees(Stmt stmt, SootMethod method) {
        return IdentifierBasedDataDA.getDependeesHelper(stmt, method, this);
    }

    @Override
    public Collection<Pair<Local, Stmt>> getDependents(DefinitionStmt programPoint, SootMethod method) {
        Collection _temp;
        Collection _result = Collections.emptySet();
        List _dependents = (List)this.dependee2dependent.get(method);
        if (_dependents != null && (_temp = (Collection)_dependents.get(this.getStmtList(method).indexOf(programPoint))) != null) {
            _result = Collections.unmodifiableCollection(_temp);
        }
        return _result;
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.IDENTIFIER_BASED_DATA_DA);
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("Statistics for Identifier-based Data dependence as calculated by " + this.getClass().getName() + "\n");
        int _localEdgeCount = 0;
        int _edgeCount = 0;
        StringBuffer _temp = new StringBuffer();
        for (Map.Entry _entry : this.dependee2dependent.entrySet()) {
            _localEdgeCount = 0;
            List<Stmt> _stmts = this.getStmtList((SootMethod)_entry.getKey());
            int _count = 0;
            for (Collection _c : (List)_entry.getValue()) {
                Stmt _stmt = _stmts.get(_count++);
                Iterator _k = _c.iterator();
                while (_k.hasNext()) {
                    _temp.append("\t\t" + _stmt + " <-- " + _k.next() + "\n");
                }
                _localEdgeCount += _c.size();
            }
            _result.append("\tFor " + _entry.getKey() + " there are " + _localEdgeCount + " Identifier-based Data dependence edges.\n");
            _result.append(_temp);
            _temp.delete(0, _temp.length());
            _edgeCount += _localEdgeCount;
        }
        _result.append("A total of " + _edgeCount + " Identifier-based Data dependence edges exist.");
        return _result.toString();
    }

    @Override
    protected IDependenceRetriever<Pair<Local, Stmt>, SootMethod, DefinitionStmt, DefinitionStmt, SootMethod, Pair<Local, Stmt>> getDependenceRetriever() {
        return new LocalStmtPairRetriever();
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.callgraph == null) {
            throw new InitializationException(ICallGraphInfo.ID + " was not provided.");
        }
    }

    private void calculateDAForMethod(SootMethod method, UnitGraph unitGraph) {
        SimpleLocalDefs _defs = new SimpleLocalDefs(unitGraph);
        SimpleLocalUses _uses = new SimpleLocalUses(unitGraph, (LocalDefs)_defs);
        List<Stmt> _t = this.getStmtList(method);
        ArrayList<Map<Local, List>> _dependees = new ArrayList<Map<Local, List>>(_t.size());
        ArrayList _dependents = new ArrayList(_t.size());
        for (Stmt _currStmt : _t) {
            List _temp;
            ArrayList<Pair> _currUses = (ArrayList<Pair>)((Object)Collections.emptySet());
            if (_currStmt instanceof DefinitionStmt && (_temp = _uses.getUsesOf((Unit)_currStmt)).size() != 0) {
                _currUses = new ArrayList<Pair>();
                for (UnitValueBoxPair _p : _temp) {
                    _currUses.add(new Pair((Object)((Local)_p.getValueBox().getValue()), (Object)((Stmt)_p.getUnit())));
                }
            }
            _dependents.add(_currUses);
            Map<Local, List> _currDefs = Collections.emptyMap();
            if (_currStmt.getUseBoxes().size() > 0) {
                _currDefs = new HashMap();
                for (ValueBox _currValueBox : _currStmt.getUseBoxes()) {
                    Value _value = _currValueBox.getValue();
                    if (!(_value instanceof Local) || _currDefs.containsKey(_value)) continue;
                    Local _local = (Local)_value;
                    _currDefs.put(_local, _defs.getDefsOfAt(_local, (Unit)_currStmt));
                }
            }
            _dependees.add(_currDefs);
        }
        this.dependee2dependent.put(method, _dependents);
        this.dependent2dependee.put(method, _dependees);
    }
}

