/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.ListUtils;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.graph.INode;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExitControlDA
extends AbstractControlDA {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(ExitControlDA.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ExitControlDA.class);
    private IDependencyAnalysis<Stmt, SootMethod, Stmt, Stmt, SootMethod, Stmt> entryControlDA;

    public ExitControlDA() {
        super(IDependencyAnalysis.Direction.FORWARD_DIRECTION);
    }

    @Override
    public final void analyze() {
        this.analyze(this.callgraph.getReachableMethods());
    }

    public final void analyze(Collection<SootMethod> methods) {
        this.unstable();
        if (this.entryControlDA.isStable()) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("BEGIN: Exit Control Dependence processing");
            }
            for (SootMethod _sm : methods) {
                BasicBlockGraph _bbg = this.getBasicBlockGraph(_sm);
                Collection<BasicBlockGraph.BasicBlock> _dependeeBBs = this.calculateEntryControlDependeesOfSinksIn(_bbg, _sm);
                if (_dependeeBBs.isEmpty()) continue;
                this.calculateDependenceForStmts(this.calculateDependenceForBBs(_bbg, _dependeeBBs), _sm);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(this.toString());
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("END: Exit Control Dependence processing");
            }
            this.stable();
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Exit Control Dependence processing due to unstable entry control dependence info.");
        }
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        Collection _temp = (Collection)this.info.get((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA);
        if (_temp == null) {
            throw new InitializationException((Object)((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA) + " was not provided or none of the provided control dependences were backward in direction.");
        }
        for (IDependencyAnalysis _da : _temp) {
            if (!_da.getIds().contains((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA) || !_da.getDirection().equals((Object)IDependencyAnalysis.Direction.BACKWARD_DIRECTION) && !_da.getDirection().equals((Object)IDependencyAnalysis.Direction.BI_DIRECTIONAL)) continue;
            this.entryControlDA = _da;
        }
        if (this.entryControlDA == null) {
            throw new InitializationException((Object)((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA) + " with direction " + (Object)((Object)IDependencyAnalysis.Direction.BACKWARD_DIRECTION) + " was not provided or none of the provided control dependences were backward in direction.");
        }
    }

    private Map<BasicBlockGraph.BasicBlock, Collection<BasicBlockGraph.BasicBlock>> calculateDependenceForBBs(BasicBlockGraph bbg, Collection<BasicBlockGraph.BasicBlock> dependeeBBs) {
        HashMap<BasicBlockGraph.BasicBlock, Collection<BasicBlockGraph.BasicBlock>> _dependence = new HashMap<BasicBlockGraph.BasicBlock, Collection<BasicBlockGraph.BasicBlock>>();
        Iterator<BasicBlockGraph.BasicBlock> _i = dependeeBBs.iterator();
        int _iEnd = dependeeBBs.size();
        int _iIndex = 0;
        while (_iIndex < _iEnd) {
            BasicBlockGraph.BasicBlock _dependeeBB = _i.next();
            Collection _dependents = bbg.getReachablesFrom((INode)_dependeeBB, false);
            _dependence.put(_dependeeBB, _dependents);
            ++_iIndex;
        }
        return _dependence;
    }

    private void calculateDependenceForStmts(Map<BasicBlockGraph.BasicBlock, Collection<BasicBlockGraph.BasicBlock>> dependeeBB2dependentBBs, SootMethod method) {
        List _methodLocalDee2Dent = MapUtils.getListFromMap((Map)this.dependee2dependent, (Object)method);
        List _methodLocalDent2Dee = MapUtils.getListFromMap((Map)this.dependent2dependee, (Object)method);
        List<Stmt> _stmtList = this.getStmtList(method);
        int _noOfStmtsInMethod = _stmtList.size();
        ArrayList<Stmt> _dependeeBBStmts = new ArrayList<Stmt>();
        ListUtils.ensureSize((List)_methodLocalDee2Dent, (int)_noOfStmtsInMethod, null);
        ListUtils.ensureSize((List)_methodLocalDent2Dee, (int)_noOfStmtsInMethod, null);
        for (Map.Entry<BasicBlockGraph.BasicBlock, Collection<BasicBlockGraph.BasicBlock>> _entry : dependeeBB2dependentBBs.entrySet()) {
            BasicBlockGraph.BasicBlock _dependeeBB = _entry.getKey();
            Stmt _dependee = _dependeeBB.getTrailerStmt();
            Collection _dependents = (Collection)ListUtils.getAtIndexFromListUsingFactory((List)_methodLocalDee2Dent, (int)_stmtList.indexOf(_dependee), (IFactory)SetUtils.getFactory());
            _dependeeBBStmts.clear();
            _dependeeBBStmts.addAll(_dependeeBB.getStmtsOf());
            _dependeeBBStmts.remove(_dependee);
            _dependents.addAll(_dependeeBBStmts);
            this.recordDependence(_methodLocalDent2Dee, _stmtList, _dependee, _dependeeBBStmts);
            Collection<BasicBlockGraph.BasicBlock> _dependentBBs = _entry.getValue();
            Iterator<BasicBlockGraph.BasicBlock> _j = _dependentBBs.iterator();
            int _jEnd = _dependentBBs.size();
            int _jIndex = 0;
            while (_jIndex < _jEnd) {
                BasicBlockGraph.BasicBlock _dependentBB = _j.next();
                List _dependentBBStmts = _dependentBB.getStmtsOf();
                _dependents.addAll(_dependentBBStmts);
                this.recordDependence(_methodLocalDent2Dee, _stmtList, _dependee, _dependentBBStmts);
                ++_jIndex;
            }
        }
        this.dependent2dependee.put(method, _methodLocalDent2Dee);
        this.dependee2dependent.put(method, _methodLocalDee2Dent);
    }

    private Collection<BasicBlockGraph.BasicBlock> calculateEntryControlDependeesOfSinksIn(BasicBlockGraph bbg, SootMethod method) {
        HashSet<BasicBlockGraph.BasicBlock> _result;
        ArrayList _sinks = new ArrayList();
        _sinks.addAll(bbg.getTails());
        if (_sinks.size() > 1) {
            _result = new HashSet<BasicBlockGraph.BasicBlock>();
            for (BasicBlockGraph.BasicBlock _sink : _sinks) {
                Stmt _stmt = _sink.getLeaderStmt();
                Collection<Stmt> _dependees = this.entryControlDA.getDependees(_stmt, method);
                for (Stmt _dependee : _dependees) {
                    BasicBlockGraph.BasicBlock _dependeeBB = bbg.getEnclosingBlock(_dependee);
                    _result.add(_dependeeBB);
                }
            }
        } else {
            _result = (HashSet<BasicBlockGraph.BasicBlock>)Collections.emptySet();
        }
        return _result;
    }

    private void recordDependence(List<Collection<Stmt>> methodDependent2Dependee, List<Stmt> stmts, Stmt dependee, List<Stmt> dependents) {
        Iterator<Stmt> _k = dependents.iterator();
        int _kEnd = dependents.size();
        int _kIndex = 0;
        while (_kIndex < _kEnd) {
            Stmt _dependent = _k.next();
            Collection _dependees = (Collection)ListUtils.getAtIndexFromListUsingFactory(methodDependent2Dependee, (int)stmts.indexOf(_dependent), (IFactory)SetUtils.getFactory());
            _dependees.add(dependee);
            ++_kIndex;
        }
    }
}

