/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IPredicate;
import edu.ksu.cis.indus.common.collections.InstanceOfPredicate;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.FIFOWorkBag;
import edu.ksu.cis.indus.common.datastructures.HistoryAwareLIFOWorkBag;
import edu.ksu.cis.indus.common.soot.BasicBlockGraph;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.InitializationException;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependenceRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.StmtRetriever;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.BackwardDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.ForwardDirectionSensitiveInfo;
import edu.ksu.cis.indus.staticanalyses.dependency.direction.IDirectionSensitiveInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DivergenceDA
extends AbstractDependencyAnalysis<Stmt, SootMethod, Stmt, SootMethod, Map<Stmt, Collection<Stmt>>, Stmt, SootMethod, Stmt, SootMethod, Map<Stmt, Collection<Stmt>>> {
    public static final IPredicate<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> INSTANCEOF_PREDICATE = new InstanceOfPredicate(DivergenceDA.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(DivergenceDA.class);
    private ICallGraphInfo callgraph;
    private boolean considerCallSites;
    private final IDirectionSensitiveInfo directionSensInfo;
    private final Map<SootMethod, Collection<Stmt>> method2interProcDivPoints = new HashMap<SootMethod, Collection<Stmt>>();

    private DivergenceDA(IDirectionSensitiveInfo directionSensitiveInfo, IDependencyAnalysis.Direction direction) {
        super(direction);
        this.directionSensInfo = directionSensitiveInfo;
    }

    public static DivergenceDA getDivergenceDA(IDependencyAnalysis.Direction direction) {
        DivergenceDA _result;
        if (direction.equals((Object)IDependencyAnalysis.Direction.FORWARD_DIRECTION)) {
            _result = new DivergenceDA(new ForwardDirectionSensitiveInfo(), direction);
        } else if (direction.equals((Object)IDependencyAnalysis.Direction.BACKWARD_DIRECTION)) {
            _result = new DivergenceDA(new BackwardDirectionSensitiveInfo(), direction);
        } else {
            String _msg = "Argument should be either 'IDependencyAnalysis.Direction.FORWARD_DIRECTION' or 'IDependencyAnalysis.Direction.BACKWARD_DIRECTION'. Provided argument was " + direction.toString();
            LOGGER.error("getForwardDivergenceDA()");
            throw new IllegalArgumentException(_msg);
        }
        return _result;
    }

    @Override
    public void analyze() {
        this.unstable();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BEGIN: Divergence Dependence processing");
        }
        HashMap<SootMethod, Collection<Stmt>> _method2preDivPoints = new HashMap<SootMethod, Collection<Stmt>>();
        this.findPreDivPoints(_method2preDivPoints);
        for (Map.Entry _entry : _method2preDivPoints.entrySet()) {
            SootMethod _method = (SootMethod)_entry.getKey();
            Collection _preDivPoints = (Collection)_entry.getValue();
            Collection<BasicBlockGraph.BasicBlock> _succsOfPreDivBBs = this.calculateIntraBBDependence(_method, _preDivPoints);
            this.calculateInterBBDependence(_method, _succsOfPreDivBBs, _preDivPoints);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(this.toString());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("END: Divergence Dependence processing");
        }
        this.stable();
    }

    @Override
    public Collection<Stmt> getDependees(Stmt dependentStmt, SootMethod method) {
        Map _map = MapUtils.queryMap((Map)this.dependent2dependee, (Object)method);
        Collection _queryCollection = MapUtils.queryCollection((Map)_map, (Object)dependentStmt);
        return Collections.unmodifiableCollection(_queryCollection);
    }

    @Override
    public Collection<Stmt> getDependents(Stmt dependeeStmt, SootMethod method) {
        Map _stmt2List = MapUtils.queryMap((Map)this.dependee2dependent, (Object)method);
        Collection _result = MapUtils.queryCollection((Map)_stmt2List, (Object)dependeeStmt);
        return Collections.unmodifiableCollection(_result);
    }

    @Override
    public Collection<IDependencyAnalysis.DependenceSort> getIds() {
        return Collections.singleton(IDependencyAnalysis.DependenceSort.DIVERGENCE_DA);
    }

    @Override
    public void reset() {
        super.reset();
        this.method2interProcDivPoints.clear();
    }

    public void setConsiderCallSites(boolean consider) {
        this.considerCallSites = consider;
    }

    public String toString() {
        StringBuffer _result = new StringBuffer("Statistics for divergence dependence as calculated by " + this.getClass().getName() + "[" + this.hashCode() + "]\n");
        _result.append("The analyses setup was : \n \tinterprocedural: " + this.considerCallSites + "\n");
        int _localEdgeCount = 0;
        int _edgeCount = 0;
        StringBuffer _temp = new StringBuffer();
        for (Map.Entry _entry : this.dependent2dependee.entrySet()) {
            SootMethod _method = (SootMethod)_entry.getKey();
            _localEdgeCount = 0;
            Map _dependees = (Map)_entry.getValue();
            for (Stmt _dt : _dependees.keySet()) {
                Collection _c = (Collection)_dependees.get(_dt);
                _temp.append("\t\t" + _dt + " --> " + _c + "\n");
                _localEdgeCount += _c.size();
            }
            _result.append("\tFor " + _method + " there are " + _localEdgeCount + " divergence dependence edges.\n");
            _result.append(_temp);
            _temp.delete(0, _temp.length());
            _edgeCount += _localEdgeCount;
        }
        _result.append("A total of " + _edgeCount + " divergence dependence edges exist.");
        return _result.toString();
    }

    @Override
    protected IDependenceRetriever<Stmt, SootMethod, Stmt, Stmt, SootMethod, Stmt> getDependenceRetriever() {
        return new StmtRetriever();
    }

    @Override
    protected void setup() throws InitializationException {
        super.setup();
        this.callgraph = (ICallGraphInfo)this.info.get(ICallGraphInfo.ID);
        if (this.callgraph == null) {
            throw new InitializationException(ICallGraphInfo.ID + " was not provided.");
        }
    }

    private void calculateInterBBDependence(SootMethod method, Collection<BasicBlockGraph.BasicBlock> succsOfPreDivPoints, Collection<Stmt> preDivPoints) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Processing method " + method + " with divergent blocks: " + succsOfPreDivPoints);
        }
        FIFOWorkBag _wb = new FIFOWorkBag();
        HashSet<Stmt> _dependents = new HashSet<Stmt>();
        _wb.addAllWork(succsOfPreDivPoints);
        while (_wb.hasWork()) {
            BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_wb.getWork();
            Stmt _firstStmt = this.directionSensInfo.getFirstStmtInBB(_bb);
            Collection _dependees = (Collection)((Map)this.dependent2dependee.get(method)).get(_firstStmt);
            _dependents.clear();
            if (!preDivPoints.contains(_firstStmt)) {
                Collection<Stmt> _bbStmts = this.directionSensInfo.getIntraBBDependents(_bb, _firstStmt);
                for (Stmt _stmt : _bbStmts) {
                    _dependents.add(_stmt);
                    if (preDivPoints.contains(_stmt)) break;
                }
            }
            if (!succsOfPreDivPoints.contains(_bb)) {
                Collection<BasicBlockGraph.BasicBlock> _succs = this.recordDepAcrossBB(method, preDivPoints, _dependees, _dependents, this.directionSensInfo.getFollowersOfBB(_bb));
                _wb.addAllWorkNoDuplicates(_succs);
                continue;
            }
            this.recordDependenceInfoInBB(_dependees, method, _dependents);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Processing method " + method);
        }
    }

    private Collection<BasicBlockGraph.BasicBlock> calculateIntraBBDependence(SootMethod method, Collection<Stmt> preDivPoints) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("BEGIN: Processing method " + method + " with divergent points: " + preDivPoints);
        }
        HashSet<BasicBlockGraph.BasicBlock> _result = new HashSet<BasicBlockGraph.BasicBlock>();
        HashSet<Stmt> _dependents = new HashSet<Stmt>();
        BasicBlockGraph _bbg = this.getBasicBlockGraph(method);
        for (Stmt _divPoint2 : preDivPoints) {
            BasicBlockGraph.BasicBlock _bb = _bbg.getEnclosingBlock(_divPoint2);
            for (Stmt _divPoint2 : _bb.getStmtsOf()) {
                if (preDivPoints.contains(_divPoint2)) break;
            }
            _dependents.clear();
            Collection<Stmt> _bbStmts = this.directionSensInfo.getIntraBBDependents(_bb, _divPoint2);
            for (Stmt _stmt : _bbStmts) {
                _dependents.add(_stmt);
                if (!preDivPoints.contains(_stmt)) continue;
                this.recordDependenceInfoInBB((Collection<Stmt>)Collections.singleton(_divPoint2), method, _dependents);
                _divPoint2 = _stmt;
                _dependents.clear();
            }
            Collection<BasicBlockGraph.BasicBlock> _validSuccs = this.getValidSuccs(_divPoint2, _bb, _bbg, method);
            Collection<BasicBlockGraph.BasicBlock> _temp = this.recordDepAcrossBB(method, preDivPoints, (Collection<Stmt>)Collections.singleton(_divPoint2), _dependents, _validSuccs);
            _result.addAll(_temp);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("END: Processing method " + method);
        }
        return _result;
    }

    private Collection<SootMethod> findIntraproceduralPreDivPoints(Map<SootMethod, Collection<Stmt>> method2preDivPoints) {
        HashSet<Stmt> _preDivPoints = new HashSet<Stmt>();
        HashSet<SootMethod> _temp = this.considerCallSites ? new HashSet<SootMethod>() : null;
        for (SootMethod _method : this.callgraph.getReachableMethods()) {
            BasicBlockGraph _bbg = this.getBasicBlockGraph(_method);
            List _sccs = _bbg.getSCCs(true);
            for (List _scc : _sccs) {
                if (_scc.size() > 1) {
                    for (BasicBlockGraph.BasicBlock _bb : _scc) {
                        if (_scc.containsAll(_bb.getSuccsOf())) continue;
                        _preDivPoints.add(_bb.getTrailerStmt());
                    }
                    continue;
                }
                BasicBlockGraph.BasicBlock _bb = (BasicBlockGraph.BasicBlock)_scc.iterator().next();
                Collection _succs = _bb.getSuccsOf();
                if (_succs.size() <= 1 || !_succs.contains(_bb)) continue;
                _preDivPoints.add(_bb.getTrailerStmt());
            }
            if (_preDivPoints.isEmpty()) continue;
            method2preDivPoints.put(_method, new ArrayList(_preDivPoints));
            if (this.considerCallSites) {
                _temp.add(_method);
            }
            _preDivPoints.clear();
        }
        return _temp;
    }

    private void findPreDivPoints(Map<SootMethod, Collection<Stmt>> method2preDivPoints) {
        Collection<SootMethod> _temp = this.findIntraproceduralPreDivPoints(method2preDivPoints);
        if (this.considerCallSites) {
            HistoryAwareLIFOWorkBag _preDivMethods = new HistoryAwareLIFOWorkBag(new HashSet());
            _preDivMethods.addAllWork(_temp);
            while (_preDivMethods.hasWork()) {
                SootMethod _callee = (SootMethod)_preDivMethods.getWork();
                for (ICallGraphInfo.CallTriple _ctrp : this.callgraph.getCallers(_callee)) {
                    SootMethod _caller = _ctrp.getMethod();
                    Collection _c = MapUtils.getCollectionFromMap(method2preDivPoints, (Object)_caller);
                    Collection _d = MapUtils.getCollectionFromMap(this.method2interProcDivPoints, (Object)_caller);
                    Stmt _stmt = _ctrp.getStmt();
                    _c.add(_stmt);
                    _d.add(_stmt);
                    _preDivMethods.addWork((Object)_caller);
                }
            }
        }
    }

    private Collection<BasicBlockGraph.BasicBlock> getValidSuccs(Stmt divPoint, BasicBlockGraph.BasicBlock bb, BasicBlockGraph bbg, SootMethod method) {
        HashSet<BasicBlockGraph.BasicBlock> _result = new HashSet<BasicBlockGraph.BasicBlock>(this.directionSensInfo.getFollowersOfBB(bb));
        if (!MapUtils.getEmptyCollectionFromMap(this.method2interProcDivPoints, (Object)method).contains(divPoint)) {
            List _sccs = bbg.getSCCs(true);
            for (List _scc : _sccs) {
                if (!_scc.contains(bb)) continue;
                _result.removeAll(_scc);
                break;
            }
        }
        return _result;
    }

    private Collection<BasicBlockGraph.BasicBlock> recordDepAcrossBB(SootMethod method, Collection<Stmt> preDivPoints, Collection<Stmt> dependees, Collection<Stmt> dependents, Collection<BasicBlockGraph.BasicBlock> succs) {
        ArrayList<BasicBlockGraph.BasicBlock> _result = new ArrayList<BasicBlockGraph.BasicBlock>();
        for (BasicBlockGraph.BasicBlock _succ : succs) {
            Stmt _firstStmt = this.directionSensInfo.getFirstStmtInBB(_succ);
            dependents.add(_firstStmt);
            if (preDivPoints.contains(_firstStmt)) continue;
            _result.add(_succ);
        }
        this.recordDependenceInfoInBB(dependees, method, dependents);
        return _result;
    }

    private void recordDependenceInfoInBB(Collection<Stmt> dependees, SootMethod method, Collection<Stmt> dependents) {
        Map _de = MapUtils.getMapFromMap((Map)this.dependent2dependee, (Object)method);
        for (Stmt _dependent : dependents) {
            Collection _dees = MapUtils.getCollectionFromMap((Map)_de, (Object)_dependent);
            _dees.addAll(dependees);
        }
        Map _dt = MapUtils.getMapFromMap((Map)this.dependee2dependent, (Object)method);
        for (Stmt _dependee : dependees) {
            Collection _dents = MapUtils.getCollectionFromMap((Map)_dt, (Object)_dependee);
            _dents.addAll(dependents);
        }
    }
}

