/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.collections.IFactory;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.collections.SetUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.MetricsProcessor;
import edu.ksu.cis.indus.common.soot.SootBasedDriver;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IExceptionRaisingInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CGBasedXMLizingProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CallGraphInfo;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallInfoCollector;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.cfg.ExceptionRaisingAnalysis;
import edu.ksu.cis.indus.staticanalyses.cfg.StaticFieldUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.concurrency.MonitorAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.SafeLockAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyXMLizer;
import edu.ksu.cis.indus.staticanalyses.dependency.DivergenceDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ExitControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.InterProceduralDivergenceDA;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationInsensitiveEntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationSensitiveEntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.SynchronizationDA;
import edu.ksu.cis.indus.staticanalyses.dependency.SystemDependenceGraphBuilder;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.OFAnalyzer;
import edu.ksu.cis.indus.staticanalyses.flow.processors.AliasedUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.flow.processors.AliasedUseDefInfov2;
import edu.ksu.cis.indus.staticanalyses.flow.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import edu.ksu.cis.indus.staticanalyses.tokens.ITokens;
import edu.ksu.cis.indus.staticanalyses.tokens.TokenUtil;
import edu.ksu.cis.indus.staticanalyses.tokens.soot.SootValueTypeManager;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyXMLizerCLI
extends SootBasedDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyXMLizerCLI.class);
    protected IValueAnalyzer<Value> aa;
    protected List<IDependencyAnalysis> das = new ArrayList<IDependencyAnalysis>();
    protected final Map info = new HashMap();
    private boolean commonUncheckedException;
    private boolean dumpJimple;
    private boolean exceptionalExits;
    private boolean useAliasedUseDefv1;
    private boolean useSafeLockAnalysis;
    private final DependencyXMLizer xmlizer = new DependencyXMLizer();

    public static void main(String[] args) {
        Options _options = new Options();
        Option _option = new Option("o", "output", true, "Directory into which xml files will be written into.  Defaults to current directory if omitted");
        _option.setArgs(1);
        _option.setArgName("output-directory");
        _options.addOption(_option);
        _option = new Option("j", "jimple", false, "Dump xmlized jimple.");
        _options.addOption(_option);
        DivergenceDA _fidda = DivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.FORWARD_DIRECTION);
        _fidda.setConsiderCallSites(true);
        DivergenceDA _bidda = DivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.BACKWARD_DIRECTION);
        _bidda.setConsiderCallSites(true);
        NonTerminationSensitiveEntryControlDA _ncda = new NonTerminationSensitiveEntryControlDA();
        Object[][] _dasOptions = new Object[][]{{"ibdda1", "Identifier based data dependence (Soot)", new IdentifierBasedDataDA()}, {"ibdda2", "Identifier based data dependence (Indus)", new IdentifierBasedDataDAv2()}, {"ibdda3", "Identifier based data dependence (Indus Optimized)", new IdentifierBasedDataDAv3()}, {"rbdda", "Reference based data dependence", new ReferenceBasedDataDA()}, {"nscda", "Non-termination sensitive Entry control dependence", _ncda}, {"nicda", "Non-termination insensitive Entry control dependence", new NonTerminationInsensitiveEntryControlDA()}, {"xcda", "Exit control dependence", new ExitControlDA()}, {"sda", "Synchronization dependence", new SynchronizationDA()}, {"frda1", "Forward Ready dependence v1", ReadyDAv1.getForwardReadyDA()}, {"brda1", "Backward Ready dependence v1", ReadyDAv1.getBackwardReadyDA()}, {"frda2", "Forward Ready dependence v2", ReadyDAv2.getForwardReadyDA()}, {"brda2", "Backward Ready dependence v2", ReadyDAv2.getBackwardReadyDA()}, {"frda3", "Forward Ready dependence v3", ReadyDAv3.getForwardReadyDA()}, {"brda3", "Backward Ready dependence v3", ReadyDAv3.getBackwardReadyDA()}, {"ida1", "Interference dependence v1", new InterferenceDAv1()}, {"ida2", "Interference dependence v2", new InterferenceDAv2()}, {"ida3", "Interference dependence v3", new InterferenceDAv3()}, {"fdda", "Forward Intraprocedural Divergence dependence", DivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.FORWARD_DIRECTION)}, {"bdda", "Backward Intraprocedural Divergence dependence", DivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.BACKWARD_DIRECTION)}, {"fidda", "Forward Intra+Interprocedural Divergence dependence", _fidda}, {"bidda", "Backward Intra+Interprocedural Divergence dependence", _bidda}, {"fpidda", "Forward Interprocedural Divergence dependence", InterProceduralDivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.FORWARD_DIRECTION)}, {"bpidda", "Backward Interprocedural Divergence dependence", InterProceduralDivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.BACKWARD_DIRECTION)}};
        _option = new Option("h", "help", false, "Display message.");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("p", "soot-classpath", false, "Prepend this to soot class path.");
        _option.setArgs(1);
        _option.setArgName("classpath");
        _option.setOptionalArg(false);
        _options.addOption(_option);
        _option = new Option("aliasedusedefv1", false, "Use version 1 of aliased use-def info.");
        _options.addOption(_option);
        _option = new Option("safelockanalysis", false, "Use safe-lock-analysis for ready dependence.");
        _options.addOption(_option);
        _option = new Option("ofaforinterference", false, "Use OFA for interference dependence.");
        _options.addOption(_option);
        _option = new Option("ofaforready", false, "Use OFA for ready dependence.");
        _options.addOption(_option);
        _option = new Option("exceptionalexits", false, "Consider exceptional exits for control dependence.");
        _options.addOption(_option);
        _option = new Option("commonuncheckedexceptions", false, "Consider common unchecked exceptions.");
        _options.addOption(_option);
        _option = new Option("S", "scope", true, "The scope that should be analyzed.");
        _option.setArgs(1);
        _option.setArgName("scope");
        _option.setRequired(false);
        _options.addOption(_option);
        int _i = 0;
        while (_i < _dasOptions.length) {
            String _shortOption = _dasOptions[_i][0].toString();
            String _description = _dasOptions[_i][1].toString();
            _option = new Option(_shortOption, false, _description);
            _options.addOption(_option);
            ++_i;
        }
        GnuParser _parser = new GnuParser();
        try {
            CommandLine _cl = _parser.parse(_options, args);
            if (_cl.hasOption("h")) {
                DependencyXMLizerCLI.printUsage(_options);
                System.exit(1);
            }
            DependencyXMLizerCLI _xmlizerCLI = new DependencyXMLizerCLI();
            String _outputDir = _cl.getOptionValue('o');
            if (_outputDir == null) {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Defaulting to current directory for output.");
                }
                _outputDir = ".";
            }
            _xmlizerCLI.xmlizer.setXmlOutputDir(_outputDir);
            if (_cl.hasOption('p')) {
                _xmlizerCLI.addToSootClassPath(_cl.getOptionValue('p'));
            }
            if (_cl.hasOption('S')) {
                _xmlizerCLI.setScopeSpecFile(_cl.getOptionValue('S'));
            }
            _xmlizerCLI.dumpJimple = _cl.hasOption('j');
            _xmlizerCLI.useAliasedUseDefv1 = _cl.hasOption("aliasedusedefv1");
            _xmlizerCLI.useSafeLockAnalysis = _cl.hasOption("safelockanalysis");
            _xmlizerCLI.exceptionalExits = _cl.hasOption("exceptionalexits");
            _xmlizerCLI.commonUncheckedException = _cl.hasOption("commonuncheckedexceptions");
            List _classNames = _cl.getArgList();
            if (_classNames.isEmpty()) {
                throw new MissingArgumentException("Please specify atleast one class.");
            }
            _xmlizerCLI.setClassNames(_classNames);
            if (_cl.hasOption(_dasOptions[6][0].toString())) {
                _xmlizerCLI.das.add(_ncda);
                for (IDependencyAnalysis.DependenceSort _id : _ncda.getIds()) {
                    MapUtils.putIntoCollectionInMapUsingFactory((Map)_xmlizerCLI.info, (Object)((Object)_id), (Object)_ncda, (IFactory)SetUtils.getFactory());
                }
            }
            if (!DependencyXMLizerCLI.parseForDependenceOptions(_dasOptions, _cl, _xmlizerCLI)) {
                throw new ParseException("Atleast one dependence analysis must be requested.");
            }
            _xmlizerCLI.execute();
        }
        catch (ParseException _e) {
            LOGGER.error("Error while parsing command line.", (Throwable)_e);
            System.out.println("Error while parsing command line." + (Object)((Object)_e));
            DependencyXMLizerCLI.printUsage(_options);
        }
        catch (Throwable _e) {
            LOGGER.error("Beyond our control. May day! May day!", _e);
            throw new RuntimeException(_e);
        }
    }

    private static boolean parseForDependenceOptions(Object[][] dependenceOptions, CommandLine cmdLine, DependencyXMLizerCLI xmlizerCLI) {
        boolean _flag = false;
        int _i = 0;
        while (_i < dependenceOptions.length) {
            if (cmdLine.hasOption(dependenceOptions[_i][0].toString())) {
                IDependencyAnalysis _da = (IDependencyAnalysis)dependenceOptions[_i][2];
                xmlizerCLI.das.add(_da);
                _flag = true;
                if (_da instanceof InterferenceDAv1) {
                    ((InterferenceDAv1)_da).setUseOFA(cmdLine.hasOption("ofaforinterference"));
                }
                if (_da instanceof ReadyDAv1) {
                    ((ReadyDAv1)_da).setUseOFA(cmdLine.hasOption("ofaforready"));
                    ((ReadyDAv1)_da).setUseSafeLockAnalysis(xmlizerCLI.useSafeLockAnalysis);
                }
            }
            ++_i;
        }
        return _flag;
    }

    private static void printUsage(Options options) {
        String _cmdLineSyn = "java " + DependencyXMLizerCLI.class.getName() + " <options> <classnames>";
        new HelpFormatter().printHelp(_cmdLineSyn, "Options are: ", options, "");
    }

    private <T extends ITokens<T, Value>> void execute() {
        SafeLockAnalysis _sla;
        this.setInfoLogger(LOGGER);
        this.aa = OFAnalyzer.getFSOSAnalyzer("DependencyXMLizer:FA", TokenUtil.getTokenManager(new SootValueTypeManager()), this.getStmtGraphFactory());
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        ArrayList<Object> _processors = new ArrayList<Object>();
        Pair.PairManager _pairManager = new Pair.PairManager(false, true);
        CallGraphInfo _cgi = new CallGraphInfo(new Pair.PairManager(false, true));
        ThreadGraph _tgi = new ThreadGraph(_cgi, new CFGAnalysis(_cgi, this.getBbm()), _pairManager);
        ExceptionRaisingAnalysis _eti = new ExceptionRaisingAnalysis(this.getStmtGraphFactory(), _cgi, this.aa.getEnvironment());
        ProcessingController _xmlcgipc = new ProcessingController();
        ValueAnalyzerBasedProcessingController _cgipc = new ValueAnalyzerBasedProcessingController();
        MetricsProcessor _countingProcessor = new MetricsProcessor();
        OFABasedCallInfoCollector _callGraphInfoCollector = new OFABasedCallInfoCollector();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(this.aa);
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("DependencyXMLizer:FA"));
        _cgipc.setAnalyzer(this.aa);
        _cgipc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(_cgi));
        _cgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _xmlcgipc.setEnvironment(this.aa.getEnvironment());
        _xmlcgipc.setProcessingFilter((IProcessingFilter)new CGBasedXMLizingProcessingFilter(_cgi));
        _xmlcgipc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        StaticFieldUseDefInfo _staticFieldUD = new StaticFieldUseDefInfo();
        AliasedUseDefInfo _aliasUD = this.useAliasedUseDefv1 ? new AliasedUseDefInfo(this.aa, this.bbm, _pairManager, new CFGAnalysis(_cgi, this.bbm)) : new AliasedUseDefInfov2(this.aa, _cgi, _tgi, this.bbm, _pairManager);
        this.info.put(ICallGraphInfo.ID, _cgi);
        this.info.put(IThreadGraphInfo.ID, _tgi);
        this.info.put(Pair.PairManager.ID, _pairManager);
        this.info.put(IEnvironment.ID, this.aa.getEnvironment());
        this.info.put(IValueAnalyzer.ID, this.aa);
        this.info.put(IUseDefInfo.ALIASED_USE_DEF_ID, _aliasUD);
        this.info.put(IUseDefInfo.GLOBAL_USE_DEF_ID, _staticFieldUD);
        this.info.put(IStmtGraphFactory.ID, this.getStmtGraphFactory());
        EquivalenceClassBasedEscapeAnalysis _ecba = new EquivalenceClassBasedEscapeAnalysis(_cgi, _tgi, this.getBbm());
        this.info.put(IEscapeInfo.ID, _ecba.getEscapeInfo());
        MonitorAnalysis _monitorInfo = new MonitorAnalysis();
        this.info.put(IMonitorInfo.ID, _monitorInfo);
        if (this.useSafeLockAnalysis) {
            _sla = new SafeLockAnalysis();
            this.info.put(SafeLockAnalysis.ID, _sla);
        } else {
            _sla = null;
        }
        this.initialize();
        this.aa.analyze(this.getEnvironment(), this.getRootMethods());
        _callGraphInfoCollector.reset();
        _processors.clear();
        _processors.add(_callGraphInfoCollector);
        _pc.reset();
        _pc.driveProcessors(_processors);
        _cgi.createCallGraphInfo(_callGraphInfoCollector.getCallInfo());
        this.writeInfo("CALL GRAPH:\n" + _cgi.toString());
        if (this.commonUncheckedException) {
            ExceptionRaisingAnalysis _t = _eti;
            _t.setupForCommonUncheckedExceptions();
        }
        _processors.clear();
        _tgi.reset();
        _processors.add(_tgi);
        _processors.add((IProcessor)_eti);
        _processors.add(_countingProcessor);
        _cgipc.reset();
        _cgipc.driveProcessors(_processors);
        this.writeInfo("THREAD GRAPH:\n" + _tgi.toString());
        this.writeInfo("EXCEPTION THROW INFO:\n" + _eti.toString());
        this.writeInfo("STATISTICS: " + MapUtils.verbosePrint(new TreeMap(_countingProcessor.getStatistics())));
        _aliasUD.hookup(_cgipc);
        _staticFieldUD.hookup(_cgipc);
        _cgipc.process();
        _staticFieldUD.unhook(_cgipc);
        _aliasUD.unhook(_cgipc);
        this.writeInfo("BEGIN: dependency analyses");
        if (this.exceptionalExits) {
            this.bbm = new BasicBlockGraphMgr((IExceptionRaisingInfo)_eti);
            this.bbm.setStmtGraphFactory(this.getStmtGraphFactory());
        }
        AnalysesController _ac = new AnalysesController(this.info, _cgipc, this.getBbm());
        _ac.addAnalyses(IMonitorInfo.ID, (Collection<? extends IAnalysis>)Collections.singleton(_monitorInfo));
        _ac.addAnalyses(EquivalenceClassBasedEscapeAnalysis.ID, (Collection<? extends IAnalysis>)Collections.singleton(_ecba));
        if (this.useSafeLockAnalysis) {
            _ac.addAnalyses(SafeLockAnalysis.ID, (Collection<? extends IAnalysis>)Collections.singleton(_sla));
        }
        for (IDependencyAnalysis _da1 : this.das) {
            for (Comparable comparable : _da1.getIds()) {
                _ac.addAnalyses(comparable, (Collection<? extends IAnalysis>)Collections.singleton(_da1));
            }
        }
        _ac.initialize();
        _ac.execute();
        for (IDependencyAnalysis _da1 : this.das) {
            for (IDependencyAnalysis.DependenceSort dependenceSort : _da1.getIds()) {
                MapUtils.putIntoListInMap((Map)this.info, (Object)((Object)dependenceSort), (Object)_da1);
            }
        }
        this.xmlizer.setGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
        this.xmlizer.writeXML(this.info);
        if (this.dumpJimple) {
            this.xmlizer.dumpJimple(null, this.xmlizer.getXmlOutputDir(), _xmlcgipc);
        }
        this.writeInfo("Total classes loaded: " + this.getEnvironment().getClasses().size());
        SystemDependenceGraphBuilder.getSystemDependenceGraph(this.das, _cgi, this.getEnvironment().getClasses());
    }
}

