/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IProcessor;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.ProcessingController;
import edu.ksu.cis.indus.staticanalyses.callgraphs.CGBasedXMLizingProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.StmtAndMethodBasedDependencyXMLizer;
import edu.ksu.cis.indus.xmlizer.AbstractXMLizer;
import edu.ksu.cis.indus.xmlizer.CustomXMLOutputter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.znerd.xmlenc.XMLOutputter;
import soot.SootMethod;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyXMLizer
extends AbstractXMLizer {
    public static final Object STMT_LEVEL_DEPENDENCY = "STMT_LEVEL_DEPENDENCY";
    protected static final Properties PROPERTIES = new Properties();
    private static final Logger LOGGER;
    final Collection<String> filenames = new ArrayList<String>();

    static {
        String _propFileName = System.getProperty("indus.dependencyxmlizer.properties.file");
        if (_propFileName == null) {
            _propFileName = "edu/ksu/cis/indus/staticanalyses/dependency/DependencyXMLizer.properties";
        }
        InputStream _stream = ClassLoader.getSystemResourceAsStream(_propFileName);
        try {
            PROPERTIES.load(_stream);
        }
        catch (IOException _e) {
            System.err.println("Well, error loading property file.  Bailing.");
            throw new RuntimeException(_e);
        }
        LOGGER = LoggerFactory.getLogger(DependencyXMLizer.class);
    }

    public String getFileName(String name) {
        return "dependence_" + DependencyXMLizer.xmlizeString((String)name) + ".xml";
    }

    public void flushXMLizers(Map<StmtAndMethodBasedDependencyXMLizer<?, ?>, Writer> xmlizers, ProcessingController ctrl) {
        for (IProcessor iProcessor : xmlizers.keySet()) {
            iProcessor.unhook(ctrl);
            try {
                Writer _f = xmlizers.get(iProcessor);
                _f.flush();
                _f.close();
            }
            catch (IOException _e) {
                _e.printStackTrace();
                LOGGER.error("Failed to close the xml file based on " + iProcessor.getClass(), (Throwable)_e);
            }
        }
    }

    public void writeXML(Map info) {
        ProcessingController _ctrl = new ProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory((IStmtGraphFactory)info.get(IStmtGraphFactory.ID));
        _ctrl.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _ctrl.setEnvironment((IEnvironment)info.get(IEnvironment.ID));
        _ctrl.setProcessingFilter((IProcessingFilter)new CGBasedXMLizingProcessingFilter((ICallGraphInfo)info.get(ICallGraphInfo.ID)));
        Map<StmtAndMethodBasedDependencyXMLizer<?, ?>, Writer> _xmlizers = this.initXMLizers(info, _ctrl);
        _ctrl.process();
        this.flushXMLizers(_xmlizers, _ctrl);
    }

    String getDAPartOfFileName(IDependencyAnalysis<?, ?, ?, ?, ?, ?> da) {
        ArrayList<IDependencyAnalysis.DependenceSort> _t = new ArrayList<IDependencyAnalysis.DependenceSort>(da.getIds());
        Collections.sort(_t);
        return _t + ":" + (Object)((Object)da.getDirection()) + ":" + da.getClass().getName();
    }

    private <T1 extends Stmt, E2 extends Stmt> StmtAndMethodBasedDependencyXMLizer<T1, E2> getXMLizerFor(Writer writer, IDependencyAnalysis<T1, SootMethod, ?, E2, SootMethod, ?> da) {
        StmtAndMethodBasedDependencyXMLizer<T1, E2> _result = null;
        ArrayList<IDependencyAnalysis.DependenceSort> _t = new ArrayList<IDependencyAnalysis.DependenceSort>(da.getIds());
        Collections.sort(_t);
        String _xmlizerId = ((Object)_t).toString();
        String _temp = PROPERTIES.getProperty(_xmlizerId);
        if (_temp.equals(STMT_LEVEL_DEPENDENCY)) {
            try {
                _result = new StmtAndMethodBasedDependencyXMLizer<T1, E2>((XMLOutputter)new CustomXMLOutputter(writer), this.getIdGenerator(), da);
            }
            catch (UnsupportedEncodingException _e) {
                LOGGER.error("UTF-8 encoding is unsupported.  Now, this contradicts the documentation!!", (Throwable)_e);
            }
        } else {
            LOGGER.error("Unknown dependency xmlizer type requested.  Bailing on this.");
        }
        return _result;
    }

    private Map<StmtAndMethodBasedDependencyXMLizer<?, ?>, Writer> initXMLizers(Map info, ProcessingController ctrl) {
        HashMap _result = new HashMap();
        if (this.getXmlOutputDir() == null) {
            LOGGER.error("Please specify an output directory while using the xmlizer.");
            throw new IllegalStateException("Please specify an output directory while using the xmlizer.");
        }
        for (Comparable<?> _id : AbstractDependencyAnalysis.IDENTIFIERS) {
            Collection _col = (Collection)info.get(_id);
            if (_col == null) continue;
            for (IDependencyAnalysis _da : _col) {
                String _providedFileName = (String)info.get(FILE_NAME_ID);
                if (_providedFileName == null) {
                    _providedFileName = this.getDAPartOfFileName(_da);
                }
                String _filename = this.getFileName(_providedFileName);
                this.filenames.add(_filename);
                File _f = new File(String.valueOf(this.getXmlOutputDir()) + File.separator + _filename);
                try {
                    FileWriter _writer = new FileWriter(_f);
                    StmtAndMethodBasedDependencyXMLizer _xmlizer = this.getXMLizerFor(_writer, _da);
                    if (_xmlizer == null) {
                        LOGGER.error("No xmlizer specified for dependency calculated by " + _da.getClass() + ".  No xml file written.");
                        _writer.close();
                        continue;
                    }
                    _xmlizer.hookup(ctrl);
                    _result.put(_xmlizer, _writer);
                }
                catch (IOException _e) {
                    LOGGER.error("Failed to write the xml file based on " + _da.getClass(), (Throwable)_e);
                }
            }
        }
        return _result;
    }
}

