/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.common.collections.MapUtils;
import edu.ksu.cis.indus.common.datastructures.Pair;
import edu.ksu.cis.indus.common.soot.BasicBlockGraphMgr;
import edu.ksu.cis.indus.interfaces.ICallGraphInfo;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.interfaces.IEscapeInfo;
import edu.ksu.cis.indus.interfaces.IMonitorInfo;
import edu.ksu.cis.indus.interfaces.IThreadGraphInfo;
import edu.ksu.cis.indus.interfaces.IUseDefInfo;
import edu.ksu.cis.indus.processing.IProcessingFilter;
import edu.ksu.cis.indus.processing.IStmtSequencesRetriever;
import edu.ksu.cis.indus.processing.OneAllStmtSequenceRetriever;
import edu.ksu.cis.indus.processing.TagBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.cfg.CFGAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.MonitorAnalysis;
import edu.ksu.cis.indus.staticanalyses.concurrency.escape.EquivalenceClassBasedEscapeAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysisTest;
import edu.ksu.cis.indus.staticanalyses.dependency.XMLBasedDependencyAnalysisTest;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ValueAnalysisTestSetup;
import edu.ksu.cis.indus.staticanalyses.flow.processors.AliasedUseDefInfo;
import edu.ksu.cis.indus.staticanalyses.flow.processors.AliasedUseDefInfov2;
import edu.ksu.cis.indus.staticanalyses.flow.processors.ThreadGraph;
import edu.ksu.cis.indus.staticanalyses.interfaces.IAnalysis;
import edu.ksu.cis.indus.staticanalyses.interfaces.IValueAnalyzer;
import edu.ksu.cis.indus.staticanalyses.processing.AnalysesController;
import edu.ksu.cis.indus.staticanalyses.processing.CGBasedProcessingFilter;
import edu.ksu.cis.indus.staticanalyses.processing.ValueAnalyzerBasedProcessingController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestSuite;

public class DependencyAnalysisTestSetup
extends ValueAnalysisTestSetup {
    private AliasedUseDefInfo aliasUD;
    private BasicBlockGraphMgr bbgMgr;
    private Collection<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> das;
    private EquivalenceClassBasedEscapeAnalysis ecba;
    private Map info;
    private MonitorAnalysis monitorInfo;
    private ThreadGraph tgiImpl;

    protected DependencyAnalysisTestSetup(TestSuite test, String theNameOfClasses, String classpath) {
        super(test, theNameOfClasses, classpath);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bbgMgr = new BasicBlockGraphMgr();
        this.bbgMgr.setStmtGraphFactory(this.getStmtGraphFactory());
        ValueAnalyzerBasedProcessingController _pc = new ValueAnalyzerBasedProcessingController();
        OneAllStmtSequenceRetriever _ssr = new OneAllStmtSequenceRetriever();
        _ssr.setStmtGraphFactory(this.getStmtGraphFactory());
        _pc.setStmtSequencesRetriever((IStmtSequencesRetriever)_ssr);
        _pc.setAnalyzer(this.valueAnalyzer);
        _pc.setEnvironment(this.valueAnalyzer.getEnvironment());
        _pc.setProcessingFilter((IProcessingFilter)new TagBasedProcessingFilter("indus.staticanalyses.flow.FATestSetup:FA"));
        Pair.PairManager _pairManager = new Pair.PairManager(false, true);
        this.tgiImpl = new ThreadGraph(this.cgiImpl, new CFGAnalysis(this.cgiImpl, this.bbgMgr), _pairManager);
        this.tgiImpl.hookup(_pc);
        _pc.process();
        this.tgiImpl.unhook(_pc);
        this.aliasUD = new AliasedUseDefInfov2(this.valueAnalyzer, this.cgiImpl, this.tgiImpl, this.bbgMgr, _pairManager);
        this.ecba = new EquivalenceClassBasedEscapeAnalysis(this.cgiImpl, null, this.bbgMgr);
        this.monitorInfo = new MonitorAnalysis();
        this.info = new HashMap();
        this.info.put(ICallGraphInfo.ID, this.cgiImpl);
        this.info.put(IThreadGraphInfo.ID, this.tgiImpl);
        this.info.put(Pair.PairManager.ID, _pairManager);
        this.info.put(IEnvironment.ID, this.valueAnalyzer.getEnvironment());
        this.info.put(IValueAnalyzer.ID, this.valueAnalyzer);
        this.info.put(IUseDefInfo.ALIASED_USE_DEF_ID, this.aliasUD);
        this.info.put(IEscapeInfo.ID, this.ecba.getEscapeInfo());
        this.info.put(IMonitorInfo.ID, this.monitorInfo);
        this.das = new HashSet();
        for (IDependencyAnalysisTest _test : TestHelper.getTestCasesReachableFromSuite((TestSuite)((TestSuite)this.getTest()), IDependencyAnalysisTest.class)) {
            _test.setEnvironment(this.valueAnalyzer.getEnvironment());
            IDependencyAnalysis _da = _test.getDA();
            this.das.add(_da);
            if (!_da.getIds().contains((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA) || !_da.getDirection().equals((Object)IDependencyAnalysis.Direction.BI_DIRECTIONAL) && !_da.getDirection().equals((Object)IDependencyAnalysis.Direction.BACKWARD_DIRECTION)) continue;
            MapUtils.putIntoSetInMap((Map)this.info, (Object)((Object)IDependencyAnalysis.DependenceSort.CONTROL_DA), (Object)_da);
        }
        for (IDependencyAnalysisTest _test : TestHelper.getTestCasesReachableFromSuite((TestSuite)((TestSuite)this.getTest()), XMLBasedDependencyAnalysisTest.class)) {
            ((XMLBasedDependencyAnalysisTest)_test).setCallGraph(this.cgiImpl);
        }
        _pc.setProcessingFilter((IProcessingFilter)new CGBasedProcessingFilter(this.cgiImpl));
        this.aliasUD.hookup(_pc);
        _pc.process();
        this.aliasUD.unhook(_pc);
        AnalysesController _ac = new AnalysesController(this.info, _pc, this.bbgMgr);
        _ac.addAnalyses(IMonitorInfo.ID, (Collection<? extends IAnalysis>)Collections.singleton(this.monitorInfo));
        _ac.addAnalyses(IEscapeInfo.ID, (Collection<? extends IAnalysis>)Collections.singleton(this.ecba));
        for (IDependencyAnalysis<?, ?, ?, ?, ?, ?> _da1 : this.das) {
            _da1.reset();
            for (Comparable comparable : _da1.getIds()) {
                _ac.addAnalyses(comparable, (Collection<? extends IAnalysis>)Collections.singleton(_da1));
            }
        }
        _ac.initialize();
        _ac.execute();
    }

    protected void tearDown() throws Exception {
        this.bbgMgr.reset();
        this.bbgMgr = null;
        this.tgiImpl.reset();
        this.tgiImpl = null;
        this.ecba.reset();
        this.ecba = null;
        this.monitorInfo.reset();
        this.monitorInfo = null;
        this.aliasUD.reset();
        this.aliasUD = null;
        this.info.clear();
        this.info = null;
        Iterator<IDependencyAnalysis<?, ?, ?, ?, ?, ?>> _i = this.das.iterator();
        while (_i.hasNext()) {
            _i.next().reset();
        }
        this.das.clear();
        this.das = null;
        super.tearDown();
    }
}

