/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.ErringTestCase;
import edu.ksu.cis.indus.TestHelper;
import edu.ksu.cis.indus.common.soot.CompleteStmtGraphFactory;
import edu.ksu.cis.indus.common.soot.IStmtGraphFactory;
import edu.ksu.cis.indus.staticanalyses.callgraphs.OFABasedCallGraphTest;
import edu.ksu.cis.indus.staticanalyses.callgraphs.XMLBasedCallGraphTest;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.AbstractDependencyAnalysisTest;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyAnalysisTestSetup;
import edu.ksu.cis.indus.staticanalyses.dependency.DependencyXMLizer;
import edu.ksu.cis.indus.staticanalyses.dependency.DivergenceDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ExitControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IdentifierBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.InterProceduralDivergenceDA;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.InterferenceDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationInsensitiveEntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.NonTerminationSensitiveEntryControlDA;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv1;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv2;
import edu.ksu.cis.indus.staticanalyses.dependency.ReadyDAv3;
import edu.ksu.cis.indus.staticanalyses.dependency.ReferenceBasedDataDA;
import edu.ksu.cis.indus.staticanalyses.dependency.SynchronizationDA;
import edu.ksu.cis.indus.staticanalyses.dependency.XMLBasedDependencyAnalysisTest;
import edu.ksu.cis.indus.staticanalyses.flow.FATest;
import edu.ksu.cis.indus.staticanalyses.flow.instances.ofa.XMLBasedOFATest;
import edu.ksu.cis.indus.xmlizer.IJimpleIDGenerator;
import edu.ksu.cis.indus.xmlizer.UniqueJimpleIDGenerator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Pattern;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyAnalysisRegressionTestSuite
extends TestCase {
    public static final String DEPENDENCY_ANALYSIS_TEST_PROPERTIES_FILE = "indus.staticanalyses.dependency.DependencyAnalysisTest.properties.file";
    private static final Logger LOGGER = LoggerFactory.getLogger(DependencyAnalysisRegressionTestSuite.class);
    private static final Properties TEST_CLASSES_PROPERTIES = new Properties();

    static {
        String _propFileName = System.getProperty("indus.dependencyxmlizer.properties.file");
        if (_propFileName == null) {
            _propFileName = "edu/ksu/cis/indus/staticanalyses/dependency/DependencyAnalysisTestClasses.properties";
        }
        InputStream _stream = ClassLoader.getSystemResourceAsStream(_propFileName);
        try {
            TEST_CLASSES_PROPERTIES.load(_stream);
        }
        catch (IOException _e) {
            System.err.println("Well, error loading property file.  Bailing.");
            throw new RuntimeException(_e);
        }
    }

    public static void main(String[] args) {
        String[] _suiteName = new String[]{DependencyAnalysisRegressionTestSuite.class.getName()};
        TestRunner.main((String[])_suiteName);
    }

    public static Test suite() {
        TestSuite _suite = new TestSuite("Test for edu.ksu.cis.indus.staticanalyses.dependency");
        String _propFileName = System.getProperty(DEPENDENCY_ANALYSIS_TEST_PROPERTIES_FILE);
        if (_propFileName == null) {
            throw new RuntimeException("Please provide a property file like DependencyAnalysisTest.properties via -Dindus.staticanalyses.dependency.DependencyAnalysisTest.properties.file");
        }
        DependencyAnalysisRegressionTestSuite.setupTests(_propFileName, _suite);
        return _suite;
    }

    private static Test getDATestFor(IDependencyAnalysis analysis) {
        AbstractDependencyAnalysisTest _result = null;
        String _daClassName = analysis.getClass().getName();
        String _daTestClassName = TEST_CLASSES_PROPERTIES.getProperty(_daClassName);
        if (_daTestClassName == null) {
            LOGGER.error("How can the test class for a dependency analysis be undefined? " + _daClassName);
        } else {
            try {
                Class<?> _daTestClass = Class.forName(_daTestClassName);
                AbstractDependencyAnalysisTest _daTest = (AbstractDependencyAnalysisTest)_daTestClass.newInstance();
                _daTest.setDA(analysis);
                _result = _daTest;
            }
            catch (InstantiationException _e1) {
                LOGGER.error("Error while creating an object of type. " + _daTestClassName, (Throwable)_e1);
            }
            catch (IllegalAccessException _e1) {
                LOGGER.error("Error while accessing the constructor of type. " + _daTestClassName, (Throwable)_e1);
            }
            catch (ClassNotFoundException _e1) {
                LOGGER.error("Error while finding type. " + _daTestClassName, (Throwable)_e1);
            }
            catch (SecurityException _e1) {
                LOGGER.error("Security violation while accessing the constructor of type. " + _daTestClassName, (Throwable)_e1);
            }
        }
        return _result;
    }

    private static void setupTests(String propFileName, TestSuite suite) {
        Properties _props = new Properties();
        try {
            _props.load(new FileInputStream(new File(propFileName)));
            String[] _configs = _props.getProperty("configs").split(" ");
            ArrayList<AbstractDependencyAnalysis> _das = new ArrayList<AbstractDependencyAnalysis>();
            CompleteStmtGraphFactory _stmtGraphFactory = new CompleteStmtGraphFactory();
            int _i = 0;
            while (_i < _configs.length) {
                String _config = _configs[_i];
                String _classNames = _props.getProperty(String.valueOf(_config) + ".classNames");
                String _xmlTestDir = _props.getProperty(String.valueOf(_config) + ".xmlTestDir");
                String _xmlControlDir = _props.getProperty(String.valueOf(_config) + ".xmlControlDir");
                String _classpath = _props.getProperty(String.valueOf(_config) + ".classpath");
                String _jimpleXMLDumpDir = _props.getProperty(String.valueOf(_config) + ".jimpleXMLDumpDir");
                String _str = TestHelper.checkXMLBasedTestExecutability((String)_config, (String)_xmlTestDir, (String)_xmlControlDir);
                try {
                    TestSuite _temp = new TestSuite(_config);
                    if (_str.length() > 0) {
                        _temp.addTest((Test)new ErringTestCase(_str));
                        TestHelper.appendSuiteNameToTestsIn((TestSuite)_temp, (boolean)true);
                        suite.addTest((Test)_temp);
                    } else {
                        _das.clear();
                        _das.add(DivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.FORWARD_DIRECTION));
                        _das.add(DivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.BACKWARD_DIRECTION));
                        _das.add(InterProceduralDivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.FORWARD_DIRECTION));
                        _das.add(InterProceduralDivergenceDA.getDivergenceDA(IDependencyAnalysis.Direction.BACKWARD_DIRECTION));
                        _das.add(new NonTerminationSensitiveEntryControlDA());
                        _das.add(new NonTerminationInsensitiveEntryControlDA());
                        _das.add(new ExitControlDA());
                        _das.add(new IdentifierBasedDataDA());
                        _das.add(new InterferenceDAv1());
                        _das.add(new InterferenceDAv2());
                        _das.add(new InterferenceDAv3());
                        _das.add(ReadyDAv1.getForwardReadyDA());
                        _das.add(ReadyDAv1.getBackwardReadyDA());
                        _das.add(ReadyDAv2.getForwardReadyDA());
                        _das.add(ReadyDAv2.getBackwardReadyDA());
                        _das.add(ReadyDAv3.getForwardReadyDA());
                        _das.add(ReadyDAv3.getBackwardReadyDA());
                        _das.add(new ReferenceBasedDataDA());
                        _das.add(new SynchronizationDA());
                        String _ignoreDARegex = _props.getProperty("ignore.das");
                        if (_ignoreDARegex == null) {
                            _ignoreDARegex = "^$";
                        }
                        for (Object e : _das) {
                            Test test;
                            if (Pattern.matches(_ignoreDARegex, e.getClass().getName()) || (test = DependencyAnalysisRegressionTestSuite.getDATestFor((IDependencyAnalysis)e)) == null) continue;
                            _temp.addTest(test);
                        }
                        DependencyXMLizer _xmlizer = new DependencyXMLizer();
                        for (Object e : _das) {
                            if (Pattern.matches(_ignoreDARegex, e.getClass().getName())) continue;
                            XMLBasedDependencyAnalysisTest _xmlTest = new XMLBasedDependencyAnalysisTest((IDependencyAnalysis)e, _xmlizer);
                            _temp.addTest((Test)_xmlTest);
                        }
                        _temp.addTestSuite(XMLBasedCallGraphTest.class);
                        _temp.addTestSuite(OFABasedCallGraphTest.class);
                        _temp.addTestSuite(XMLBasedOFATest.class);
                        _temp.addTestSuite(FATest.class);
                        TestHelper.appendSuiteNameToTestsIn((TestSuite)_temp, (boolean)true);
                        DependencyAnalysisTestSetup dependencyAnalysisTestSetup = new DependencyAnalysisTestSetup(_temp, _classNames, _classpath);
                        dependencyAnalysisTestSetup.setIdGenerator((IJimpleIDGenerator)new UniqueJimpleIDGenerator());
                        dependencyAnalysisTestSetup.setJimpleXMLDumpLocation(_jimpleXMLDumpDir);
                        dependencyAnalysisTestSetup.setStmtGraphFactory((IStmtGraphFactory)_stmtGraphFactory);
                        dependencyAnalysisTestSetup.setXMLTestDir(_xmlTestDir);
                        dependencyAnalysisTestSetup.setXMLControlDir(_xmlControlDir);
                        suite.addTest((Test)dependencyAnalysisTestSetup);
                    }
                }
                catch (IllegalArgumentException _e) {
                    _e.printStackTrace();
                }
                ++_i;
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Specified property file does not exist.");
        }
    }
}

