/*
 * Decompiled with CFR 0.152.
 */
package edu.ksu.cis.indus.staticanalyses.dependency;

import edu.ksu.cis.indus.IndusTestCase;
import edu.ksu.cis.indus.interfaces.IEnvironment;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysis;
import edu.ksu.cis.indus.staticanalyses.dependency.IDependencyAnalysisTest;
import soot.SootClass;
import soot.SootMethod;
import soot.jimple.Stmt;

public abstract class AbstractDependencyAnalysisTest
extends IndusTestCase
implements IDependencyAnalysisTest {
    private IDependencyAnalysis da;
    private IEnvironment env;

    protected AbstractDependencyAnalysisTest() {
        this.setName("testDependencyAnalysis");
    }

    public final void setDA(IDependencyAnalysis analysis) {
        this.da = analysis;
    }

    public final void testDependencyAnalysis() {
        for (SootClass _sc : this.env.getClasses()) {
            for (SootMethod _sm : _sc.getMethods()) {
                if (!_sm.isConcrete()) continue;
                for (Stmt _unit : _sm.retrieveActiveBody().getUnits()) {
                    this.verifyDAFor(_unit, _sm);
                }
            }
        }
    }

    public IDependencyAnalysis getDA() {
        return this.da;
    }

    public void setEnvironment(IEnvironment environment) {
        this.env = environment;
    }

    protected void tearDown() throws Exception {
        this.da = null;
        this.env = null;
        super.tearDown();
    }

    protected abstract void verifyDAFor(Stmt var1, SootMethod var2);

    protected final IDependencyAnalysis getDa() {
        return this.da;
    }
}

